/*
 * Decompiled with CFR 0.152.
 */
package by.stub;

import by.stub.cli.ANSITerminal;
import by.stub.cli.CommandLineInterpreter;
import by.stub.exception.Stubby4JException;
import by.stub.server.StubbyManager;
import by.stub.server.StubbyManagerFactory;
import java.util.Map;
import org.apache.commons.cli.ParseException;

public final class Main {
    private static CommandLineInterpreter commandLineInterpreter;

    private Main() {
    }

    public static void main(String[] args) {
        commandLineInterpreter = new CommandLineInterpreter();
        Main.parseCommandLineArgs(args);
        if (Main.printHelpIfRequested() || Main.printVersionIfRequested()) {
            return;
        }
        Main.verifyYamlDataProvided();
        Main.startStubby4jUsingCommandLineArgs();
    }

    private static void parseCommandLineArgs(String[] args) {
        try {
            commandLineInterpreter.parseCommandLine(args);
        }
        catch (ParseException ex) {
            String msg = String.format("Could not parse provided command line arguments, error: %s", ex.toString());
            throw new Stubby4JException(msg);
        }
    }

    private static boolean printHelpIfRequested() {
        if (!commandLineInterpreter.isHelp()) {
            return false;
        }
        commandLineInterpreter.printHelp();
        return true;
    }

    private static boolean printVersionIfRequested() {
        if (!commandLineInterpreter.isVersion()) {
            return false;
        }
        commandLineInterpreter.printVersion();
        return true;
    }

    private static void verifyYamlDataProvided() {
        if (commandLineInterpreter.isYamlProvided()) {
            return;
        }
        String msg = String.format("YAML data was not provided using command line option '--%s'. %sTo see all command line options run again with option '--%s'", "data", "\n", "help");
        throw new Stubby4JException(msg);
    }

    private static void startStubby4jUsingCommandLineArgs() {
        try {
            Map<String, String> commandLineArgs = commandLineInterpreter.getCommandlineParams();
            String yamlConfigFilename = commandLineArgs.get("data");
            ANSITerminal.muteConsole(commandLineInterpreter.isMute());
            StubbyManager stubbyManager = new StubbyManagerFactory().construct(yamlConfigFilename, commandLineArgs);
            stubbyManager.startJetty();
        }
        catch (Exception ex) {
            String msg = String.format("Could not init stubby4j, error: %s", ex.toString());
            throw new Stubby4JException(msg, ex);
        }
    }
}

