/*
 * Decompiled with CFR 0.152.
 */
package by.stub.cli;

public final class ANSITerminal {
    private static final char ESCAPE = '\u001b';
    private static final String BOLD = String.format("%s[1m", Character.valueOf('\u001b'));
    private static final String RESET = String.format("%s[0m", Character.valueOf('\u001b'));
    private static final String BLACK = String.format("%s[30m", Character.valueOf('\u001b'));
    private static final String BOLD_BLACK = String.format("%s%s", BOLD, BLACK);
    private static final String BLUE = String.format("%s[34m", Character.valueOf('\u001b'));
    private static final String CYAN = String.format("%s[36m", Character.valueOf('\u001b'));
    private static final String GREEN = String.format("%s[32m", Character.valueOf('\u001b'));
    private static final String MAGENTA = String.format("%s[35m", Character.valueOf('\u001b'));
    private static final String RED = String.format("%s[31m", Character.valueOf('\u001b'));
    private static final String YELLOW = String.format("%s[33m", Character.valueOf('\u001b'));
    private static boolean mute = false;

    private ANSITerminal() {
    }

    private static void print(String color, String msg) {
        if (mute) {
            return;
        }
        System.out.println(String.format("%s%s%s", color, msg, RESET));
    }

    public static void log(String msg) {
        ANSITerminal.print("", msg);
    }

    public static void dump(String msg) {
        ANSITerminal.log(msg);
    }

    public static void status(String msg) {
        ANSITerminal.print(BOLD_BLACK, msg);
    }

    public static void info(String msg) {
        ANSITerminal.print(BLUE, msg);
    }

    public static void ok(String msg) {
        ANSITerminal.print(GREEN, msg);
    }

    public static void error(String msg) {
        ANSITerminal.print(RED, msg);
    }

    public static void warn(String msg) {
        ANSITerminal.print(YELLOW, msg);
    }

    public static void incoming(String msg) {
        ANSITerminal.print(CYAN, msg);
    }

    public static void loaded(String msg) {
        ANSITerminal.print(MAGENTA, msg);
    }

    public static void muteConsole(boolean isMute) {
        mute = isMute;
    }

    public static boolean isMute() {
        return mute;
    }
}

