/*
 * Decompiled with CFR 0.152.
 */
package by.stub.client;

import by.stub.annotations.CoberturaIgnore;
import by.stub.cli.CommandLineInterpreter;
import by.stub.client.StubbyRequest;
import by.stub.client.StubbyResponse;
import by.stub.http.StubbyHttpTransport;
import by.stub.server.StubbyManager;
import by.stub.server.StubbyManagerFactory;
import by.stub.utils.ObjectUtils;
import java.net.URL;

public final class StubbyClient {
    private StubbyManager stubbyManager;

    @CoberturaIgnore
    public void startJetty(String yamlConfigurationFilename) throws Exception {
        this.startJetty(8882, 7443, 8889, "localhost", yamlConfigurationFilename);
    }

    @CoberturaIgnore
    public void startJetty(int stubsPort, String yamlConfigurationFilename) throws Exception {
        this.startJetty(stubsPort, 7443, 8889, "localhost", yamlConfigurationFilename);
    }

    @CoberturaIgnore
    public void startJetty(int stubsPort, int adminPort, String yamlConfigurationFilename) throws Exception {
        this.startJetty(stubsPort, 7443, adminPort, "localhost", yamlConfigurationFilename);
    }

    @CoberturaIgnore
    public void startJetty(int stubsPort, int tlsPort, int adminPort, String yamlConfigurationFilename) throws Exception {
        this.startJetty(stubsPort, tlsPort, adminPort, "localhost", yamlConfigurationFilename);
    }

    @CoberturaIgnore
    public void startJetty(int stubsPort, int adminPort, String addressToBind, String yamlConfigurationFilename) throws Exception {
        this.startJetty(stubsPort, 7443, adminPort, addressToBind, yamlConfigurationFilename);
    }

    public void startJetty(int stubsPort, int tlsPort, int adminPort, String addressToBind, String yamlConfigurationFilename) throws Exception {
        String[] args = new String[]{"-m", "-l", addressToBind, "-s", String.valueOf(stubsPort), "-a", String.valueOf(adminPort), "-t", String.valueOf(tlsPort), "-d", yamlConfigurationFilename};
        CommandLineInterpreter commandLineInterpreter = new CommandLineInterpreter();
        commandLineInterpreter.parseCommandLine(args);
        this.stubbyManager = new StubbyManagerFactory().construct(yamlConfigurationFilename, commandLineInterpreter.getCommandlineParams());
        this.stubbyManager.startJetty();
    }

    @CoberturaIgnore
    public void stopJetty() throws Exception {
        if (ObjectUtils.isNotNull(this.stubbyManager)) {
            this.stubbyManager.stopJetty();
        }
    }

    public StubbyResponse doGet(String host, String uri, int stubsPort) throws Exception {
        return this.doGet(host, uri, stubsPort, null);
    }

    @CoberturaIgnore
    public StubbyResponse doGetOverSsl(String host, String uri) throws Exception {
        return this.doGetOverSsl(host, uri, 7443, null);
    }

    public StubbyResponse doGetOverSsl(String host, String uri, int port) throws Exception {
        return this.doGetOverSsl(host, uri, port, null);
    }

    public StubbyResponse doGetOverSsl(String host, String uri, int port, String encodedCredentials) throws Exception {
        StubbyRequest stubbyRequest = new StubbyRequest("https", "GET", uri, host, port, encodedCredentials);
        return this.makeRequest(stubbyRequest);
    }

    public StubbyResponse doGet(String host, String uri, int stubsPort, String encodedCredentials) throws Exception {
        StubbyRequest stubbyRequest = new StubbyRequest("http", "GET", uri, host, stubsPort, encodedCredentials);
        return this.makeRequest(stubbyRequest);
    }

    public StubbyResponse doGetUsingDefaults(String uri) throws Exception {
        return this.doGetUsingDefaults(uri, null);
    }

    public StubbyResponse doGetUsingDefaults(String uri, String encodedCredentials) throws Exception {
        return this.doGet("localhost", uri, 8882, encodedCredentials);
    }

    public StubbyResponse doPost(String host, String uri, int stubsPort, String post) throws Exception {
        return this.doPost(host, uri, stubsPort, null, post);
    }

    public StubbyResponse doPost(String host, String uri, int stubsPort, String encodedCredentials, String post) throws Exception {
        StubbyRequest stubbyRequest = new StubbyRequest("http", "POST", uri, host, stubsPort, encodedCredentials, post);
        return this.makeRequest(stubbyRequest);
    }

    public StubbyResponse doPostUsingDefaults(String uri, String post) throws Exception {
        return this.doPostUsingDefaults(uri, post, null);
    }

    public StubbyResponse doPostUsingDefaults(String uri, String post, String encodedCredentials) throws Exception {
        return this.doPost("localhost", uri, 8882, encodedCredentials, post);
    }

    public StubbyResponse updateStubbedData(String url, String stubsData) throws Exception {
        URL adminUrl = new URL(url);
        return this.makeRequest(adminUrl.getProtocol(), "POST", adminUrl.getHost(), adminUrl.getPath(), adminUrl.getPort(), stubsData);
    }

    public StubbyResponse makeRequest(String scheme, String method, String host, String uri, int port, String post) throws Exception {
        StubbyRequest stubbyRequest = new StubbyRequest(scheme, method, uri, host, port, null, post);
        return this.makeRequest(stubbyRequest);
    }

    private StubbyResponse makeRequest(StubbyRequest stubbyRequest) throws Exception {
        return new StubbyHttpTransport().getResponse(stubbyRequest.getMethod(), stubbyRequest.constructFullUrl(), stubbyRequest.getPost(), stubbyRequest.getBase64encodedCredentials(), stubbyRequest.calculatePostLength());
    }
}

