/*
 * Decompiled with CFR 0.152.
 */
package by.stub.client;

import by.stub.utils.StringUtils;

final class StubbyRequest {
    private static final String URL_TEMPLATE = "%s://%s:%s%s";
    private final String scheme;
    private final String method;
    private final String uri;
    private final String host;
    private final String post;
    private final String base64encodedCredentials;
    private final int clientPort;

    StubbyRequest(String scheme, String method, String uri, String host, int port, String newBase64encodedCredentials) {
        this(scheme, method, uri, host, port, newBase64encodedCredentials, null);
    }

    StubbyRequest(String scheme, String method, String uri, String host, int clientPort, String newBase64encodedCredentials, String post) {
        this.scheme = scheme;
        this.method = method;
        this.uri = uri;
        this.host = host;
        this.clientPort = clientPort;
        this.post = post;
        this.base64encodedCredentials = newBase64encodedCredentials;
    }

    String getMethod() {
        return this.method;
    }

    String getPost() {
        return StringUtils.isSet(this.post) ? this.post : "";
    }

    String getBase64encodedCredentials() {
        return this.base64encodedCredentials;
    }

    public String constructFullUrl() {
        return String.format(URL_TEMPLATE, this.scheme, this.host, this.clientPort, StringUtils.isSet(this.uri) ? this.uri : "");
    }

    public int calculatePostLength() {
        if (StringUtils.isSet(this.post)) {
            return this.post.getBytes(StringUtils.charsetUTF8()).length;
        }
        return 0;
    }
}

