/*
 * Decompiled with CFR 0.152.
 */
package by.stub.database.thread;

import by.stub.cli.ANSITerminal;
import by.stub.database.StubbedDataManager;
import by.stub.yaml.YamlParser;
import java.io.File;
import java.util.Date;

public final class MainYamlScanner
implements Runnable {
    private final long sleepTime;
    private final StubbedDataManager stubbedDataManager;

    public MainYamlScanner(StubbedDataManager stubbedDataManager, long sleepTime) {
        this.sleepTime = sleepTime;
        this.stubbedDataManager = stubbedDataManager;
        ANSITerminal.status(String.format("Main YAML scan enabled, watching %s", stubbedDataManager.getYamlCanonicalPath()));
    }

    @Override
    public void run() {
        try {
            File dataYaml = this.stubbedDataManager.getDataYaml();
            long mainYamlLastModified = dataYaml.lastModified();
            while (!Thread.currentThread().isInterrupted()) {
                Thread.sleep(this.sleepTime);
                long currentFileModified = dataYaml.lastModified();
                if (mainYamlLastModified >= currentFileModified) continue;
                ANSITerminal.info(String.format("\nMain YAML scan detected change in %s\n", this.stubbedDataManager.getYamlCanonicalPath()));
                try {
                    mainYamlLastModified = currentFileModified;
                    this.stubbedDataManager.refreshStubbedData(new YamlParser());
                    ANSITerminal.ok(String.format("%sSuccessfully performed live refresh of main YAML file from: %s on [" + new Date().toString().trim() + "]%s", "\n", dataYaml.getAbsolutePath(), "\n"));
                }
                catch (Exception ex) {
                    ANSITerminal.error("Could not refresh YAML file: " + ex.toString());
                    ANSITerminal.warn(String.format("YAML refresh aborted, in-memory stubs remain untouched", new Object[0]));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ANSITerminal.error("Could not perform live YAML scan: " + ex.toString());
        }
    }
}

