/*
 * Decompiled with CFR 0.152.
 */
package by.stub.http;

import by.stub.client.StubbyResponse;
import by.stub.exception.Stubby4JException;
import by.stub.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class StubbyHttpTransport {
    private static final Set<String> SUPPORTED_METHODS = new HashSet<String>(){
        {
            this.add("GET");
            this.add("HEAD");
            this.add("TRACE");
            this.add("OPTIONS");
            this.add("POST");
        }
    };
    private static final Set<String> POSTING_METHODS = new HashSet<String>(){
        {
            this.add("PUT");
            this.add("POST");
        }
    };

    public StubbyResponse getResponse(String method, String fullUrl) throws IOException {
        return this.getResponse(method, fullUrl, null, null, -1);
    }

    public StubbyResponse getResponse(String method, String fullUrl, String post, String encodedCredentials, int postLength) throws IOException {
        if (!SUPPORTED_METHODS.contains(method)) {
            throw new Stubby4JException(String.format("HTTP method '%s' not supported when contacting stubby4j", method));
        }
        URL url = new URL(fullUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        this.setRequestHeaders(connection, encodedCredentials, postLength);
        if (POSTING_METHODS.contains(method)) {
            this.writeOutputStream(connection, post);
        }
        return this.buildStubbyResponse(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StubbyResponse buildStubbyResponse(HttpURLConnection connection) throws IOException {
        try {
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200 || responseCode == 201) {
                InputStream inputStream = connection.getInputStream();
                String responseContent = StringUtils.inputStreamToString(inputStream);
                inputStream.close();
                StubbyResponse stubbyResponse = new StubbyResponse(responseCode, responseContent);
                return stubbyResponse;
            }
            StubbyResponse stubbyResponse = new StubbyResponse(responseCode, connection.getResponseMessage());
            return stubbyResponse;
        }
        finally {
            connection.disconnect();
        }
    }

    private void setRequestHeaders(HttpURLConnection connection, String encodedCredentials, int postLength) {
        String requestMethod;
        connection.setRequestProperty("User-Agent", StringUtils.constructUserAgentName());
        if (StringUtils.isSet(encodedCredentials)) {
            connection.setRequestProperty("Authorization", "Basic " + encodedCredentials);
        }
        if ("POST".equals(requestMethod = connection.getRequestMethod()) || "PUT".equals(requestMethod)) {
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Language", "en-US");
            connection.setRequestProperty("Content-Encoding", "UTF-8");
            connection.setRequestProperty("Content-Length", Integer.toString(postLength));
            if (postLength > 0) {
                connection.setFixedLengthStreamingMode(postLength);
            } else {
                connection.setChunkedStreamingMode(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutputStream(HttpURLConnection connection, String post) throws IOException {
        OutputStreamWriter streamWriter = new OutputStreamWriter(connection.getOutputStream(), StringUtils.charsetUTF8());
        try {
            streamWriter.write(post);
            streamWriter.flush();
        }
        finally {
            streamWriter.close();
        }
    }
}

