/*
 * Decompiled with CFR 0.152.
 */
package by.stub.server;

import by.stub.cli.ANSITerminal;
import org.eclipse.jetty.server.Server;

public final class StubbyManager {
    private final Server server;

    public StubbyManager(Server server) {
        this.server = server;
    }

    public synchronized void startJetty() throws Exception {
        if (this.isJettyStarting() || this.isJettyUp()) {
            return;
        }
        this.server.start();
        while (!this.isJettyUp()) {
            ANSITerminal.warn("Waiting for Jetty to finish starting up..");
            Thread.sleep(250L);
        }
        ANSITerminal.status("Jetty successfully started");
        ANSITerminal.info("\nQuit: ctrl-c\n");
    }

    public synchronized void stopJetty() throws Exception {
        if (this.isJettyStopping() || this.isJettyDown()) {
            return;
        }
        int timeoutMilliseconds = 100;
        this.server.setGracefulShutdown(100);
        this.server.setStopAtShutdown(true);
        this.server.stop();
        while (!this.isJettyDown()) {
            ANSITerminal.warn("Waiting for Jetty to finish shutting down..");
            Thread.sleep(250L);
        }
        ANSITerminal.status("Jetty successfully shutdown");
    }

    private boolean isJettyStarting() throws Exception {
        return this.server.isStarting();
    }

    private boolean isJettyUp() throws Exception {
        return this.server.isStarted() && this.server.isRunning();
    }

    private boolean isJettyStopping() throws Exception {
        return this.server.isStopping();
    }

    private boolean isJettyDown() throws Exception {
        return this.server.isStopped() && !this.server.isRunning();
    }
}

