/*
 * Decompiled with CFR 0.152.
 */
package by.stub.yaml.stubs;

import by.stub.annotations.CoberturaIgnore;
import by.stub.utils.FileUtils;
import by.stub.utils.ObjectUtils;
import by.stub.utils.StringUtils;
import by.stub.yaml.stubs.StubResponseTypes;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

public class StubResponse {
    public static final String STUBBY_RESOURCE_ID_HEADER = "x-stubby-resource-id";
    private final String status;
    private final String body;
    private final File file;
    private final byte[] fileBytes;
    private final String latency;
    private final Map<String, String> headers;

    public StubResponse(String status, String body, File file, String latency, Map<String, String> headers) {
        this.status = ObjectUtils.isNull(status) ? "200" : status;
        this.body = body;
        this.file = file;
        this.fileBytes = ObjectUtils.isNull(file) ? new byte[]{} : this.getFileBytes();
        this.latency = latency;
        this.headers = ObjectUtils.isNull(headers) ? new LinkedHashMap() : headers;
    }

    public String getStatus() {
        return this.status;
    }

    public String getBody() {
        return StringUtils.isSet(this.body) ? this.body : "";
    }

    public boolean isRecordingRequired() {
        String body = this.getBody();
        return StringUtils.toLower(body).startsWith("http");
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getLatency() {
        return this.latency;
    }

    public byte[] getFile() {
        return this.fileBytes;
    }

    public File getRawFile() {
        return this.file;
    }

    public byte[] getResponseBodyAsBytes() {
        if (this.fileBytes.length == 0) {
            return this.getBody().getBytes(StringUtils.charsetUTF8());
        }
        return this.fileBytes;
    }

    public boolean isContainsTemplateTokens() {
        boolean isFileTemplate = this.fileBytes.length == 0 ? false : this.isTemplateFile();
        return isFileTemplate || this.getBody().contains("<%");
    }

    @CoberturaIgnore
    private boolean isTemplateFile() {
        try {
            return FileUtils.isTemplateFile(this.file);
        }
        catch (Exception e) {
            return false;
        }
    }

    @CoberturaIgnore
    private byte[] getFileBytes() {
        try {
            return FileUtils.fileToBytes(this.file);
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public boolean hasHeaderLocation() {
        return this.getHeaders().containsKey("location");
    }

    void addResourceIDHeader(int httplifeCycleIndex) {
        this.getHeaders().remove(STUBBY_RESOURCE_ID_HEADER);
        LinkedHashMap<String, String> shuffledHeaders = new LinkedHashMap<String, String>();
        shuffledHeaders.put(STUBBY_RESOURCE_ID_HEADER, String.valueOf(httplifeCycleIndex));
        shuffledHeaders.putAll(new LinkedHashMap<String, String>(this.getHeaders()));
        this.getHeaders().clear();
        this.getHeaders().putAll(shuffledHeaders);
    }

    public StubResponseTypes getStubResponseType() {
        return StubResponseTypes.OK_200;
    }

    public static StubResponse newStubResponse() {
        return new StubResponse(null, null, null, null, null);
    }

    public static StubResponse newStubResponse(String status, String body) {
        return new StubResponse(status, body, null, null, null);
    }
}

