/*
 * Decompiled with CFR 0.152.
 */
package ca.szc.maven.jsonpath;

import ca.szc.maven.jsonpath.ConventionalPrettyPrinter;
import ca.szc.maven.jsonpath.ModifyMojoModifications;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="modify", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ModifyMojo
extends AbstractMojo {
    @Parameter(property="jsonpath.file", required=true)
    private String file;
    @Parameter(property="jsonpath.outputFile", required=false)
    private String outputFile;
    @Parameter(property="jsonpath.formatter", defaultValue="conventional", required=false)
    private String formatter;
    @Parameter(required=true)
    private List<ModifyMojoModifications> modifications;

    public void execute() throws MojoExecutionException {
        DocumentContext json;
        FileSystem fs = FileSystems.getDefault();
        Path inputJson = fs.getPath(this.file, new String[0]);
        Path outputJson = this.outputFile == null ? inputJson : fs.getPath(this.outputFile, new String[0]);
        Configuration configuration = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).build();
        try {
            InputStream in = Files.newInputStream(inputJson, new OpenOption[0]);
            Object object = null;
            try {
                json = JsonPath.using((Configuration)configuration).parse(in, "UTF-8");
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Unable to read input json file");
            throw new MojoExecutionException("Unable to read file '" + this.file + "'", (Exception)e);
        }
        int count = 0;
        for (ModifyMojoModifications modification : this.modifications) {
            String expression = modification.getExpression();
            String value = modification.getValue();
            json.set(expression, (Object)value, new Predicate[0]);
            this.getLog().info((CharSequence)(expression + "=" + value));
            ++count;
        }
        try (OutputStream out = Files.newOutputStream(outputJson, new OpenOption[0]);){
            ConventionalPrettyPrinter prettyPrinter;
            if ("conventional".equals(this.formatter)) {
                prettyPrinter = new ConventionalPrettyPrinter();
            } else if ("jackson".equals(this.formatter)) {
                prettyPrinter = new DefaultPrettyPrinter();
            } else {
                this.getLog().error((CharSequence)"Invalid JSON formatter specified");
                throw new MojoExecutionException("Unknown formatter '" + this.formatter + "'");
            }
            ObjectWriter writer = new ObjectMapper().writer((PrettyPrinter)prettyPrinter);
            writer.writeValue(out, json.json());
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Unable to write output json file");
            throw new MojoExecutionException("Unable write file '" + outputJson + "'", (Exception)e);
        }
        if (count == 0) {
            this.getLog().error((CharSequence)(count + " modifications written to json file " + outputJson));
            throw new MojoExecutionException("No properties were defined for setting");
        }
        this.getLog().info((CharSequence)(count + " modifications written to json file " + outputJson));
    }
}

