/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.SRM_S01_PATIENT;
import ca.uhn.hl7v2.model.v251.group.SRM_S01_RESOURCES;
import ca.uhn.hl7v2.model.v251.segment.APR;
import ca.uhn.hl7v2.model.v251.segment.ARQ;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRM_S01
extends AbstractMessage {
    public SRM_S01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public SRM_S01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(ARQ.class, true, false);
            this.add(APR.class, false, false);
            this.add(NTE.class, false, true);
            this.add(SRM_S01_PATIENT.class, false, true);
            this.add(SRM_S01_RESOURCES.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating SRM_S01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public ARQ getARQ() {
        return (ARQ)this.getTyped("ARQ", ARQ.class);
    }

    public APR getAPR() {
        return (APR)this.getTyped("APR", APR.class);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public SRM_S01_PATIENT getPATIENT() {
        return (SRM_S01_PATIENT)this.getTyped("PATIENT", SRM_S01_PATIENT.class);
    }

    public SRM_S01_PATIENT getPATIENT(int rep) {
        return (SRM_S01_PATIENT)this.getTyped("PATIENT", rep, SRM_S01_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<SRM_S01_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", SRM_S01_PATIENT.class);
    }

    public void insertPATIENT(SRM_S01_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", (Structure)structure, rep);
    }

    public SRM_S01_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (SRM_S01_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public SRM_S01_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (SRM_S01_PATIENT)super.removeRepetition("PATIENT", rep);
    }

    public SRM_S01_RESOURCES getRESOURCES() {
        return (SRM_S01_RESOURCES)this.getTyped("RESOURCES", SRM_S01_RESOURCES.class);
    }

    public SRM_S01_RESOURCES getRESOURCES(int rep) {
        return (SRM_S01_RESOURCES)this.getTyped("RESOURCES", rep, SRM_S01_RESOURCES.class);
    }

    public int getRESOURCESReps() {
        return this.getReps("RESOURCES");
    }

    public List<SRM_S01_RESOURCES> getRESOURCESAll() throws HL7Exception {
        return this.getAllAsList("RESOURCES", SRM_S01_RESOURCES.class);
    }

    public void insertRESOURCES(SRM_S01_RESOURCES structure, int rep) throws HL7Exception {
        super.insertRepetition("RESOURCES", (Structure)structure, rep);
    }

    public SRM_S01_RESOURCES insertRESOURCES(int rep) throws HL7Exception {
        return (SRM_S01_RESOURCES)super.insertRepetition("RESOURCES", rep);
    }

    public SRM_S01_RESOURCES removeRESOURCES(int rep) throws HL7Exception {
        return (SRM_S01_RESOURCES)super.removeRepetition("RESOURCES", rep);
    }
}

