/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.ORF_R04_OBSERVATION;
import ca.uhn.hl7v2.model.v26.group.ORF_R04_TIMING_QTY;
import ca.uhn.hl7v2.model.v26.segment.CTD;
import ca.uhn.hl7v2.model.v26.segment.CTI;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.OBR;
import ca.uhn.hl7v2.model.v26.segment.ORC;
import ca.uhn.hl7v2.model.v26.segment.ROL;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORF_R04_ORDER
extends AbstractGroup {
    public ORF_R04_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, false, false, false);
            this.add(OBR.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(ROL.class, false, true, false);
            this.add(ORF_R04_TIMING_QTY.class, false, true, false);
            this.add(CTD.class, false, false, false);
            this.add(ORF_R04_OBSERVATION.class, true, true, false);
            this.add(CTI.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ORF_R04_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public OBR getOBR() {
        OBR retVal = (OBR)this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public ROL getROL() {
        ROL retVal = (ROL)this.getTyped("ROL", ROL.class);
        return retVal;
    }

    public ROL getROL(int rep) {
        ROL retVal = (ROL)this.getTyped("ROL", rep, ROL.class);
        return retVal;
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", (Structure)structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public ORF_R04_TIMING_QTY getTIMING_QTY() {
        ORF_R04_TIMING_QTY retVal = (ORF_R04_TIMING_QTY)this.getTyped("TIMING_QTY", ORF_R04_TIMING_QTY.class);
        return retVal;
    }

    public ORF_R04_TIMING_QTY getTIMING_QTY(int rep) {
        ORF_R04_TIMING_QTY retVal = (ORF_R04_TIMING_QTY)this.getTyped("TIMING_QTY", rep, ORF_R04_TIMING_QTY.class);
        return retVal;
    }

    public int getTIMING_QTYReps() {
        return this.getReps("TIMING_QTY");
    }

    public List<ORF_R04_TIMING_QTY> getTIMING_QTYAll() throws HL7Exception {
        return this.getAllAsList("TIMING_QTY", ORF_R04_TIMING_QTY.class);
    }

    public void insertTIMING_QTY(ORF_R04_TIMING_QTY structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_QTY", (Structure)structure, rep);
    }

    public ORF_R04_TIMING_QTY insertTIMING_QTY(int rep) throws HL7Exception {
        return (ORF_R04_TIMING_QTY)super.insertRepetition("TIMING_QTY", rep);
    }

    public ORF_R04_TIMING_QTY removeTIMING_QTY(int rep) throws HL7Exception {
        return (ORF_R04_TIMING_QTY)super.removeRepetition("TIMING_QTY", rep);
    }

    public CTD getCTD() {
        CTD retVal = (CTD)this.getTyped("CTD", CTD.class);
        return retVal;
    }

    public ORF_R04_OBSERVATION getOBSERVATION() {
        ORF_R04_OBSERVATION retVal = (ORF_R04_OBSERVATION)this.getTyped("OBSERVATION", ORF_R04_OBSERVATION.class);
        return retVal;
    }

    public ORF_R04_OBSERVATION getOBSERVATION(int rep) {
        ORF_R04_OBSERVATION retVal = (ORF_R04_OBSERVATION)this.getTyped("OBSERVATION", rep, ORF_R04_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<ORF_R04_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", ORF_R04_OBSERVATION.class);
    }

    public void insertOBSERVATION(ORF_R04_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public ORF_R04_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (ORF_R04_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public ORF_R04_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (ORF_R04_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public CTI getCTI() {
        CTI retVal = (CTI)this.getTyped("CTI", CTI.class);
        return retVal;
    }

    public CTI getCTI(int rep) {
        CTI retVal = (CTI)this.getTyped("CTI", rep, CTI.class);
        return retVal;
    }

    public int getCTIReps() {
        return this.getReps("CTI");
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", (Structure)structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }
}

