/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.ORL_O34_OBSERVATION_REQUEST;
import ca.uhn.hl7v2.model.v26.group.ORL_O34_TIMING;
import ca.uhn.hl7v2.model.v26.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORL_O34_ORDER
extends AbstractGroup {
    public ORL_O34_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(ORL_O34_TIMING.class, false, true, false);
            this.add(ORL_O34_OBSERVATION_REQUEST.class, false, false, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ORL_O34_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public ORL_O34_TIMING getTIMING() {
        ORL_O34_TIMING retVal = (ORL_O34_TIMING)this.getTyped("TIMING", ORL_O34_TIMING.class);
        return retVal;
    }

    public ORL_O34_TIMING getTIMING(int rep) {
        ORL_O34_TIMING retVal = (ORL_O34_TIMING)this.getTyped("TIMING", rep, ORL_O34_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<ORL_O34_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", ORL_O34_TIMING.class);
    }

    public void insertTIMING(ORL_O34_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public ORL_O34_TIMING insertTIMING(int rep) throws HL7Exception {
        return (ORL_O34_TIMING)super.insertRepetition("TIMING", rep);
    }

    public ORL_O34_TIMING removeTIMING(int rep) throws HL7Exception {
        return (ORL_O34_TIMING)super.removeRepetition("TIMING", rep);
    }

    public ORL_O34_OBSERVATION_REQUEST getOBSERVATION_REQUEST() {
        ORL_O34_OBSERVATION_REQUEST retVal = (ORL_O34_OBSERVATION_REQUEST)this.getTyped("OBSERVATION_REQUEST", ORL_O34_OBSERVATION_REQUEST.class);
        return retVal;
    }
}

