/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.EHC_E12_REQUEST;
import ca.uhn.hl7v2.model.v26.segment.CTD;
import ca.uhn.hl7v2.model.v26.segment.IVC;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.model.v26.segment.PSG;
import ca.uhn.hl7v2.model.v26.segment.PSL;
import ca.uhn.hl7v2.model.v26.segment.PSS;
import ca.uhn.hl7v2.model.v26.segment.RFI;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EHC_E12
extends AbstractMessage {
    public EHC_E12() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public EHC_E12(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, true);
            this.add(RFI.class, true, false);
            this.add(CTD.class, false, true);
            this.add(IVC.class, true, false);
            this.add(PSS.class, true, false);
            this.add(PSG.class, true, false);
            this.add(PID.class, false, false);
            this.add(PSL.class, false, true);
            this.add(EHC_E12_REQUEST.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating EHC_E12 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public UAC getUAC(int rep) {
        return (UAC)this.getTyped("UAC", rep, UAC.class);
    }

    public int getUACReps() {
        return this.getReps("UAC");
    }

    public List<UAC> getUACAll() throws HL7Exception {
        return this.getAllAsList("UAC", UAC.class);
    }

    public void insertUAC(UAC structure, int rep) throws HL7Exception {
        super.insertRepetition("UAC", (Structure)structure, rep);
    }

    public UAC insertUAC(int rep) throws HL7Exception {
        return (UAC)super.insertRepetition("UAC", rep);
    }

    public UAC removeUAC(int rep) throws HL7Exception {
        return (UAC)super.removeRepetition("UAC", rep);
    }

    public RFI getRFI() {
        return (RFI)this.getTyped("RFI", RFI.class);
    }

    public CTD getCTD() {
        return (CTD)this.getTyped("CTD", CTD.class);
    }

    public CTD getCTD(int rep) {
        return (CTD)this.getTyped("CTD", rep, CTD.class);
    }

    public int getCTDReps() {
        return this.getReps("CTD");
    }

    public List<CTD> getCTDAll() throws HL7Exception {
        return this.getAllAsList("CTD", CTD.class);
    }

    public void insertCTD(CTD structure, int rep) throws HL7Exception {
        super.insertRepetition("CTD", (Structure)structure, rep);
    }

    public CTD insertCTD(int rep) throws HL7Exception {
        return (CTD)super.insertRepetition("CTD", rep);
    }

    public CTD removeCTD(int rep) throws HL7Exception {
        return (CTD)super.removeRepetition("CTD", rep);
    }

    public IVC getIVC() {
        return (IVC)this.getTyped("IVC", IVC.class);
    }

    public PSS getPSS() {
        return (PSS)this.getTyped("PSS", PSS.class);
    }

    public PSG getPSG() {
        return (PSG)this.getTyped("PSG", PSG.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PSL getPSL() {
        return (PSL)this.getTyped("PSL", PSL.class);
    }

    public PSL getPSL(int rep) {
        return (PSL)this.getTyped("PSL", rep, PSL.class);
    }

    public int getPSLReps() {
        return this.getReps("PSL");
    }

    public List<PSL> getPSLAll() throws HL7Exception {
        return this.getAllAsList("PSL", PSL.class);
    }

    public void insertPSL(PSL structure, int rep) throws HL7Exception {
        super.insertRepetition("PSL", (Structure)structure, rep);
    }

    public PSL insertPSL(int rep) throws HL7Exception {
        return (PSL)super.insertRepetition("PSL", rep);
    }

    public PSL removePSL(int rep) throws HL7Exception {
        return (PSL)super.removeRepetition("PSL", rep);
    }

    public EHC_E12_REQUEST getREQUEST() {
        return (EHC_E12_REQUEST)this.getTyped("REQUEST", EHC_E12_REQUEST.class);
    }

    public EHC_E12_REQUEST getREQUEST(int rep) {
        return (EHC_E12_REQUEST)this.getTyped("REQUEST", rep, EHC_E12_REQUEST.class);
    }

    public int getREQUESTReps() {
        return this.getReps("REQUEST");
    }

    public List<EHC_E12_REQUEST> getREQUESTAll() throws HL7Exception {
        return this.getAllAsList("REQUEST", EHC_E12_REQUEST.class);
    }

    public void insertREQUEST(EHC_E12_REQUEST structure, int rep) throws HL7Exception {
        super.insertRepetition("REQUEST", (Structure)structure, rep);
    }

    public EHC_E12_REQUEST insertREQUEST(int rep) throws HL7Exception {
        return (EHC_E12_REQUEST)super.insertRepetition("REQUEST", rep);
    }

    public EHC_E12_REQUEST removeREQUEST(int rep) throws HL7Exception {
        return (EHC_E12_REQUEST)super.removeRepetition("REQUEST", rep);
    }
}

