/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container.weblogic;

import java.io.File;
import java.io.IOException;
import org.apache.cactus.integration.ant.container.AbstractJavaContainer;
import org.apache.cactus.integration.ant.util.ResourceUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ZipFileSet;

public class WebLogic7xContainer
extends AbstractJavaContainer {
    private File beaHome;
    private File dir;
    private int port = 8080;
    private File tmpDir;

    public final void setBeaHome(File theBeaHome) {
        this.beaHome = theBeaHome;
    }

    public final void setDir(File theDir) {
        this.dir = theDir;
    }

    public final void setPort(int thePort) {
        this.port = thePort;
    }

    public final void setTmpDir(File theTmpDir) {
        this.tmpDir = theTmpDir;
    }

    public final String getName() {
        return "WebLogic 7.x";
    }

    public final int getPort() {
        return this.port;
    }

    public final void init() {
        if (!this.dir.isDirectory()) {
            throw new BuildException(this.dir + " is not a directory");
        }
    }

    public final void startUp() {
        try {
            this.prepare("cactus/weblogic7x");
            Java java = this.createJavaForStartUp();
            java.setDir(new File(this.tmpDir, "testdomain"));
            java.createJvmarg().setValue("-hotspot");
            java.createJvmarg().setValue("-ms64m");
            java.createJvmarg().setValue("-mx64m");
            File serverDir = new File(this.dir, "server");
            Path libraryPath = new Path(this.getProject());
            libraryPath.createPathElement().setPath(this.getProject().getProperty("java.library.path"));
            libraryPath.createPathElement().setLocation(new File(serverDir, "bin"));
            java.addSysproperty(this.createSysProperty("java.library.path", libraryPath));
            java.addSysproperty(this.createSysProperty("weblogic.Name", "testserver"));
            java.addSysproperty(this.createSysProperty("bea.home", this.beaHome));
            java.addSysproperty(this.createSysProperty("weblogic.management.username", "system"));
            java.addSysproperty(this.createSysProperty("weblogic.management.password", "password"));
            java.addSysproperty(this.createSysProperty("java.security.policy", "=./server/lib/weblogic.policy"));
            Path classpath = java.createClasspath();
            classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic_sp.jar"));
            classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic.jar"));
            java.setClassname("weblogic.Server");
            java.execute();
        }
        catch (IOException ioe) {
            this.getLog().error((Object)"Failed to startup the container", (Throwable)ioe);
            throw new BuildException((Throwable)ioe);
        }
    }

    public final void shutDown() {
        Java java = this.createJavaForShutDown();
        File serverDir = new File(this.dir, "server");
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic_sp.jar"));
        classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic.jar"));
        java.setClassname("weblogic.Admin");
        java.createArg().setValue("-url");
        java.createArg().setValue("t3://localhost:" + this.getPort());
        java.createArg().setValue("-username");
        java.createArg().setValue("system");
        java.createArg().setValue("-password");
        java.createArg().setValue("password");
        java.createArg().setValue("SHUTDOWN");
        java.execute();
    }

    private void prepare(String theDirName) throws IOException {
        FilterChain filterChain = this.createFilterChain();
        if (this.tmpDir == null) {
            this.tmpDir = this.createTempDirectory(theDirName);
        }
        File testDomainDir = this.createDirectory(this.tmpDir, "testdomain");
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/weblogic7x/config.xml", new File(testDomainDir, "config.xml"), filterChain);
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/weblogic7x/fileRealm.properties", new File(testDomainDir, "fileRealm.properties"), filterChain);
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/weblogic7x/fileRealm.properties", new File(testDomainDir, "fileRealm.properties"), filterChain);
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/weblogic7x/SerializedSystemIni.dat", new File(testDomainDir, "SerializedSystemIni.dat"), filterChain);
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/weblogic7x/DefaultAuthenticatorInit.ldift", new File(testDomainDir, "DefaultAuthenticatorInit.ldift"), filterChain);
        File testServerDir = this.createDirectory(testDomainDir, "testserver");
        File ldapFilesDir = this.createDirectory(testServerDir, "ldap/ldapfiles");
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/weblogic7x/testserver/ldap/ldapfiles/EmbeddedLDAP.data", new File(ldapFilesDir, "EmbeddedLDAP.data"), filterChain);
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/weblogic7x/testserver/ldap/ldapfiles/EmbeddedLDAP.delete", new File(ldapFilesDir, "EmbeddedLDAP.delete"), filterChain);
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/weblogic7x/testserver/ldap/ldapfiles/EmbeddedLDAP.index", new File(ldapFilesDir, "EmbeddedLDAP.index"), filterChain);
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/weblogic7x/testserver/ldap/ldapfiles/EmbeddedLDAP.tran", new File(ldapFilesDir, "EmbeddedLDAP.tran"), filterChain);
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/weblogic7x/testserver/ldap/ldapfiles/EmbeddedLDAP.trpos", new File(ldapFilesDir, "EmbeddedLDAP.trpos"), filterChain);
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/weblogic7x/testserver/ldap/ldapfiles/EmbeddedLDAP.twpos", new File(ldapFilesDir, "EmbeddedLDAP.trwpos"), filterChain);
        File weblogicXml = new File(this.tmpDir, "weblogic.xml");
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/weblogic7x/weblogic.xml", weblogicXml, filterChain);
        File applicationsDir = this.createDirectory(testDomainDir, "applications");
        Jar jar = (Jar)this.createAntTask("jar");
        jar.setDestFile(new File(applicationsDir, this.getDeployableFile().getName()));
        ZipFileSet zip = new ZipFileSet();
        zip.setSrc(this.getDeployableFile());
        jar.addZipfileset(zip);
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.tmpDir);
        fileSet.createInclude().setName("weblogic.xml");
        jar.addFileset(fileSet);
        jar.execute();
    }
}

