/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.cactus.integration.ant.container.Container;
import org.apache.cactus.integration.ant.util.AntLog;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.BuildException;

public final class ContainerRunner {
    private Container container;
    private URL url;
    private long timeout = 180000L;
    private long checkInterval = 500L;
    private long startUpWait = 1000L;
    private long shutDownWait = 2000L;
    private boolean alreadyRunning;
    private String serverName;
    private transient Log log = AntLog.NULL;

    public ContainerRunner(Container theContainer) {
        this.container = theContainer;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void startUpContainer() throws IllegalStateException {
        if (this.url == null) {
            throw new IllegalStateException("Property 'url' must be set");
        }
        this.alreadyRunning = this.isAvailable(this.url);
        if (this.alreadyRunning) {
            this.log.debug((Object)"Server is already running");
            return;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ContainerRunner.this.container.startUp();
            }
        });
        thread.start();
        long startTime = System.currentTimeMillis();
        do {
            if (System.currentTimeMillis() - startTime > this.timeout) {
                throw new BuildException("Failed to start the container after more than [" + this.timeout + "] ms.");
            }
            this.sleep(this.checkInterval);
            this.log.debug((Object)"Checking if server is up ...");
        } while (!this.isAvailable(this.url));
        this.sleep(this.startUpWait);
        this.serverName = this.retrieveServerName(this.url);
        this.log.trace((Object)("Server '" + this.serverName + "' started"));
    }

    public void shutDownContainer() throws IllegalStateException {
        if (this.url == null) {
            throw new IllegalStateException("Property 'url' must be set");
        }
        if (this.alreadyRunning) {
            return;
        }
        if (!this.isAvailable(this.url)) {
            this.log.debug((Object)"Server isn't running!");
            return;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ContainerRunner.this.container.shutDown();
            }
        });
        thread.start();
        do {
            this.sleep(this.checkInterval);
        } while (this.isAvailable(this.url));
        this.sleep(this.shutDownWait);
        this.log.debug((Object)"Server stopped!");
    }

    public void setCheckInterval(long theCheckInterval) {
        this.checkInterval = theCheckInterval;
    }

    public void setLog(Log theLog) {
        this.log = theLog;
    }

    public void setShutDownWait(long theShutDownWait) {
        this.shutDownWait = theShutDownWait;
    }

    public void setStartUpWait(long theStartUpWait) {
        this.startUpWait = theStartUpWait;
    }

    public void setTimeout(long theTimeout) {
        this.timeout = theTimeout;
    }

    public void setUrl(URL theUrl) {
        if (!theUrl.getProtocol().equals("http")) {
            throw new IllegalArgumentException("Not a HTTP URL");
        }
        this.url = theUrl;
    }

    private boolean isAvailable(URL theUrl) {
        boolean isUrlCallable = false;
        try {
            HttpURLConnection connection = (HttpURLConnection)theUrl.openConnection();
            connection.connect();
            ContainerRunner.readFully(connection);
            connection.disconnect();
            isUrlCallable = true;
        }
        catch (IOException e) {
            this.log.debug((Object)("Failed to connect to " + theUrl), (Throwable)e);
        }
        return isUrlCallable;
    }

    private String retrieveServerName(URL theUrl) {
        String retVal = null;
        try {
            HttpURLConnection connection = (HttpURLConnection)theUrl.openConnection();
            connection.connect();
            retVal = connection.getHeaderField("Server");
            connection.disconnect();
        }
        catch (IOException e) {
            this.log.debug((Object)("Could not get server name from " + theUrl), (Throwable)e);
        }
        return retVal;
    }

    static void readFully(HttpURLConnection theConnection) throws IOException {
        if (theConnection.getContentLength() != 0) {
            byte[] buf = new byte[256];
            InputStream in = theConnection.getInputStream();
            while (in.read(buf) != -1) {
            }
        }
    }

    private void sleep(long theMs) throws BuildException {
        try {
            Thread.sleep(theMs);
        }
        catch (InterruptedException e) {
            throw new BuildException("Interruption during sleep", (Throwable)e);
        }
    }
}

