/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cactus.integration.ant.container.EarDeployableFile;
import org.apache.cactus.integration.ant.container.WarParser;
import org.apache.cactus.integration.ant.deployment.ApplicationXml;
import org.apache.cactus.integration.ant.deployment.DefaultEarArchive;
import org.apache.cactus.integration.ant.deployment.EarArchive;
import org.apache.cactus.integration.ant.deployment.WarArchive;
import org.apache.tools.ant.BuildException;
import org.xml.sax.SAXException;

public class EarParser {
    public static final EarDeployableFile parse(File theDeployableFile) {
        EarDeployableFile deployable = new EarDeployableFile();
        try {
            deployable.setFile(theDeployableFile);
            DefaultEarArchive earArchive = new DefaultEarArchive(theDeployableFile);
            String webUri = EarParser.getUriOfCactifiedWebModule(earArchive);
            if (webUri == null) {
                throw new BuildException("Could not find cactified web module in the [" + theDeployableFile + "] EAR.");
            }
            WarArchive warArchive = earArchive.getWebModule(webUri);
            if (warArchive == null) {
                throw new BuildException("Could not find the WAR [" + webUri + "] in the [" + theDeployableFile + "] EAR.");
            }
            deployable.setWarArchive(warArchive);
            deployable.setTestContext(EarParser.parseTestContext(earArchive, webUri));
            deployable.setServletRedirectorMapping(WarParser.parseServletRedirectorMapping(deployable.getWarArchive()));
            deployable.setFilterRedirectorMapping(WarParser.parseFilterRedirectorMapping(deployable.getWarArchive()));
            deployable.setJspRedirectorMapping(WarParser.parseJspRedirectorMapping(deployable.getWarArchive()));
        }
        catch (IOException e) {
            throw new BuildException("Failed to parse deployment descriptor for EAR file [" + theDeployableFile + "].", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new BuildException("Failed to parse deployment descriptor for EAR file [" + theDeployableFile + "].", (Throwable)e);
        }
        catch (SAXException e) {
            throw new BuildException("Failed to parse deployment descriptor for EAR file [" + theDeployableFile + "].", (Throwable)e);
        }
        return deployable;
    }

    protected static final String parseTestContext(EarArchive theEar, String theWebUri) throws ParserConfigurationException, IOException, SAXException {
        String context = theEar.getApplicationXml().getWebModuleContextRoot(theWebUri);
        if (context == null) {
            throw new BuildException("Your application.xml must define a <context-root> element in the <web> module definition.");
        }
        if (context.startsWith("/")) {
            context = context.substring(1);
        }
        return context;
    }

    protected static final String getUriOfCactifiedWebModule(EarArchive theEar) throws SAXException, IOException, ParserConfigurationException {
        ApplicationXml applicationXml = theEar.getApplicationXml();
        Iterator i = applicationXml.getWebModuleUris();
        while (i.hasNext()) {
            String webUri = (String)i.next();
            WarArchive war = theEar.getWebModule(webUri);
            if (war == null || WarParser.parseServletRedirectorMapping(war) == null) continue;
            return webUri;
        }
        return null;
    }
}

