/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container.tomcat;

import java.io.File;
import java.io.IOException;
import org.apache.cactus.integration.ant.container.tomcat.AbstractTomcatContainer;
import org.apache.cactus.integration.ant.util.ResourceUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class Tomcat3xContainer
extends AbstractTomcatContainer {
    private File tmpDir;

    public final void setTmpDir(File theTmpDir) {
        this.tmpDir = theTmpDir;
    }

    public final String getName() {
        return "Tomcat 3.x";
    }

    public final void startUp() {
        try {
            this.prepare("cactus/tomcat3x");
            this.invoke("start");
        }
        catch (IOException ioe) {
            this.getLog().error((Object)"Failed to startup the container", (Throwable)ioe);
            throw new BuildException((Throwable)ioe);
        }
    }

    public final void shutDown() {
        this.invoke("stop");
    }

    private void invoke(String theArg) {
        Java java = null;
        java = "start".equals(theArg) ? this.createJavaForStartUp() : this.createJavaForShutDown();
        java.addSysproperty(this.createSysProperty("tomcat.install", this.getDir()));
        java.addSysproperty(this.createSysProperty("tomcat.home", this.tmpDir));
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(this.getDir(), "lib/tomcat.jar"));
        File commonsLoggingJarFile = new File(this.getDir(), "lib/common/commons-logging-api.jar");
        if (commonsLoggingJarFile.exists()) {
            classpath.createPathElement().setLocation(commonsLoggingJarFile);
        }
        java.setClassname("org.apache.tomcat.startup.Main");
        java.createArg().setValue(theArg);
        java.execute();
    }

    private void prepare(String theDirName) throws IOException {
        FileUtils fileUtils = FileUtils.newFileUtils();
        FilterChain filterChain = this.createFilterChain();
        this.tmpDir = this.prepareTempDirectory(this.tmpDir, theDirName);
        File confDir = this.createDirectory(this.tmpDir, "conf");
        this.copyConfFiles(confDir);
        if (this.getServerXml() == null) {
            ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/tomcat3x/server.xml", new File(confDir, "server.xml"), filterChain);
        }
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/tomcat3x/tomcat-users.xml", new File(confDir, "tomcat-users.xml"));
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/tomcat3x/modules.xml", new File(confDir, "modules.xml"));
        File webappsDir = this.createDirectory(this.tmpDir, "webapps");
        fileUtils.copyFile(this.getDeployableFile().getFile(), new File(webappsDir, this.getDeployableFile().getFile().getName()), null, true);
    }
}

