/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container.tomcat;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.cactus.integration.ant.container.tomcat.AbstractTomcatContainer;
import org.apache.cactus.integration.ant.util.ResourceUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public abstract class AbstractCatalinaContainer
extends AbstractTomcatContainer {
    private File tmpDir;
    private String version;

    public final void setTmpDir(File theTmpDir) {
        this.tmpDir = theTmpDir;
    }

    public final String getName() {
        return "Tomcat " + this.version;
    }

    public void init() {
        this.version = this.getVersion();
        if (this.version == null) {
            throw new BuildException(this.getDir() + " not recognized as a Tomcat 4.x installation");
        }
    }

    protected final String getVersion() {
        if (this.version == null) {
            try {
                JarFile catalinaJar = new JarFile(new File(this.getDir(), "server/lib/catalina.jar"));
                ZipEntry entry = catalinaJar.getEntry("org/apache/catalina/util/ServerInfo.properties");
                if (entry != null) {
                    Properties props = new Properties();
                    props.load(catalinaJar.getInputStream(entry));
                    String serverInfo = props.getProperty("server.info");
                    if (serverInfo.indexOf(47) > 0) {
                        this.version = serverInfo.substring(serverInfo.indexOf(47) + 1);
                    }
                } else {
                    this.version = "4.0.x";
                }
            }
            catch (IOException ioe) {
                this.getLog().warn((Object)"Couldn't retrieve Tomcat version information", (Throwable)ioe);
            }
        }
        return this.version;
    }

    protected final void invokeBootstrap(String theArg) {
        Java java = null;
        java = "start".equals(theArg) ? this.createJavaForStartUp() : this.createJavaForShutDown();
        java.addSysproperty(this.createSysProperty("catalina.home", this.getDir()));
        java.addSysproperty(this.createSysProperty("catalina.base", this.tmpDir));
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(this.getDir(), "bin/bootstrap.jar"));
        this.addToolsJarToClasspath(classpath);
        java.setClassname("org.apache.catalina.startup.Bootstrap");
        java.createArg().setValue(theArg);
        java.execute();
    }

    protected final void prepare(String theResourcePrefix, String theDirName) throws IOException {
        FileUtils fileUtils = FileUtils.newFileUtils();
        FilterChain filterChain = this.createFilterChain();
        if (this.tmpDir == null) {
            this.tmpDir = this.createTempDirectory(theDirName);
        }
        File confDir = this.createDirectory(this.tmpDir, "conf");
        if (this.getServerXml() == null) {
            ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/" + theResourcePrefix + "/server.xml", new File(confDir, "server.xml"), filterChain);
        }
        ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/" + theResourcePrefix + "/tomcat-users.xml", new File(confDir, "tomcat-users.xml"));
        fileUtils.copyFile(new File(this.getDir(), "conf/web.xml"), new File(confDir, "web.xml"));
        this.copyConfFiles(confDir);
        File webappsDir = this.createDirectory(this.tmpDir, "webapps");
        fileUtils.copyFile(this.getDeployableFile().getFile(), new File(webappsDir, this.getDeployableFile().getFile().getName()), null, true);
    }
}

