/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.geronimo;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.geronimo.deployable.GeronimoDeployable;
import org.codehaus.cargo.container.internal.util.AntBuildListener;
import org.codehaus.cargo.container.spi.deployer.AbstractInstalledLocalDeployer;
import org.codehaus.cargo.util.AntUtils;

public class GeronimoInstalledLocalDeployer
extends AbstractInstalledLocalDeployer {
    private AntUtils antUtils = new AntUtils();

    public GeronimoInstalledLocalDeployer(InstalledLocalContainer container) {
        super(container);
    }

    protected final AntUtils getAntUtils() {
        return this.antUtils;
    }

    protected InstalledLocalContainer getInstalledContainer() {
        return (InstalledLocalContainer)super.getContainer();
    }

    public void deploy(Deployable deployable) {
        Java java = this.createAdminDeployerJava("deploy");
        this.addPathArgument(java, deployable);
        String deployableId = this.getModuleId(deployable);
        try {
            int retval = java.executeJava();
            if (retval != 0) {
                throw new ContainerException("Failed to deploy [" + deployableId + "]");
            }
        }
        catch (BuildException e) {
            throw new ContainerException("Failed to deploy [" + deployableId + "]", e);
        }
    }

    public void distribute(Deployable deployable) {
        Java java = this.createDeployerJava("distribute");
        this.addPathArgument(java, deployable);
        String deployableId = this.getModuleId(deployable);
        try {
            int retval = java.executeJava();
            if (retval != 0) {
                throw new ContainerException("Failed to distribute [" + deployableId + "]");
            }
        }
        catch (BuildException e) {
            throw new ContainerException("Failed to distribute [" + deployableId + "]", e);
        }
    }

    public void start(Deployable deployable) {
        this.start(this.getModuleId(deployable));
    }

    public void start(String deployableId) {
        if (deployableId == null) {
            throw new ContainerException("Failed: deployable ID cannot be null.");
        }
        Java java = this.createAdminDeployerJava("start");
        java.createArg().setValue(deployableId);
        try {
            int retval = java.executeJava();
            if (retval != 0) {
                throw new ContainerException("Failed to start [" + deployableId + "]");
            }
        }
        catch (BuildException e) {
            throw new ContainerException("Failed to start [" + deployableId + "]", e);
        }
    }

    public void stop(Deployable deployable) {
        this.stop(this.getModuleId(deployable));
    }

    public void stop(String deployableId) {
        if (deployableId == null) {
            throw new ContainerException("Failed: deployable ID cannot be null.");
        }
        Java java = this.createAdminDeployerJava("stop");
        java.createArg().setValue(deployableId);
        try {
            int retval = java.executeJava();
            if (retval != 0) {
                throw new ContainerException("Failed to stop [" + deployableId + "]");
            }
        }
        catch (BuildException e) {
            throw new ContainerException("Failed to stop [" + deployableId + "]", e);
        }
    }

    public void undeploy(Deployable deployable) {
        this.undeploy(this.getModuleId(deployable));
    }

    public void undeploy(String deployableId) {
        if (deployableId == null) {
            throw new ContainerException("Failed: deployable ID cannot be null.");
        }
        Java java = this.createAdminDeployerJava("undeploy");
        java.createArg().setValue(deployableId);
        try {
            int retval = java.executeJava();
            if (retval != 0) {
                throw new ContainerException("Failed to undeploy [" + deployableId + "]");
            }
        }
        catch (BuildException e) {
            throw new ContainerException("Failed to undeploy [" + deployableId + "]", e);
        }
    }

    public void redeploy(Deployable deployable) {
        Java java = this.createAdminDeployerJava("redeploy");
        this.addPathArgument(java, deployable);
        String deployableId = this.getModuleId(deployable);
        this.addModuleIdArgument(java, deployableId);
        try {
            int retval = java.executeJava();
            if (retval != 0) {
                throw new ContainerException("Failed to redeploy [" + deployableId + "]");
            }
        }
        catch (BuildException e) {
            throw new ContainerException("Failed to redeploy [" + deployableId + "]", e);
        }
    }

    private Java createJava() {
        Java java = (Java)this.getAntUtils().createAntTask("java");
        java.setFork(true);
        java.getProject().addBuildListener((BuildListener)new AntBuildListener(this.getLogger(), this.getClass().getName()));
        this.addExtraClasspath(java);
        this.addSystemProperties(java);
        String jvmargs = this.getContainer().getConfiguration().getPropertyValue("cargo.jvmargs");
        if (jvmargs != null) {
            java.createJvmarg().setLine(jvmargs);
        }
        return java;
    }

    private Java createDeployerJava(String action) {
        Java java = this.createJava();
        java.setJar(new File(this.getInstalledContainer().getHome(), "bin/deployer.jar"));
        java.createArg().setValue(action);
        java.getProject().addBuildListener((BuildListener)new AntBuildListener(this.getLogger(), this.getClass().getName()));
        return java;
    }

    private Java createAdminDeployerJava(String action) {
        Java java = this.createJava();
        java.createArg().setValue("--user");
        java.createArg().setValue(this.getContainer().getConfiguration().getPropertyValue("cargo.remote.username"));
        java.createArg().setValue("--password");
        java.createArg().setValue(this.getContainer().getConfiguration().getPropertyValue("cargo.remote.password"));
        java.setJar(new File(this.getInstalledContainer().getHome(), "bin/deployer.jar"));
        java.createArg().setValue(action);
        return java;
    }

    private void addPathArgument(Java java, Deployable deployable) {
        GeronimoDeployable geronimoDeployable;
        java.createArg().setValue(deployable.getFile());
        if (deployable instanceof GeronimoDeployable && (geronimoDeployable = (GeronimoDeployable)deployable).getPlan() != null) {
            File planFile = new File(geronimoDeployable.getPlan());
            if (!planFile.exists()) {
                this.getLogger().warn("Cannot locate deployment plan [" + planFile.getPath() + "]. Will attempt to deploy without it.", this.getClass().getName());
            } else {
                java.createArg().setValue(geronimoDeployable.getPlan());
            }
        }
    }

    private void addModuleIdArgument(Java java, String moduleId) {
        if (moduleId != null) {
            java.createArg().setValue(moduleId);
        }
    }

    private void addSystemProperties(Java java) {
        if (this.getInstalledContainer().getSystemProperties() != null) {
            Iterator keys = this.getInstalledContainer().getSystemProperties().keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                java.addSysproperty(this.getAntUtils().createSysProperty(key, (String)this.getInstalledContainer().getSystemProperties().get(key)));
            }
        }
    }

    private void addExtraClasspath(Java javaCommand) {
        Path classpath = javaCommand.createClasspath();
        if (this.getInstalledContainer().getExtraClasspath() != null) {
            Path path = new Path(this.getAntUtils().createProject());
            for (int i = 0; i < this.getInstalledContainer().getExtraClasspath().length; ++i) {
                Path pathElement = new Path(this.getAntUtils().createProject(), this.getInstalledContainer().getExtraClasspath()[i]);
                path.addExisting(pathElement);
                this.getLogger().debug("Adding [" + pathElement + "] to execution classpath", this.getClass().getName());
            }
            classpath.addExisting(path);
        }
    }

    private String getModuleId(Deployable deployable) {
        File planFile;
        GeronimoDeployable geronimoDeployable;
        String moduleId = null;
        String archiveFile = deployable.getFile();
        if (this.getFileHandler().exists(archiveFile)) {
            moduleId = new File(archiveFile).getName().substring(0, new File(archiveFile).getName().lastIndexOf("."));
        }
        if (!(deployable instanceof GeronimoDeployable) || (geronimoDeployable = (GeronimoDeployable)deployable).getPlan() == null || (planFile = new File(geronimoDeployable.getPlan())).exists() || archiveFile != null) {
            // empty if block
        }
        this.getLogger().debug("Computed module id [" + moduleId + "] for deployable [" + deployable.getFile() + "]", this.getClass().getName());
        return moduleId;
    }
}

