/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty.internal;

import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.ServletContainerCapability;
import org.codehaus.cargo.container.jetty.internal.JettyExecutorThread;
import org.codehaus.cargo.container.spi.AbstractEmbeddedLocalContainer;

public abstract class AbstractJettyEmbeddedLocalContainer
extends AbstractEmbeddedLocalContainer {
    protected Object server;
    private ContainerCapability capability = new ServletContainerCapability();

    public AbstractJettyEmbeddedLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public Object getServer() {
        return this.server;
    }

    protected synchronized void createServerObject() throws Exception {
        if (this.server == null) {
            try {
                this.server = this.getClassLoader().loadClass("org.mortbay.jetty.Server").newInstance();
            }
            catch (Exception e) {
                throw new ContainerException("Failed to create Jetty Server instance", e);
            }
        }
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    protected void doStop() throws Exception {
        this.createServerObject();
        JettyExecutorThread jettyRunner = new JettyExecutorThread(this.getServer(), false);
        jettyRunner.setLogger(this.getLogger());
        jettyRunner.start();
    }
}

