/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.resin.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.util.ArrayList;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.resin.internal.ResinUtil;
import org.codehaus.cargo.container.spi.util.DefaultServerRun;

public class ResinRun
extends DefaultServerRun {
    public static final int DEFAULT_KEEPALIVE_SOCKET_PORT = 7778;
    private Object resinServer;
    private ResinUtil resinUtil = new ResinUtil();
    private ServerSocket resin3xKeepAliveSocket;
    static /* synthetic */ Class array$Ljava$lang$String;

    public ResinRun(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        ResinRun resin = new ResinRun(args);
        resin.doRun();
    }

    protected final void doStartServer(String[] args) {
        block5: {
            try {
                if (this.isResinVersion("2.0")) {
                    this.startResin20x(args);
                    break block5;
                }
                if (this.isResinVersion("2.1")) {
                    this.startResin21x(args);
                    break block5;
                }
                if (this.isResinVersion("3")) {
                    this.startResin3x(args);
                    break block5;
                }
                throw new ContainerException("Unsupported Resin version [" + this.resinUtil.getResinVersion() + "]");
            }
            catch (Exception e) {
                throw new ContainerException("Failed to start Resin server", e);
            }
        }
    }

    private void startResin20x(String[] args) throws Exception {
        Class<?> resinClass = Class.forName("com.caucho.server.http.ResinServer");
        Constructor<?> constructor = resinClass.getConstructor(args.getClass(), Boolean.TYPE);
        this.resinServer = constructor.newInstance(args, Boolean.TRUE);
        Method initMethod = this.resinServer.getClass().getMethod("init", Boolean.TYPE);
        initMethod.invoke(this.resinServer, Boolean.TRUE);
    }

    private void startResin21x(String[] args) throws Exception {
        Class<?> resinClass = Class.forName("com.caucho.server.http.ResinServer");
        Constructor<?> constructor = resinClass.getConstructor(args.getClass(), Boolean.TYPE);
        this.resinServer = constructor.newInstance(args, Boolean.TRUE);
        Method initMethod = this.resinServer.getClass().getMethod("init", ArrayList.class);
        initMethod.invoke(this.resinServer, new Object[]{null});
    }

    private Thread startResin3x(String[] args) throws Exception {
        Thread keepaliveThread = new Thread(){

            public void run() {
                try {
                    ResinRun.this.resin3xKeepAliveSocket = new ServerSocket(7778);
                }
                catch (Exception e) {
                    throw new ContainerException("Failed to create keepalive socket", e);
                }
            }
        };
        keepaliveThread.start();
        Resin3xInvoker startThread = new Resin3xInvoker(args);
        startThread.start();
        return startThread;
    }

    protected final void doStopServer(String[] args) {
        block5: {
            try {
                if (this.isResinVersion("2.0")) {
                    this.stopResin20x(args);
                    break block5;
                }
                if (this.isResinVersion("2.1")) {
                    this.stopResin20x(args);
                    break block5;
                }
                if (this.isResinVersion("3")) {
                    this.stopResin3x(args);
                    break block5;
                }
                throw new ContainerException("Unsupported Resin version [" + this.resinUtil.getResinVersion() + "]");
            }
            catch (Exception e) {
                throw new ContainerException("Failed to stop the running Resin server", e);
            }
        }
    }

    private void stopResin20x(String[] args) throws Exception {
        Method closeMethod = this.resinServer.getClass().getMethod("close", null);
        closeMethod.invoke(this.resinServer, null);
    }

    private void stopResin3x(String[] args) throws Exception {
        this.resin3xKeepAliveSocket.close();
    }

    private boolean isResinVersion(String versionPrefix) {
        return this.resinUtil.getResinVersion().startsWith(versionPrefix);
    }

    private class Resin3xInvoker
    extends Thread {
        private String[] args;

        public Resin3xInvoker(String[] args) {
            this.args = args;
        }

        public void run() {
            try {
                Class<?> resinClass = Class.forName("com.caucho.server.http.ResinServer");
                Method mainMethod = resinClass.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ResinRun.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                String[] modifiedArgs = new String[this.args.length + 2];
                for (int i = 0; i < this.args.length; ++i) {
                    modifiedArgs[i] = this.args[i];
                }
                modifiedArgs[this.args.length] = "-socketwait";
                modifiedArgs[this.args.length + 1] = "7778";
                mainMethod.invoke(null, new Object[]{modifiedArgs});
            }
            catch (Exception e) {
                throw new ContainerException("Failed to start Resin 3.x", e);
            }
        }
    }
}

