/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.deployer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.EJB;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractInstalledLocalDeployer;

public abstract class AbstractCopyingInstalledLocalDeployer
extends AbstractInstalledLocalDeployer {
    private static final Iterator EMPTY_ITERATOR = Collections.EMPTY_LIST.iterator();
    private boolean shouldDeployExpandedWARs = true;
    private List deployedDeployables = new ArrayList();

    public AbstractCopyingInstalledLocalDeployer(InstalledLocalContainer container) {
        super(container);
    }

    public void setShouldDeployExpandedWARs(boolean flag) {
        this.shouldDeployExpandedWARs = flag;
    }

    public synchronized void deploy(Deployable deployable) {
        block10: {
            if (!this.canBeDeployed(deployable)) {
                throw new ContainerException("Failed to deploy [" + deployable.getFile() + "] to [" + this.getDeployableDir() + "]. The required web context is already in use" + " by another application.");
            }
            String deployableDir = this.getDeployableDir();
            this.getLogger().info("Deploying [" + deployable.getFile() + "] to [" + deployableDir + "]...", this.getClass().getName());
            if (!this.getContainer().getCapability().supportsDeployableType(deployable.getType())) {
                throw new ContainerException(deployable.getType().getType().toUpperCase() + " archives are not supported for deployment in [" + this.getContainer().getId() + "]. Got [" + deployable.getFile() + "]");
            }
            try {
                if (deployable.getType() == DeployableType.WAR) {
                    if (!((WAR)deployable).isExpandedWar()) {
                        this.deployWar(deployableDir, (WAR)deployable);
                    } else if (this.shouldDeployExpandedWARs) {
                        this.deployExpandedWar(deployableDir, (WAR)deployable);
                    }
                    break block10;
                }
                if (deployable.getType() == DeployableType.EAR) {
                    this.deployEar(deployableDir, (EAR)deployable);
                    break block10;
                }
                if (deployable.getType() == DeployableType.EJB) {
                    this.deployEjb(deployableDir, (EJB)deployable);
                    break block10;
                }
                throw new ContainerException("Only WAR, EJB and EAR are currently supported");
            }
            catch (Exception e) {
                throw new ContainerException("Failed to deploy [" + deployable.getFile() + "] to [" + deployableDir + "]", e);
            }
        }
        this.deployedDeployables.add(deployable);
    }

    protected boolean canBeDeployed(Deployable newDeployable) {
        Set newDeployableContextSet = AbstractCopyingInstalledLocalDeployer.getWebContextsSet(newDeployable);
        int size = this.deployedDeployables.size();
        for (int i = 0; i < size; ++i) {
            Deployable deployedDeployable = (Deployable)this.deployedDeployables.get(i);
            Iterator contextIterator = AbstractCopyingInstalledLocalDeployer.getWebContextsIterator(deployedDeployable);
            while (contextIterator.hasNext()) {
                Object context = contextIterator.next();
                if (!newDeployableContextSet.contains(context)) continue;
                return false;
            }
        }
        return true;
    }

    private static Iterator getWebContextsIterator(Deployable deployable) {
        Iterator<String> webContexts = deployable.getType() == DeployableType.EAR ? ((EAR)deployable).getWebContexts() : (deployable.getType() == DeployableType.WAR ? Arrays.asList(((WAR)deployable).getContext()).iterator() : EMPTY_ITERATOR);
        return webContexts;
    }

    private static Set getWebContextsSet(Deployable deployable) {
        HashSet webContextSet = new HashSet();
        Iterator contextIterator = AbstractCopyingInstalledLocalDeployer.getWebContextsIterator(deployable);
        while (contextIterator.hasNext()) {
            webContextSet.add(contextIterator.next());
        }
        return webContextSet;
    }

    public abstract String getDeployableDir();

    protected void deployEar(String deployableDir, EAR ear) {
        this.getFileHandler().copyFile(ear.getFile(), this.getFileHandler().append(deployableDir, this.getFileHandler().getName(ear.getFile())));
    }

    protected void deployEjb(String deployableDir, EJB ejb) {
        this.getFileHandler().copyFile(ejb.getFile(), this.getFileHandler().append(deployableDir, this.getFileHandler().getName(ejb.getFile())));
    }

    protected void deployWar(String deployableDir, WAR war) {
        this.getFileHandler().copyFile(war.getFile(), this.getFileHandler().append(deployableDir, war.getContext() + ".war"));
    }

    protected void deployExpandedWar(String deployableDir, WAR war) {
        this.getFileHandler().copyDirectory(war.getFile(), this.getFileHandler().append(deployableDir, war.getContext()));
    }
}

