/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.util.CargoException;

public final class ContainerUtils {
    private static final int SLEEP = 100;

    private ContainerUtils() {
    }

    public static URL getCPCURL(Configuration configuration) {
        URL cpcURL;
        try {
            cpcURL = new URL(configuration.getPropertyValue("cargo.protocol") + "://" + configuration.getPropertyValue("cargo.hostname") + ":" + configuration.getPropertyValue("cargo.servlet.port") + "/cargocpc/index.html");
        }
        catch (MalformedURLException e) {
            throw new ContainerException("Failed to compute CPC URL", e);
        }
        return cpcURL;
    }

    public static void waitTillContainerIsStopped(Container container) {
        while (container.getState() == State.STARTED) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new CargoException("Aborting container wait.", e);
            }
        }
    }
}

