/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;
import org.codehaus.cargo.container.tomcat.TomcatWAR;

public class TomcatCopyingInstalledLocalDeployer
extends AbstractCopyingInstalledLocalDeployer {
    private boolean shouldCopyWars = true;

    public TomcatCopyingInstalledLocalDeployer(InstalledLocalContainer container) {
        super(container);
    }

    public String getDeployableDir() {
        return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "webapps");
    }

    public void setShouldCopyWars(boolean shouldCopyWars) {
        this.shouldCopyWars = shouldCopyWars;
    }

    protected void deployWar(String deployableDir, WAR war) {
        if (war instanceof TomcatWAR) {
            TomcatWAR tomcatWar = (TomcatWAR)war;
            if (tomcatWar.containsContextFile()) {
                super.deployWar(deployableDir, war);
            } else if (this.shouldCopyWars) {
                super.deployWar(deployableDir, war);
            }
        } else if (this.shouldCopyWars) {
            super.deployWar(deployableDir, war);
        }
    }

    protected void deployExpandedWar(String deployableDir, WAR war) {
        if (war instanceof TomcatWAR) {
            TomcatWAR tomcatWar = (TomcatWAR)war;
            if (tomcatWar.containsContextFile()) {
                String contextDir = this.getFileHandler().createDirectory(this.getContainer().getConfiguration().getHome(), "conf/Catalina/" + this.getContainer().getConfiguration().getPropertyValue("cargo.hostname"));
                this.getFileHandler().copyFile(this.getFileHandler().append(tomcatWar.getFile(), "META-INF/context.xml"), this.getFileHandler().append(contextDir, tomcatWar.getContext() + ".xml"));
            } else if (this.shouldCopyWars) {
                super.deployExpandedWar(deployableDir, war);
            }
        } else if (this.shouldCopyWars) {
            super.deployExpandedWar(deployableDir, war);
        }
    }
}

