/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractExistingLocalConfiguration;
import org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalContainer;
import org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalDeployer;
import org.codehaus.cargo.container.tomcat.TomcatCopyingInstalledLocalDeployer;
import org.codehaus.cargo.container.tomcat.internal.TomcatExistingLocalConfigurationCapability;

public class TomcatExistingLocalConfiguration
extends AbstractExistingLocalConfiguration {
    private static ConfigurationCapability capability = new TomcatExistingLocalConfigurationCapability();

    public TomcatExistingLocalConfiguration(String dir) {
        super(dir);
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        if (container instanceof Tomcat5xEmbeddedLocalContainer) {
            Tomcat5xEmbeddedLocalDeployer deployer = new Tomcat5xEmbeddedLocalDeployer((Tomcat5xEmbeddedLocalContainer)container);
            deployer.deploy(this.getDeployables());
        } else {
            InstalledLocalContainer tomcatContainer = (InstalledLocalContainer)container;
            File webappsDir = new File(this.getHome(), "webapps");
            if (!webappsDir.exists()) {
                throw new ContainerException("Invalid existing configuration: The [" + webappsDir.getPath() + "] directory does not exist");
            }
            TomcatCopyingInstalledLocalDeployer deployer = new TomcatCopyingInstalledLocalDeployer(tomcatContainer);
            deployer.setShouldDeployExpandedWARs(true);
            deployer.setShouldCopyWars(true);
            deployer.deploy(this.getDeployables());
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(webappsDir, "cargocpc.war"));
        }
    }

    public void verify() {
    }

    public String toString() {
        return "Tomcat Existing Configuration";
    }
}

