/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.merge.strategy;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.codehaus.cargo.module.AbstractDescriptorIo;
import org.codehaus.cargo.module.merge.AbstractMergeSet;
import org.codehaus.cargo.module.merge.MergePair;
import org.codehaus.cargo.module.merge.strategy.MergeStrategy;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NodeMergeStrategy
extends MergeStrategy {
    private Element template;

    public NodeMergeStrategy(Element template) {
        this.template = template;
    }

    public NodeMergeStrategy(InputStream template) throws SAXException, IOException, ParserConfigurationException {
        this.template = AbstractDescriptorIo.createDocumentBuilder().parse(template).getDocumentElement();
    }

    public int inRight(AbstractMergeSet set, Element element) {
        set.add(element);
        return 1;
    }

    public int inBoth(AbstractMergeSet set, MergePair pair) {
        set.remove(pair.left);
        Element newElement = (Element)this.template.cloneNode(true);
        this.applyValues(newElement, pair);
        set.add(newElement);
        return 1;
    }

    private void applyValues(Element element, MergePair pair) {
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!(n instanceof Element)) continue;
            this.applyValues((Element)n, pair);
        }
        String str = element.getFirstChild().getNodeValue();
        Pattern pat = Pattern.compile("\\$(left:|right:)[^ \\t]*");
        Matcher m = pat.matcher(str);
        while (m.find()) {
            str = m.replaceFirst(this.replaceValue(m.group(), pair));
            m = pat.matcher(str);
        }
        element.getFirstChild().setNodeValue(str);
    }

    /*
     * WARNING - void declaration
     */
    private String replaceValue(String string, MergePair pair) {
        Element element;
        String xPath;
        String result = "";
        if (string.startsWith("$left:")) {
            xPath = string.substring(6);
            element = pair.getLeftElement();
        } else if (string.startsWith("$right:")) {
            xPath = string.substring(7);
            element = pair.getRightElement();
        } else {
            return "";
        }
        try {
            void var3_4;
            void var4_5;
            Node nestedText = XPathAPI.selectSingleNode((Node)var4_5, (String)var3_4).getFirstChild();
            if (nestedText != null) {
                result = nestedText.getNodeValue();
            }
        }
        catch (TransformerException e) {
            result = e.getMessage();
        }
        return result;
    }
}

