/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util.log;

import org.codehaus.cargo.util.CargoException;

public final class LogLevel
implements Comparable {
    public static final LogLevel WARN = new LogLevel("warn", 0);
    public static final LogLevel INFO = new LogLevel("info", 1);
    public static final LogLevel DEBUG = new LogLevel("debug", 2);
    private String level;
    private int logVolume;

    private LogLevel(String level, int logVolume) {
        this.level = level;
        this.logVolume = logVolume;
    }

    /*
     * WARNING - void declaration
     */
    public static LogLevel toLevel(String levelAsString) {
        void var1_1;
        LogLevel level;
        if (levelAsString.equalsIgnoreCase(INFO.getLevel())) {
            level = INFO;
        } else if (levelAsString.equalsIgnoreCase(WARN.getLevel())) {
            level = WARN;
        } else if (levelAsString.equalsIgnoreCase(DEBUG.getLevel())) {
            level = DEBUG;
        } else {
            throw new CargoException("Invalid log level [" + levelAsString + "]. Valid values are \"debug\", \"info\" and \"warn\".");
        }
        return var1_1;
    }

    public boolean equals(Object object) {
        LogLevel level;
        boolean result = false;
        if (object != null && object instanceof LogLevel && (level = (LogLevel)object).getLevel().equals(this.getLevel())) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        return this.level.hashCode();
    }

    public int compareTo(Object object) {
        if (!object.getClass().isAssignableFrom(LogLevel.class)) {
            throw new CargoException("Invalid object type [" + object.getClass().getName() + "]. Cannot compare a log level to it.");
        }
        LogLevel level = (LogLevel)object;
        int result = this.logVolume == level.logVolume ? 0 : (this.logVolume > level.logVolume ? 1 : -1);
        return result;
    }

    public String getLevel() {
        return this.level;
    }

    public String toString() {
        return this.getLevel();
    }
}

