/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.client.filter;

import com.mockrunner.mock.web.MockFilterConfig;
import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpServletResponse;
import com.mockrunner.mock.web.MockHttpSession;
import com.mockrunner.mock.web.MockServletContext;
import edu.yale.its.tp.cas.client.CASReceipt;
import edu.yale.its.tp.cas.client.filter.CASFilter;
import edu.yale.its.tp.cas.client.filter.WatchfulFilterChain;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import junit.framework.TestCase;

public class CASFilterTest
extends TestCase {
    private static final String USERNAME = "someone";
    private static final String CAS_VALIDATE_URL = "https://casserver.com/serviceValidate";
    private static final String CAS_LOGIN_URL = "https://casserver.com/login";
    private static final String TEST_SERVER_NAME = "www.client.com:8080";
    MockServletContext basicContext;
    MockFilterConfig mockConfig;
    MockHttpSession authenticatedSession;
    MockHttpServletRequest mockRequest;
    MockHttpServletResponse mockResponse;
    CASReceipt basicReceipt;
    WatchfulFilterChain filterChain;

    public CASFilterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.basicContext = new MockServletContext();
        this.mockConfig = new MockFilterConfig();
        this.basicContext.setInitParameter("edu.yale.its.tp.cas.client.filter.loginUrl", CAS_LOGIN_URL);
        this.basicContext.setInitParameter("edu.yale.its.tp.cas.client.filter.validateUrl", CAS_VALIDATE_URL);
        this.basicContext.setInitParameter("edu.yale.its.tp.cas.client.filter.serverName", TEST_SERVER_NAME);
        this.authenticatedSession = new MockHttpSession();
        this.authenticatedSession.setAttribute("edu.yale.its.tp.cas.client.filter.user", (Object)USERNAME);
        this.basicReceipt = new CASReceipt();
        this.basicReceipt.setCasValidateUrl(CAS_VALIDATE_URL);
        this.basicReceipt.setPrimaryAuthentication(false);
        this.basicReceipt.setUserName(USERNAME);
        this.authenticatedSession.setAttribute("edu.yale.its.tp.cas.client.filter.receipt", (Object)this.basicReceipt);
        this.mockRequest = new MockHttpServletRequest();
        this.mockResponse = new MockHttpServletResponse();
        this.filterChain = new WatchfulFilterChain();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBasicInit() throws ServletException {
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        CASFilter filter = new CASFilter();
        filter.init((FilterConfig)this.mockConfig);
    }

    public void testInitGatewayAndRenew() {
        this.basicContext.setInitParameter("edu.yale.its.tp.cas.client.filter.renew", "true");
        this.basicContext.setInitParameter("edu.yale.its.tp.cas.client.filter.gateway", "true");
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        CASFilter filter = new CASFilter();
        try {
            filter.init((FilterConfig)this.mockConfig);
        }
        catch (ServletException e) {
            return;
        }
        CASFilterTest.fail((String)"filter should not allow both renew and gateway to be set.");
    }

    public void testNoValidateUrl() {
        this.basicContext.setInitParameter("edu.yale.its.tp.cas.client.filter.validateUrl", null);
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        CASFilter filter = new CASFilter();
        try {
            filter.init((FilterConfig)this.mockConfig);
        }
        catch (ServletException e) {
            return;
        }
        CASFilterTest.fail((String)"filter should fail initialization when validation URL is not set.");
    }

    public void testInsecureValidateUrl() {
        this.basicContext.setInitParameter("edu.yale.its.tp.cas.client.filter.validateUrl", "http://somewhere.com/cas/serviceValidate");
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        CASFilter filter = new CASFilter();
        try {
            filter.init((FilterConfig)this.mockConfig);
        }
        catch (ServletException e) {
            return;
        }
        CASFilterTest.fail((String)"filter should fail initialization when validation URL is insecure.");
    }

    public void testServiceAndServerName() {
        this.basicContext.setInitParameter("edu.yale.its.tp.cas.client.filter.serviceUrl", "http://www.client.com:8080/login");
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        CASFilter filter = new CASFilter();
        try {
            filter.init((FilterConfig)this.mockConfig);
        }
        catch (ServletException e) {
            return;
        }
        CASFilterTest.fail((String)"filter should fail initialization when both serverName and serviceUrl are set, as they are mutually exlusive.");
    }

    public void testNoServerNameNoServiceUrl() {
        this.basicContext.setInitParameter("edu.yale.its.tp.cas.client.filter.serverName", null);
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        CASFilter filter = new CASFilter();
        try {
            filter.init((FilterConfig)this.mockConfig);
        }
        catch (ServletException e) {
            return;
        }
        CASFilterTest.fail((String)"filter should fail initialization when neither serverName nor serviceUrl are set, as it will be unable to validate tickets.");
    }

    public void testAlreadyAuthenticated() throws ServletException, IOException {
        CASFilterTest.assertNotNull((Object)this.authenticatedSession);
        this.mockRequest.setSession((HttpSession)this.authenticatedSession);
        CASFilterTest.assertNotNull((Object)this.mockRequest.getSession());
        WatchfulFilterChain filterChain = new WatchfulFilterChain();
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        CASFilter filter = new CASFilter();
        filter.init((FilterConfig)this.mockConfig);
        filter.doFilter((ServletRequest)this.mockRequest, (ServletResponse)this.mockResponse, filterChain);
        CASFilterTest.assertTrue((boolean)filterChain.isChainInvoked());
    }

    public void testStrictnessRequireRenew() throws ServletException, IOException {
        this.mockRequest.setSession((HttpSession)this.authenticatedSession);
        WatchfulFilterChain filterChain = new WatchfulFilterChain();
        this.basicContext.setInitParameter("edu.yale.its.tp.cas.client.filter.renew", "true");
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        CASFilter filter = new CASFilter();
        filter.init((FilterConfig)this.mockConfig);
        filter.doFilter((ServletRequest)this.mockRequest, (ServletResponse)this.mockResponse, filterChain);
        CASFilterTest.assertFalse((boolean)filterChain.isChainInvoked());
        CASFilterTest.assertTrue((boolean)this.mockResponse.wasRedirectSent());
    }

    public void testStrictnessRejectProxied() throws ServletException, IOException {
        ArrayList<String> proxyList = new ArrayList<String>();
        proxyList.add("https://www.foo.com/proxier");
        this.basicReceipt.setProxyList(proxyList);
        this.mockRequest.setSession((HttpSession)this.authenticatedSession);
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        CASFilter filter = new CASFilter();
        filter.init((FilterConfig)this.mockConfig);
        filter.doFilter((ServletRequest)this.mockRequest, (ServletResponse)this.mockResponse, this.filterChain);
        CASFilterTest.assertFalse((boolean)this.filterChain.isChainInvoked());
        CASFilterTest.assertTrue((boolean)this.mockResponse.wasRedirectSent());
    }

    public void testStrictnessRejectUnknownProxy() throws ServletException, IOException {
        ArrayList<String> proxyList = new ArrayList<String>();
        proxyList.add("https://www.foo.com/proxier");
        this.basicReceipt.setProxyList(proxyList);
        this.basicContext.setInitParameter("edu.yale.its.tp.cas.client.filter.authorizedProxy", "https://www.bar.com/proxier");
        this.mockRequest.setSession((HttpSession)this.authenticatedSession);
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        CASFilter filter = new CASFilter();
        filter.init((FilterConfig)this.mockConfig);
        filter.doFilter((ServletRequest)this.mockRequest, (ServletResponse)this.mockResponse, this.filterChain);
        CASFilterTest.assertFalse((boolean)this.filterChain.isChainInvoked());
        CASFilterTest.assertTrue((boolean)this.mockResponse.wasRedirectSent());
    }

    public void testAcceptProxy() throws ServletException, IOException {
        ArrayList<String> proxyList = new ArrayList<String>();
        proxyList.add("https://www.foo.com/proxier");
        this.basicReceipt.setProxyList(proxyList);
        this.basicContext.setInitParameter("edu.yale.its.tp.cas.client.filter.authorizedProxy", "https://www.foo.com/proxier");
        this.mockRequest.setSession((HttpSession)this.authenticatedSession);
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        CASFilter filter = new CASFilter();
        filter.init((FilterConfig)this.mockConfig);
        filter.doFilter((ServletRequest)this.mockRequest, (ServletResponse)this.mockResponse, this.filterChain);
        CASFilterTest.assertTrue((boolean)this.filterChain.isChainInvoked());
    }

    public void testAcceptProxies() throws Exception {
        ArrayList<String> proxyList = new ArrayList<String>();
        proxyList.add("https://www.foo.com/proxier");
        this.basicReceipt.setProxyList(proxyList);
        this.basicContext.setInitParameter("edu.yale.its.tp.cas.client.filter.authorizedProxy", "https://www.foo.com/proxier https://www.bar.com/proxier https://www.fred.com/proxier");
        this.mockRequest.setSession((HttpSession)this.authenticatedSession);
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        CASFilter filter = new CASFilter();
        filter.init((FilterConfig)this.mockConfig);
        filter.doFilter((ServletRequest)this.mockRequest, (ServletResponse)this.mockResponse, this.filterChain);
        CASFilterTest.assertTrue((boolean)this.filterChain.isChainInvoked());
        this.filterChain = new WatchfulFilterChain();
        proxyList.remove("https://www.foo.com/proxier");
        proxyList.add("https://www.bar.com/proxier");
        filter.doFilter((ServletRequest)this.mockRequest, (ServletResponse)new MockHttpServletResponse(), this.filterChain);
        CASFilterTest.assertTrue((boolean)this.filterChain.isChainInvoked());
        this.filterChain = new WatchfulFilterChain();
        proxyList.remove("https://www.bar.com/proxier");
        proxyList.add("https://www.fred.com/proxier");
        filter.doFilter((ServletRequest)this.mockRequest, (ServletResponse)new MockHttpServletResponse(), this.filterChain);
        CASFilterTest.assertTrue((boolean)this.filterChain.isChainInvoked());
        this.filterChain = new WatchfulFilterChain();
        proxyList.remove("https://www.fred.com/proxier");
        proxyList.add("https://www.wombat.com/proxier");
        filter.doFilter((ServletRequest)this.mockRequest, (ServletResponse)new MockHttpServletResponse(), this.filterChain);
        CASFilterTest.assertFalse((boolean)this.filterChain.isChainInvoked());
    }

    public void testInsecureProxier() {
        this.basicContext.setInitParameter("edu.yale.its.tp.cas.client.filter.authorizedProxy", "http://www.foo.com/proxier");
        this.mockRequest.setSession((HttpSession)this.authenticatedSession);
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        CASFilter filter = new CASFilter();
        try {
            filter.init((FilterConfig)this.mockConfig);
        }
        catch (ServletException e) {
            return;
        }
        CASFilterTest.fail((String)"Should have thrown servlet exception because of insecure entry in authorized proxy parameter");
    }

    public void testGetRemoteUser() throws ServletException, IOException {
        this.basicContext.setInitParameter("edu.yale.its.tp.cas.client.filter.wrapRequest", "true");
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        this.mockRequest.setSession((HttpSession)this.authenticatedSession);
        CASFilter filter = new CASFilter();
        filter.init((FilterConfig)this.mockConfig);
        filter.doFilter((ServletRequest)this.mockRequest, (ServletResponse)this.mockResponse, this.filterChain);
        CASFilterTest.assertEquals((String)USERNAME, (String)((HttpServletRequest)this.filterChain.getFilteredServletRequest()).getRemoteUser());
    }

    public void testNotRemoteUser() throws ServletException, IOException {
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        this.mockRequest.setSession((HttpSession)this.authenticatedSession);
        CASFilter filter = new CASFilter();
        filter.init((FilterConfig)this.mockConfig);
        filter.doFilter((ServletRequest)this.mockRequest, (ServletResponse)this.mockResponse, this.filterChain);
        CASFilterTest.assertNull((Object)((HttpServletRequest)this.filterChain.getFilteredServletRequest()).getRemoteUser());
    }

    public void testRedirect() throws ServletException, IOException {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest();
        mockRequest.setSession((HttpSession)new MockHttpSession());
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        CASFilter filter = new CASFilter();
        filter.init((FilterConfig)this.mockConfig);
        filter.doFilter((ServletRequest)mockRequest, (ServletResponse)mockResponse, this.filterChain);
        CASFilterTest.assertFalse((boolean)this.filterChain.isChainInvoked());
        CASFilterTest.assertTrue((boolean)mockResponse.wasRedirectSent());
    }

    public void testGateway() throws ServletException, IOException {
        this.basicContext.setInitParameter("edu.yale.its.tp.cas.client.filter.gateway", "true");
        this.mockConfig.setupServletContext((ServletContext)this.basicContext);
        CASFilter filter = new CASFilter();
        filter.init((FilterConfig)this.mockConfig);
        MockHttpSession bareSession = new MockHttpSession();
        MockHttpServletRequest bareRequest = new MockHttpServletRequest();
        bareRequest.setSession((HttpSession)bareSession);
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)bareRequest, (ServletResponse)mockResponse, this.filterChain);
        CASFilterTest.assertFalse((boolean)this.filterChain.isChainInvoked());
        CASFilterTest.assertTrue((boolean)mockResponse.wasRedirectSent());
        this.filterChain = null;
        bareRequest = null;
        WatchfulFilterChain secondChain = new WatchfulFilterChain();
        MockHttpServletRequest secondRequest = new MockHttpServletRequest();
        secondRequest.setSession((HttpSession)bareSession);
        mockResponse = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)secondRequest, (ServletResponse)mockResponse, secondChain);
        CASFilterTest.assertTrue((boolean)secondChain.isChainInvoked());
        CASFilterTest.assertFalse((boolean)mockResponse.wasRedirectSent());
        WatchfulFilterChain thirdChain = new WatchfulFilterChain();
        MockHttpServletRequest thirdRequest = new MockHttpServletRequest();
        thirdRequest.setSession((HttpSession)bareSession);
        mockResponse = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)thirdRequest, (ServletResponse)mockResponse, thirdChain);
        CASFilterTest.assertTrue((boolean)secondChain.isChainInvoked());
        CASFilterTest.assertFalse((boolean)mockResponse.wasRedirectSent());
    }
}

