/*
 * Decompiled with CFR 0.152.
 */
package ch.acanda.maven.springbanner;

import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

final class Whitespace {
    private Whitespace() {
    }

    public static String[] strip(String banner) {
        String[] lines = Whitespace.stripEnd(banner).split("\n");
        long firstLine = Whitespace.firstNonEmptyLine(lines);
        long lastLine = Whitespace.lastNonEmptyLine(lines);
        int stripStart = Whitespace.countStrippableWhitespaceAtStart(lines);
        return (String[])Stream.of(lines).skip(firstLine).map(Whitespace::stripEnd).map(line -> line.substring(Math.min(line.length(), stripStart))).limit(lastLine - firstLine + 1L).toArray(String[]::new);
    }

    private static String stripEnd(String s) {
        int end = s.length() - 1;
        if (end == -1 || s.charAt(end) != ' ') {
            return s;
        }
        for (int i = end - 1; i >= 0; --i) {
            if (s.charAt(i) == ' ') continue;
            return s.substring(0, i + 1);
        }
        return "";
    }

    private static int firstNonEmptyLine(String ... lines) {
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() <= 0) continue;
            return i;
        }
        return lines.length;
    }

    private static int lastNonEmptyLine(String ... lines) {
        for (int i = lines.length - 1; i >= 0; --i) {
            if (lines[i].length() <= 0) continue;
            return i;
        }
        return 0;
    }

    private static int countStrippableWhitespaceAtStart(String ... lines) {
        return Stream.of(lines).filter(StringUtils::isNotBlank).mapToInt(Whitespace::countStrippableWhitespaceAtStart).min().orElse(0);
    }

    private static int countStrippableWhitespaceAtStart(String line) {
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == ' ') continue;
            return i;
        }
        return 0;
    }
}

