/*
 * Decompiled with CFR 0.152.
 */
package cn.springcloud.feign;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;

public class VenusRequestInterceptor
implements RequestInterceptor {
    @Autowired
    private ObjectMapper objectMapper;

    public void apply(RequestTemplate template) {
        if (HttpMethod.GET.matches(template.method()) && template.body() != null) {
            try {
                JsonNode jsonNode = this.objectMapper.readTree(template.body());
                template.body(null);
                HashMap<String, Collection<String>> queries = new HashMap<String, Collection<String>>(jsonNode.size());
                this.buildQuery(jsonNode, "", queries);
                template.queries(queries);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void buildQuery(JsonNode jsonNode, String path, Map<String, Collection<String>> queries) {
        if (!jsonNode.isContainerNode()) {
            if (jsonNode.isNull()) {
                return;
            }
            Collection<String> values = queries.get(path);
            if (null == values) {
                values = new ArrayList<String>();
                queries.put(path, values);
            }
            values.add(jsonNode.asText());
            return;
        }
        if (jsonNode.isArray()) {
            Iterator it = jsonNode.elements();
            while (it.hasNext()) {
                this.buildQuery((JsonNode)it.next(), path, queries);
            }
        } else {
            Iterator it = jsonNode.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                if (StringUtils.hasText((String)path)) {
                    this.buildQuery((JsonNode)entry.getValue(), path + "." + (String)entry.getKey(), queries);
                    continue;
                }
                this.buildQuery((JsonNode)entry.getValue(), (String)entry.getKey(), queries);
            }
        }
    }
}

