/*
 * Decompiled with CFR 0.152.
 */
package cn.zvo.fileupload;

import cn.zvo.fileupload.StorageInterface;
import cn.zvo.fileupload.bean.SubFileBean;
import cn.zvo.fileupload.storage.local.LocalStorage;
import cn.zvo.fileupload.vo.UploadFileVO;
import com.xnx3.BaseVO;
import com.xnx3.Lang;
import com.xnx3.Log;
import com.xnx3.StringUtil;
import com.xnx3.UrlUtil;
import com.xnx3.media.ImageUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class FileUpload {
    public static final String UTF8 = "UTF-8";
    public static final String GBK = "GBK";
    public static final String DEFAULT_ALLOW_UPLOAD_SUFFIXS = "png|jpg|jpeg|gif|bmp|flv|swf|mkv|avi|rm|rmvb|mpeg|mpg|ogg|ogv|mov|wmv|mp4|webm|mp3|wav|mid|rar|zip|tar|gz|7z|bz2|cab|iso|doc|docx|xls|xlsx|ppt|pptx|pdf|txt|md|xml";
    private String maxFileSize;
    private int maxFileSizeKB = -1;
    public String[] allowUploadSuffixs;
    private StorageInterface storage;
    public String domain = null;
    public boolean defaultIgnoreConstrands = false;

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public StorageInterface getStorage() {
        if (this.storage == null) {
            LocalStorage localStorage = new LocalStorage();
            this.storage = localStorage;
            Log.info((String)"use default storage mode : local server");
        }
        return this.storage;
    }

    public void setStorage(StorageInterface storage) {
        this.storage = storage;
    }

    public boolean isStorage(String storageClassName) {
        if (storageClassName.equalsIgnoreCase("localFile")) {
            storageClassName = "LocalStorage";
        } else if (storageClassName.equalsIgnoreCase("huaWeiYunOBS")) {
            storageClassName = "HuaweicloudOBSStorage";
        } else if (storageClassName.equalsIgnoreCase("aliyunOSS")) {
            storageClassName = "AliyunOSSStorage";
        }
        String currentModeFileName = this.getStorage().getClass().getSimpleName();
        return currentModeFileName.equalsIgnoreCase(storageClassName);
    }

    public boolean isStorage(Class storageClass) {
        String name = storageClass.getSimpleName();
        return this.isStorage(name);
    }

    public String getMaxFileSize() {
        if (this.maxFileSize == null) {
            this.maxFileSize = "3MB";
        }
        return this.maxFileSize;
    }

    public long getMaxFileSizeKB() {
        if (this.maxFileSizeKB == -1) {
            this.maxFileSize = this.getMaxFileSize();
            if (this.maxFileSize.indexOf("KB") > 0) {
                this.maxFileSizeKB = Lang.stringToInt((String)this.maxFileSize.replace("KB", "").trim(), (int)0);
                if (this.maxFileSizeKB == 0) {
                    Log.error((String)"maxFileSize \u5f02\u5e38,\u5f53\u524d\u83b7\u53d6\u5230\u7684\u4e3a0");
                }
            } else if (this.maxFileSize.indexOf("MB") > 0) {
                this.maxFileSizeKB = Lang.stringToInt((String)this.maxFileSize.replace("MB", "").trim(), (int)0) * 1024;
                if (this.maxFileSizeKB == 0) {
                    Log.error((String)"maxFileSize \u5f02\u5e38,\u5f53\u524d\u83b7\u53d6\u5230\u7684\u4e3a0");
                }
            } else if (this.maxFileSize.indexOf("GB") > 0) {
                this.maxFileSizeKB = Lang.stringToInt((String)this.maxFileSize.replace("GB", "").trim(), (int)0) * 1024 * 1024;
                if (this.maxFileSizeKB == 0) {
                    Log.error((String)"maxFileSize \u5f02\u5e38,\u5f53\u524d\u83b7\u53d6\u5230\u7684\u4e3a0");
                }
            } else {
                Log.error((String)"maxFileSize exception, not find unit\uff0cyour are KB ? MB ? GB ? Please use one of them");
            }
        }
        return this.maxFileSizeKB;
    }

    public void setMaxFileSizeKB(int maxFileSizeKB) {
        this.maxFileSizeKB = maxFileSizeKB;
    }

    public BaseVO verifyFileMaxLength(File file) {
        BaseVO vo = new BaseVO();
        if (file != null) {
            int lengthKB = (int)Math.ceil(file.length() / 1024L);
            vo = this.verifyFileMaxLength(lengthKB);
        }
        return vo;
    }

    public BaseVO verifyFileMaxLength(long lengthKB) {
        BaseVO vo = new BaseVO();
        if (this.getMaxFileSizeKB() > 0L && lengthKB > this.getMaxFileSizeKB()) {
            vo.setBaseVO(0, "\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u9650\u5236\uff01\u4e0a\u4f20\u5927\u5c0f\u5728 " + this.maxFileSize + " \u4ee5\u5185");
            return vo;
        }
        return vo;
    }

    public void setMaxFileSize(String maxSize) {
        if (maxSize == null) {
            return;
        }
        this.maxFileSize = maxSize;
        this.maxFileSizeKB = -1;
    }

    public void setAllowUploadSuffix(String allowUploadSuffixs) {
        int i;
        if (allowUploadSuffixs == null) {
            return;
        }
        String[] ss = allowUploadSuffixs.split("\\|");
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < ss.length; ++i) {
            String s = ss[i].trim();
            if (s == null || s.length() <= 0) continue;
            list.add(s);
        }
        this.allowUploadSuffixs = new String[list.size()];
        for (i = 0; i < list.size(); ++i) {
            this.allowUploadSuffixs[i] = (String)list.get(i);
        }
    }

    public void setAllowUploadSuffixs(String[] allowUploadSuffixs) {
        if (allowUploadSuffixs == null) {
            return;
        }
        this.allowUploadSuffixs = allowUploadSuffixs;
    }

    public String[] getAllowUploadSuffixs() {
        return this.allowUploadSuffixs;
    }

    public boolean isAllowUpload(String path) {
        if (path == null || path.trim().length() == 0) {
            return false;
        }
        String suffix = path.indexOf(".") > -1 ? Lang.findFileSuffix((String)path) : path;
        if (this.allowUploadSuffixs == null || this.allowUploadSuffixs.length == 0) {
            this.setAllowUploadSuffix(DEFAULT_ALLOW_UPLOAD_SUFFIXS);
        }
        for (int j = 0; j < this.allowUploadSuffixs.length; ++j) {
            if (!this.allowUploadSuffixs[j].equalsIgnoreCase(suffix)) continue;
            return true;
        }
        return false;
    }

    public UploadFileVO upload(String path, String localPath) {
        return this.upload(path, localPath, this.defaultIgnoreConstrands);
    }

    public UploadFileVO upload(String path, String localPath, boolean ignoreConstrands) {
        File localFile = new File(localPath);
        return this.upload(path, localFile, ignoreConstrands);
    }

    public UploadFileVO upload(String path, File localFile) {
        return this.upload(path, localFile, this.defaultIgnoreConstrands);
    }

    public UploadFileVO upload(String path, File localFile, boolean ignoreConstrands) {
        UploadFileVO vo = new UploadFileVO();
        BaseVO baseVO = this.verifyFileMaxLength(localFile);
        if (baseVO.getResult() - 0 == 0) {
            vo.setBaseVO(baseVO);
            return vo;
        }
        try {
            FileInputStream localInput = new FileInputStream(localFile);
            return this.upload(path, (InputStream)localInput, ignoreConstrands);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            vo.setBaseVO(0, "\u4e0a\u4f20\u51fa\u9519\uff0c\u8981\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            return vo;
        }
    }

    public UploadFileVO upload(String path, InputStream inputStream) {
        return this.upload(path, inputStream, this.defaultIgnoreConstrands);
    }

    public UploadFileVO upload(String path, InputStream inputStream, boolean ignoreConstrands) {
        String domain;
        UploadFileVO vo = new UploadFileVO();
        if (inputStream == null) {
            vo.setBaseVO(0, "\u8bf7\u9009\u62e9\u8981\u4e0a\u4f20\u7684\u6587\u4ef6");
            return vo;
        }
        long length_B = 0L;
        try {
            length_B = inputStream.available();
            vo.setSize(length_B);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!ignoreConstrands) {
            if (!this.isAllowUpload(path)) {
                vo.setBaseVO(0, "\u8be5\u540e\u7f00\u4e0d\u5141\u8bb8\u88ab\u4e0a\u4f20");
                return vo;
            }
            BaseVO baseVO = this.verifyFileMaxLength((long)Math.ceil(length_B / 1024L));
            if (baseVO.getResult() - 0 == 0) {
                vo.setBaseVO(baseVO);
                return vo;
            }
        }
        if ((vo = this.getStorage().upload(path, inputStream)).getSize() < 1L) {
            vo.setSize(length_B);
        }
        if ((domain = this.getDomain()) != null) {
            vo.setUrl(domain + vo.getPath());
        }
        vo.setName(UrlUtil.getFileName((String)("http://zvo.cn/" + path)));
        return vo;
    }

    public UploadFileVO upload(String path, InputStream inputStream, String fileSuffix) {
        return this.upload(path, inputStream, fileSuffix, this.defaultIgnoreConstrands);
    }

    public UploadFileVO upload(String path, InputStream inputStream, String fileSuffix, boolean ignoreConstrands) {
        UploadFileVO vo = new UploadFileVO();
        if (!this.isAllowUpload(fileSuffix)) {
            vo.setBaseVO(0, "\u6b64\u540e\u7f00\u540d\u4e0d\u5728\u53ef\u4e0a\u4f20\u6587\u4ef6\u5217\u8868\u4e2d");
            return vo;
        }
        if (inputStream == null) {
            vo.setBaseVO(0, "\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u8981\u4e0a\u4f20\u7684\u6587\u4ef6");
            return vo;
        }
        return this.upload(path, "." + fileSuffix, inputStream, ignoreConstrands);
    }

    public UploadFileVO upload(String path, String fileName, InputStream inputStream) {
        return this.upload(path, fileName, inputStream, this.defaultIgnoreConstrands);
    }

    public UploadFileVO upload(String path, String fileName, InputStream inputStream, boolean ignoreConstrands) {
        UploadFileVO vo = new UploadFileVO();
        if (fileName == null || fileName.indexOf(".") == -1) {
            vo.setBaseVO(0, "\u4e0a\u4f20\u7684\u6587\u4ef6\u540d(\u540e\u7f00)\u6821\u9a8c\u5931\u8d25\uff01\u4f20\u5165\u7684\u4e3a\uff1a" + fileName + "\uff0c\u5141\u8bb8\u4f20\u5165\u7684\u503c\u5982\uff1aa.jpg\u6216.jpg");
            return vo;
        }
        String fileSuffix = StringUtil.subString((String)fileName, (String)".", null, (int)3);
        String name = Lang.uuid() + "." + fileSuffix;
        return this.upload(path + name, inputStream, ignoreConstrands);
    }

    public UploadFileVO uploadString(String path, String text, String encode) {
        return this.uploadString(path, text, encode, this.defaultIgnoreConstrands);
    }

    public UploadFileVO uploadString(String path, String text, String encode, boolean ignoreConstrands) {
        try {
            InputStream inputStream = StringUtil.stringToInputStream((String)text, (String)encode);
            return this.upload(path, inputStream, ignoreConstrands);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            UploadFileVO vo = new UploadFileVO();
            vo.setBaseVO(0, e.getMessage());
            return vo;
        }
    }

    public UploadFileVO uploadString(String path, String text) {
        return this.uploadString(path, text, UTF8, this.defaultIgnoreConstrands);
    }

    public UploadFileVO uploadString(String path, String text, boolean ignoreConstrands) {
        return this.uploadString(path, text, UTF8, ignoreConstrands);
    }

    public UploadFileVO uploadImage(String path, InputStream inputStream, String fileSuffix, int maxWidth) {
        return this.uploadImage(path, inputStream, fileSuffix, maxWidth, this.defaultIgnoreConstrands);
    }

    public UploadFileVO uploadImage(String path, InputStream inputStream, String fileSuffix, int maxWidth, boolean ignoreConstrands) {
        UploadFileVO vo = new UploadFileVO();
        if (!this.isAllowUpload(fileSuffix)) {
            vo.setBaseVO(0, "\u6b64\u540e\u7f00\u540d\u4e0d\u5728\u53ef\u4e0a\u4f20\u6587\u4ef6\u5217\u8868\u4e2d");
            return vo;
        }
        if (inputStream == null) {
            vo.setBaseVO(0, "\u8bf7\u9009\u62e9\u8981\u4e0a\u4f20\u7684\u6587\u4ef6");
            return vo;
        }
        if (maxWidth > 0) {
            inputStream = ImageUtil.proportionZoom((InputStream)inputStream, (int)maxWidth, (String)fileSuffix);
        }
        return this.upload(path, "." + fileSuffix, inputStream, ignoreConstrands);
    }

    public UploadFileVO uploadImage(String path, String imageUrl) {
        return this.uploadImage(path, imageUrl, this.defaultIgnoreConstrands);
    }

    public UploadFileVO uploadImage(String path, String imageUrl, boolean ignoreConstrands) {
        if (imageUrl == null) {
            return null;
        }
        String suffix = Lang.findFileSuffix((String)imageUrl);
        BufferedImage bufferedImage = ImageUtil.getBufferedImageByUrl((String)imageUrl);
        if (suffix == null) {
            suffix = "jpg";
        }
        return this.upload(path + Lang.uuid() + "." + suffix, ImageUtil.bufferedImageToInputStream((BufferedImage)bufferedImage, (String)suffix), ignoreConstrands);
    }

    public String getText(String path) {
        InputStream is = this.getStorage().get(path);
        if (is == null) {
            return null;
        }
        try {
            return StringUtil.inputStreamToString((InputStream)is, (String)UTF8);
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.debug((String)e.getMessage());
            return null;
        }
    }

    public InputStream getInputStream(String path) {
        InputStream is = this.getStorage().get(path);
        return is;
    }

    public void delete(String path) {
        this.getStorage().delete(path);
    }

    public void copy(String originalFilePath, String newFilePath) {
        this.getStorage().copyFile(originalFilePath, newFilePath);
    }

    public long getDirectorySize(String path) {
        return this.getStorage().getSize(path);
    }

    public long getFileSize(String path) {
        return this.getStorage().getSize(path);
    }

    public List<SubFileBean> getSubFileList(String path) {
        return this.getStorage().getSubFileList(path);
    }

    public void createFolder(String path) {
        this.getStorage().createFolder(path);
    }
}

