/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.logstash;

import co.elastic.clients.elasticsearch.logstash.PipelineMetadata;
import co.elastic.clients.elasticsearch.logstash.PipelineSettings;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Pipeline
implements JsonpSerializable {
    private final String description;
    private final DateTime lastModified;
    private final String pipeline;
    private final PipelineMetadata pipelineMetadata;
    private final PipelineSettings pipelineSettings;
    private final String username;
    public static final JsonpDeserializer<Pipeline> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Pipeline::setupPipelineDeserializer);

    private Pipeline(Builder builder) {
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.lastModified = ApiTypeHelper.requireNonNull(builder.lastModified, this, "lastModified");
        this.pipeline = ApiTypeHelper.requireNonNull(builder.pipeline, this, "pipeline");
        this.pipelineMetadata = ApiTypeHelper.requireNonNull(builder.pipelineMetadata, this, "pipelineMetadata");
        this.pipelineSettings = ApiTypeHelper.requireNonNull(builder.pipelineSettings, this, "pipelineSettings");
        this.username = ApiTypeHelper.requireNonNull(builder.username, this, "username");
    }

    public static Pipeline of(Function<Builder, ObjectBuilder<Pipeline>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String description() {
        return this.description;
    }

    public final DateTime lastModified() {
        return this.lastModified;
    }

    public final String pipeline() {
        return this.pipeline;
    }

    public final PipelineMetadata pipelineMetadata() {
        return this.pipelineMetadata;
    }

    public final PipelineSettings pipelineSettings() {
        return this.pipelineSettings;
    }

    public final String username() {
        return this.username;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("last_modified");
        this.lastModified.serialize(generator, mapper);
        generator.writeKey("pipeline");
        generator.write(this.pipeline);
        generator.writeKey("pipeline_metadata");
        this.pipelineMetadata.serialize(generator, mapper);
        generator.writeKey("pipeline_settings");
        this.pipelineSettings.serialize(generator, mapper);
        generator.writeKey("username");
        generator.write(this.username);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPipelineDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::lastModified, DateTime._DESERIALIZER, "last_modified");
        op.add(Builder::pipeline, JsonpDeserializer.stringDeserializer(), "pipeline");
        op.add(Builder::pipelineMetadata, PipelineMetadata._DESERIALIZER, "pipeline_metadata");
        op.add(Builder::pipelineSettings, PipelineSettings._DESERIALIZER, "pipeline_settings");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Pipeline> {
        private String description;
        private DateTime lastModified;
        private String pipeline;
        private PipelineMetadata pipelineMetadata;
        private PipelineSettings pipelineSettings;
        private String username;

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder lastModified(DateTime value) {
            this.lastModified = value;
            return this;
        }

        public final Builder pipeline(String value) {
            this.pipeline = value;
            return this;
        }

        public final Builder pipelineMetadata(PipelineMetadata value) {
            this.pipelineMetadata = value;
            return this;
        }

        public final Builder pipelineMetadata(Function<PipelineMetadata.Builder, ObjectBuilder<PipelineMetadata>> fn) {
            return this.pipelineMetadata(fn.apply(new PipelineMetadata.Builder()).build());
        }

        public final Builder pipelineSettings(PipelineSettings value) {
            this.pipelineSettings = value;
            return this;
        }

        public final Builder pipelineSettings(Function<PipelineSettings.Builder, ObjectBuilder<PipelineSettings>> fn) {
            return this.pipelineSettings(fn.apply(new PipelineSettings.Builder()).build());
        }

        public final Builder username(String value) {
            this.username = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Pipeline build() {
            this._checkSingleUse();
            return new Pipeline(this);
        }
    }
}

