/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.lang.String;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

//----------------------------------------------------------------
//       THIS CODE IS GENERATED. MANUAL EDITS WILL BE LOST.
//----------------------------------------------------------------
//
// This code is generated from the Elasticsearch API specification
// at https://github.com/elastic/elasticsearch-specification
//
// Manual updates to this file will be lost when the code is
// re-generated.
//
// If you find a property that is missing or wrongly typed, please
// open an issue or a PR on the API specification repository.
//
//----------------------------------------------------------------

// typedef: inference._types.ToolCall

/**
 * A tool call generated by the model.
 * 
 * @see <a href="../doc-files/api-spec.html#inference._types.ToolCall">API
 *      specification</a>
 */
@JsonpDeserializable
public class ToolCall implements JsonpSerializable {
	private final String id;

	private final ToolCallFunction function;

	private final String type;

	// ---------------------------------------------------------------------------------------------

	private ToolCall(Builder builder) {

		this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
		this.function = ApiTypeHelper.requireNonNull(builder.function, this, "function");
		this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");

	}

	public static ToolCall of(Function<Builder, ObjectBuilder<ToolCall>> fn) {
		return fn.apply(new Builder()).build();
	}

	/**
	 * Required - The identifier of the tool call.
	 * <p>
	 * API name: {@code id}
	 */
	public final String id() {
		return this.id;
	}

	/**
	 * Required - The function that the model called.
	 * <p>
	 * API name: {@code function}
	 */
	public final ToolCallFunction function() {
		return this.function;
	}

	/**
	 * Required - The type of the tool call.
	 * <p>
	 * API name: {@code type}
	 */
	public final String type() {
		return this.type;
	}

	/**
	 * Serialize this object to JSON.
	 */
	public void serialize(JsonGenerator generator, JsonpMapper mapper) {
		generator.writeStartObject();
		serializeInternal(generator, mapper);
		generator.writeEnd();
	}

	protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {

		generator.writeKey("id");
		generator.write(this.id);

		generator.writeKey("function");
		this.function.serialize(generator, mapper);

		generator.writeKey("type");
		generator.write(this.type);

	}

	@Override
	public String toString() {
		return JsonpUtils.toString(this);
	}

	// ---------------------------------------------------------------------------------------------

	/**
	 * Builder for {@link ToolCall}.
	 */

	public static class Builder extends WithJsonObjectBuilderBase<Builder> implements ObjectBuilder<ToolCall> {
		private String id;

		private ToolCallFunction function;

		private String type;

		/**
		 * Required - The identifier of the tool call.
		 * <p>
		 * API name: {@code id}
		 */
		public final Builder id(String value) {
			this.id = value;
			return this;
		}

		/**
		 * Required - The function that the model called.
		 * <p>
		 * API name: {@code function}
		 */
		public final Builder function(ToolCallFunction value) {
			this.function = value;
			return this;
		}

		/**
		 * Required - The function that the model called.
		 * <p>
		 * API name: {@code function}
		 */
		public final Builder function(Function<ToolCallFunction.Builder, ObjectBuilder<ToolCallFunction>> fn) {
			return this.function(fn.apply(new ToolCallFunction.Builder()).build());
		}

		/**
		 * Required - The type of the tool call.
		 * <p>
		 * API name: {@code type}
		 */
		public final Builder type(String value) {
			this.type = value;
			return this;
		}

		@Override
		protected Builder self() {
			return this;
		}

		/**
		 * Builds a {@link ToolCall}.
		 *
		 * @throws NullPointerException
		 *             if some of the required fields are null.
		 */
		public ToolCall build() {
			_checkSingleUse();

			return new ToolCall(this);
		}
	}

	// ---------------------------------------------------------------------------------------------

	/**
	 * Json deserializer for {@link ToolCall}
	 */
	public static final JsonpDeserializer<ToolCall> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new,
			ToolCall::setupToolCallDeserializer);

	protected static void setupToolCallDeserializer(ObjectDeserializer<ToolCall.Builder> op) {

		op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
		op.add(Builder::function, ToolCallFunction._DESERIALIZER, "function");
		op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");

	}

}
