/*
 * Decompiled with CFR 0.152.
 */
package fs2.hashing;

import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.hashing.Hash;
import fs2.hashing.HashAlgorithm;
import fs2.hashing.HashAlgorithm$MD5$;
import fs2.hashing.HashAlgorithm$SHA1$;
import fs2.hashing.HashAlgorithm$SHA224$;
import fs2.hashing.HashAlgorithm$SHA256$;
import fs2.hashing.HashAlgorithm$SHA384$;
import fs2.hashing.HashAlgorithm$SHA3_224$;
import fs2.hashing.HashAlgorithm$SHA3_256$;
import fs2.hashing.HashAlgorithm$SHA3_384$;
import fs2.hashing.HashAlgorithm$SHA3_512$;
import fs2.hashing.HashAlgorithm$SHA512$;
import fs2.hashing.HashAlgorithm$SHA512_224$;
import fs2.hashing.HashAlgorithm$SHA512_256$;
import fs2.hashing.Hasher;
import fs2.hashing.SyncHasher;
import java.io.Serializable;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import scala.Function0;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001\u0003\u0006\f!\u0003\r\taC\b\t\u000bY\u0001A\u0011\u0001\r\t\rq\u0001A\u0011A\u0006\u001e\u0011\u0019q\u0005\u0001\"\u0001\f\u001f\"1a\r\u0001C\u0001\u0017\u001dDa\u0001\u001e\u0001\u0005\u0002-)\bbB@\u0001\t\u0003Y\u0011\u0011\u0001\u0005\t\u0003;\u0001A\u0011A\u0006\u0002 !9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0002bBA)\u0001\u0011\u0005\u00111\u000b\u0002\u0018\u0011\u0006\u001c\b.\u001a:D_6\u0004\u0018M\\5p]Bc\u0017\r\u001e4pe6T!\u0001D\u0007\u0002\u000f!\f7\u000f[5oO*\ta\"A\u0002ggJ\u001a\"\u0001\u0001\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uI\r\u0001A#A\r\u0011\u0005EQ\u0012BA\u000e\u0013\u0005\u0011)f.\u001b;\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\u0005y!DCA\u0010J)\t\u0001C\t\u0005\u0003\"_I\u0002eB\u0001\u0012-\u001d\t\u0019\u0013F\u0004\u0002%O5\tQE\u0003\u0002'/\u00051AH]8pizJ\u0011\u0001K\u0001\u0005G\u0006$8/\u0003\u0002+W\u00051QM\u001a4fGRT\u0011\u0001K\u0005\u0003[9\nq\u0001]1dW\u0006<WM\u0003\u0002+W%\u0011\u0001'\r\u0002\t%\u0016\u001cx.\u001e:dK*\u0011QF\f\t\u0003gQb\u0001\u0001B\u00036\u0005\t\u0007aGA\u0001G+\t9d(\u0005\u00029wA\u0011\u0011#O\u0005\u0003uI\u0011qAT8uQ&tw\r\u0005\u0002\u0012y%\u0011QH\u0005\u0002\u0004\u0003:LH!B 5\u0005\u00049$\u0001B0%IE\u00022!\u0011\"3\u001b\u0005Y\u0011BA\"\f\u0005\u0019A\u0015m\u001d5fe\"9QIAA\u0001\u0002\b1\u0015AC3wS\u0012,gnY3%cA\u0019\u0011e\u0012\u001a\n\u0005!\u000b$\u0001B*z]\u000eDQA\u0013\u0002A\u0002-\u000b\u0011\"\u00197h_JLG\u000f[7\u0011\u0005\u0005c\u0015BA'\f\u00055A\u0015m\u001d5BY\u001e|'/\u001b;i[\u0006!\u0001.\\1d+\t\u0001F\u000bF\u0002R9v#\"AU-\u0011\t\u0005z3\u000b\u0017\t\u0003gQ#Q!N\u0002C\u0002U+\"a\u000e,\u0005\u000b]#&\u0019A\u001c\u0003\t}#CE\r\t\u0004\u0003\n\u001b\u0006b\u0002.\u0004\u0003\u0003\u0005\u001daW\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004cA\u0011H'\")!j\u0001a\u0001\u0017\")al\u0001a\u0001?\u0006\u00191.Z=\u0011\u0007\u0001\f7-D\u0001\u000e\u0013\t\u0011WBA\u0003DQVt7\u000e\u0005\u0002\u0012I&\u0011QM\u0005\u0002\u0005\u0005f$X-\u0001\u0004v]N\fg-Z\u000b\u0003Q2$\"![:\u0015\u0005)\u0004\bcA!CWB\u00111\u0007\u001c\u0003\u0006k\u0011\u0011\r!\\\u000b\u0003o9$Qa\u001c7C\u0002]\u0012Aa\u0018\u0013%g!9\u0011\u000fBA\u0001\u0002\b\u0011\u0018AC3wS\u0012,gnY3%gA\u0019\u0011eR6\t\u000b)#\u0001\u0019A&\u0002#Q|\u0017\t\\4pe&$\b.\\*ue&tw\r\u0006\u0002w}B\u0011qo\u001f\b\u0003qf\u0004\"\u0001\n\n\n\u0005i\u0014\u0012A\u0002)sK\u0012,g-\u0003\u0002}{\n11\u000b\u001e:j]\u001eT!A\u001f\n\t\u000b)+\u0001\u0019A&\u0002\u0015Ut7/\u00194f\u00116\f7-\u0006\u0003\u0002\u0004\u0005-ACBA\u0003\u00033\tY\u0002\u0006\u0003\u0002\b\u0005M\u0001\u0003B!C\u0003\u0013\u00012aMA\u0006\t\u0019)dA1\u0001\u0002\u000eU\u0019q'a\u0004\u0005\u000f\u0005E\u00111\u0002b\u0001o\t!q\f\n\u00135\u0011%\t)BBA\u0001\u0002\b\t9\"\u0001\u0006fm&$WM\\2fIQ\u0002B!I$\u0002\n!)!J\u0002a\u0001\u0017\")aL\u0002a\u0001?\u0006!Bo\\'bG\u0006cwm\u001c:ji\"l7\u000b\u001e:j]\u001e$2A^A\u0011\u0011\u0015Qu\u00011\u0001L\u0003])hn]1gK\u001a\u0013x.\\'fgN\fw-\u001a#jO\u0016\u001cH/\u0006\u0003\u0002(\u0005=B\u0003BA\u0015\u0003{!B!a\u000b\u00028A!\u0011IQA\u0017!\r\u0019\u0014q\u0006\u0003\u0007k!\u0011\r!!\r\u0016\u0007]\n\u0019\u0004B\u0004\u00026\u0005=\"\u0019A\u001c\u0003\t}#C%\u000e\u0005\n\u0003sA\u0011\u0011!a\u0002\u0003w\t!\"\u001a<jI\u0016t7-\u001a\u00136!\u0011\ts)!\f\t\u000f\u0005}\u0002\u00021\u0001\u0002B\u0005\tA\r\u0005\u0003\u0002D\u00055SBAA#\u0015\u0011\t9%!\u0013\u0002\u0011M,7-\u001e:jifT!!a\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\n)EA\u0007NKN\u001c\u0018mZ3ES\u001e,7\u000f^\u0001\u000ek:\u001c\u0018MZ3Ge>lW*Y2\u0016\t\u0005U\u0013Q\f\u000b\u0005\u0003/\nY\u0007\u0006\u0003\u0002Z\u0005\u0015\u0004\u0003B!C\u00037\u00022aMA/\t\u0019)\u0014B1\u0001\u0002`U\u0019q'!\u0019\u0005\u000f\u0005\r\u0014Q\fb\u0001o\t!q\f\n\u00137\u0011%\t9'CA\u0001\u0002\b\tI'\u0001\u0006fm&$WM\\2fIY\u0002B!I$\u0002\\!9\u0011qH\u0005A\u0002\u00055\u0004\u0003BA8\u0003sj!!!\u001d\u000b\t\u0005M\u0014QO\u0001\u0007GJL\b\u000f^8\u000b\u0005\u0005]\u0014!\u00026bm\u0006D\u0018\u0002BA>\u0003c\u00121!T1d\u0001")
public interface HasherCompanionPlatform {
    public static /* synthetic */ Resource apply$(HasherCompanionPlatform $this, HashAlgorithm algorithm, Sync evidence$1) {
        return $this.apply(algorithm, evidence$1);
    }

    default public <F> Resource<F, Hasher<F>> apply(HashAlgorithm algorithm, Sync<F> evidence$1) {
        return package$.MODULE$.Resource().eval(package$.MODULE$.Sync().apply(evidence$1).delay((Function0 & Serializable)() -> this.unsafe(algorithm, evidence$1)));
    }

    public static /* synthetic */ Resource hmac$(HasherCompanionPlatform $this, HashAlgorithm algorithm, Chunk key, Sync evidence$2) {
        return $this.hmac(algorithm, key, evidence$2);
    }

    default public <F> Resource<F, Hasher<F>> hmac(HashAlgorithm algorithm, Chunk<Object> key, Sync<F> evidence$2) {
        return package$.MODULE$.Resource().eval(package$.MODULE$.Sync().apply(evidence$2).delay((Function0 & Serializable)() -> this.unsafeHmac(algorithm, key, evidence$2)));
    }

    public static /* synthetic */ Hasher unsafe$(HasherCompanionPlatform $this, HashAlgorithm algorithm, Sync evidence$3) {
        return $this.unsafe(algorithm, evidence$3);
    }

    default public <F> Hasher<F> unsafe(HashAlgorithm algorithm, Sync<F> evidence$3) {
        return this.unsafeFromMessageDigest(MessageDigest.getInstance(this.toAlgorithmString(algorithm)), evidence$3);
    }

    public static /* synthetic */ String toAlgorithmString$(HasherCompanionPlatform $this, HashAlgorithm algorithm) {
        return $this.toAlgorithmString(algorithm);
    }

    default public String toAlgorithmString(HashAlgorithm algorithm) {
        HashAlgorithm hashAlgorithm = algorithm;
        if (HashAlgorithm$MD5$.MODULE$.equals(hashAlgorithm)) {
            return "MD5";
        }
        if (HashAlgorithm$SHA1$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-1";
        }
        if (HashAlgorithm$SHA224$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-224";
        }
        if (HashAlgorithm$SHA256$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-256";
        }
        if (HashAlgorithm$SHA384$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-384";
        }
        if (HashAlgorithm$SHA512$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-512";
        }
        if (HashAlgorithm$SHA512_224$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-512/224";
        }
        if (HashAlgorithm$SHA512_256$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-512/256";
        }
        if (HashAlgorithm$SHA3_224$.MODULE$.equals(hashAlgorithm)) {
            return "SHA3-224";
        }
        if (HashAlgorithm$SHA3_256$.MODULE$.equals(hashAlgorithm)) {
            return "SHA3-256";
        }
        if (HashAlgorithm$SHA3_384$.MODULE$.equals(hashAlgorithm)) {
            return "SHA3-384";
        }
        if (HashAlgorithm$SHA3_512$.MODULE$.equals(hashAlgorithm)) {
            return "SHA3-512";
        }
        if (hashAlgorithm instanceof HashAlgorithm.Named) {
            HashAlgorithm.Named named = (HashAlgorithm.Named)hashAlgorithm;
            String name = named.name();
            return name;
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(22).append("unsupported algorithm ").append(hashAlgorithm).toString());
    }

    public static /* synthetic */ Hasher unsafeHmac$(HasherCompanionPlatform $this, HashAlgorithm algorithm, Chunk key, Sync evidence$4) {
        return $this.unsafeHmac(algorithm, key, evidence$4);
    }

    default public <F> Hasher<F> unsafeHmac(HashAlgorithm algorithm, Chunk<Object> key, Sync<F> evidence$4) {
        String name = this.toMacAlgorithmString(algorithm);
        Mac mac = Mac.getInstance(name);
        mac.init(new SecretKeySpec((byte[])key.toArray(ClassTag$.MODULE$.Byte()), name));
        return this.unsafeFromMac(mac, evidence$4);
    }

    public static /* synthetic */ String toMacAlgorithmString$(HasherCompanionPlatform $this, HashAlgorithm algorithm) {
        return $this.toMacAlgorithmString(algorithm);
    }

    default public String toMacAlgorithmString(HashAlgorithm algorithm) {
        HashAlgorithm hashAlgorithm = algorithm;
        if (HashAlgorithm$MD5$.MODULE$.equals(hashAlgorithm)) {
            return "HmacMD5";
        }
        if (HashAlgorithm$SHA1$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA1";
        }
        if (HashAlgorithm$SHA224$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA224";
        }
        if (HashAlgorithm$SHA256$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA256";
        }
        if (HashAlgorithm$SHA384$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA384";
        }
        if (HashAlgorithm$SHA512$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA512";
        }
        if (HashAlgorithm$SHA512_224$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA512/224";
        }
        if (HashAlgorithm$SHA512_256$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA512/256";
        }
        if (HashAlgorithm$SHA3_224$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA3-224";
        }
        if (HashAlgorithm$SHA3_256$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA3-256";
        }
        if (HashAlgorithm$SHA3_384$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA3-384";
        }
        if (HashAlgorithm$SHA3_512$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA3-512";
        }
        if (hashAlgorithm instanceof HashAlgorithm.Named) {
            HashAlgorithm.Named named = (HashAlgorithm.Named)hashAlgorithm;
            String name = named.name();
            return name;
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(22).append("unsupported algorithm ").append(hashAlgorithm).toString());
    }

    public static /* synthetic */ Hasher unsafeFromMessageDigest$(HasherCompanionPlatform $this, MessageDigest d, Sync evidence$5) {
        return $this.unsafeFromMessageDigest(d, evidence$5);
    }

    default public <F> Hasher<F> unsafeFromMessageDigest(MessageDigest d, Sync<F> evidence$5) {
        return new SyncHasher<F>(null, evidence$5, d){
            private final MessageDigest d$1;

            public void unsafeUpdate(Chunk<Object> chunk) {
                Chunk.ArraySlice<O2> slice = chunk.toArraySlice(ClassTag$.MODULE$.Byte());
                this.d$1.update((byte[])slice.values(), slice.offset(), slice.size());
            }

            public Hash unsafeHash() {
                return new Hash(Chunk$.MODULE$.array(this.d$1.digest(), ClassTag$.MODULE$.Byte()));
            }
            {
                this.d$1 = d$1;
                super(evidence$5$1);
            }
        };
    }

    public static /* synthetic */ Hasher unsafeFromMac$(HasherCompanionPlatform $this, Mac d, Sync evidence$6) {
        return $this.unsafeFromMac(d, evidence$6);
    }

    default public <F> Hasher<F> unsafeFromMac(Mac d, Sync<F> evidence$6) {
        return new SyncHasher<F>(null, evidence$6, d){
            private final Mac d$2;

            public void unsafeUpdate(Chunk<Object> chunk) {
                Chunk.ArraySlice<O2> slice = chunk.toArraySlice(ClassTag$.MODULE$.Byte());
                this.d$2.update((byte[])slice.values(), slice.offset(), slice.size());
            }

            public Hash unsafeHash() {
                return new Hash(Chunk$.MODULE$.array(this.d$2.doFinal(), ClassTag$.MODULE$.Byte()));
            }
            {
                this.d$2 = d$2;
                super(evidence$6$1);
            }
        };
    }

    public static void $init$(HasherCompanionPlatform $this) {
    }
}

