/*
 * Decompiled with CFR 0.152.
 */
package com.ats.driver;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ApplicationProperties {
    public static int BROWSER_TYPE = 0;
    public static int DESKTOP_TYPE = 1;
    public static int MOBILE_TYPE = 2;
    public static int API_TYPE = 3;
    private int type = BROWSER_TYPE;
    private String name = "chrome";
    private String driver;
    private String uri;
    private int wait = -1;
    private int debugPort = -1;
    private int check = -1;
    private String lang;
    private String userDataDir;
    private String title;
    private String[] options;

    public ApplicationProperties(String name) {
        this.name = name;
    }

    public ApplicationProperties(int type, String name, String driver, String uri, int wait, int check, String lang, String userDataDir, String title, String[] options, int debugPort) {
        this.type = type;
        this.name = name;
        this.driver = driver;
        this.uri = uri;
        this.wait = wait;
        this.check = check;
        this.lang = lang;
        this.userDataDir = userDataDir;
        this.title = title;
        this.options = options;
        this.debugPort = debugPort;
    }

    public static String getUserDataPath(String userDataDir, String browserName) {
        if (userDataDir != null) {
            Path p = Paths.get(userDataDir, new String[0]);
            if (p.isAbsolute()) {
                if (Files.exists(p, new LinkOption[0]) && Files.isDirectory(p, new LinkOption[0]) || !Files.exists(p, new LinkOption[0])) {
                    return p.toFile().getAbsolutePath();
                }
            } else {
                Path userDir = Paths.get(System.getProperty("user.home"), new String[0]).resolve("ats").resolve("profiles").resolve(browserName).resolve(userDataDir);
                return userDir.toFile().getAbsolutePath();
            }
        }
        return null;
    }

    public String getUserDataDirPath(String browserName) {
        return ApplicationProperties.getUserDataPath(this.userDataDir, browserName);
    }

    public boolean isWeb() {
        return this.type == BROWSER_TYPE;
    }

    public boolean isDesktop() {
        return this.type == DESKTOP_TYPE;
    }

    public boolean isMobile() {
        return this.type == MOBILE_TYPE;
    }

    public boolean isApi() {
        return this.type == API_TYPE;
    }

    public String getName() {
        return this.name;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUri() {
        return this.uri;
    }

    public int getWait() {
        return this.wait;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public int getCheck() {
        return this.check;
    }

    public String getLang() {
        return this.lang;
    }

    public String getUserDataDir() {
        return this.userDataDir;
    }

    public String getTitle() {
        return this.title;
    }

    public String[] getOptions() {
        return this.options;
    }
}

