/*
 * Decompiled with CFR 0.152.
 */
package com.ats.element;

import com.ats.element.AtsBaseElement;
import com.ats.executor.drivers.desktop.DesktopData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.remote.RemoteWebElement;

public class AtsElement
extends AtsBaseElement {
    private static final String IFRAME = "IFRAME";
    private static final String FRAME = "FRAME";
    private RemoteWebElement element;
    protected boolean numeric = false;
    protected boolean password = false;
    protected int numChildren = 0;
    private Double screenX = 0.0;
    private Double screenY = 0.0;
    private Double boundX = 0.0;
    private Double boundY = 0.0;
    private boolean visible = true;
    private boolean clickable = true;
    private ArrayList<AtsElement> children;

    public static boolean checkIframe(String value) {
        return IFRAME.equalsIgnoreCase(value) || FRAME.equalsIgnoreCase(value);
    }

    public AtsElement() {
    }

    public AtsElement(List<Object> data) {
        this.element = (RemoteWebElement)data.get(0);
        this.tag = data.get(1).toString();
        this.numeric = (Boolean)data.get(2);
        this.password = (Boolean)data.get(3);
        this.boundX = AtsElement.getDataValue(data.get(4));
        this.boundY = AtsElement.getDataValue(data.get(5));
        this.width = AtsElement.getDataValue(data.get(6));
        this.height = AtsElement.getDataValue(data.get(7));
        this.x = AtsElement.getDataValue(data.get(8));
        this.y = AtsElement.getDataValue(data.get(9));
        this.screenX = AtsElement.getDataValue(data.get(10));
        this.screenY = AtsElement.getDataValue(data.get(11));
        this.attributes = (Map)data.get(12);
    }

    private static Double getDataValue(Object data) {
        if (data == null) {
            return 0.0;
        }
        return (Double)data;
    }

    public RemoteWebElement getElement() {
        return this.element;
    }

    public Double getScreenX() {
        return this.screenX;
    }

    public Double getScreenY() {
        return this.screenY;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public Double getBoundX() {
        return this.boundX;
    }

    public void setBoundX(Double boundX) {
        this.boundX = boundX;
    }

    public Double getBoundY() {
        return this.boundY;
    }

    public void setBoundY(Double boundY) {
        this.boundY = boundY;
    }

    @Override
    public String getAttribute(String key) {
        Object attr = this.attributes.get(key);
        if (attr instanceof ArrayList) {
            return Arrays.toString(((ArrayList)attr).toArray());
        }
        return (String)attr;
    }

    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean value) {
        this.password = value;
    }

    public ArrayList<DesktopData> getAttributes() {
        return null;
    }

    public void setChildren(ArrayList<AtsElement> value) {
        this.children = value;
    }

    public ArrayList<AtsElement> getChildren() {
        return this.children;
    }

    public void setAttributes(ArrayList<DesktopData> value) {
        this.attributes = value.parallelStream().collect(Collectors.toMap(s -> s.getName(), s -> s.getValue()));
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    public int getNumChildren() {
        return this.numChildren;
    }

    public void setNumChildren(int value) {
        this.numChildren = value;
    }

    public boolean isIframe() {
        return AtsElement.checkIframe(this.tag);
    }
}

