/*
 * Decompiled with CFR 0.152.
 */
package com.ats.element;

import com.ats.element.AtsBaseElement;
import com.ats.element.FoundElement;
import com.ats.generator.variables.CalculatedProperty;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AtsMobileElement
extends AtsBaseElement {
    private static final String INNER_TEXT = "innerText";
    private static final String TEXT = "text";
    private static final String ROOT = "root";
    private boolean clickable = false;
    private AtsMobileElement parent;
    private AtsMobileElement[] children;
    private String positionInDom;
    private Rectangle rect;

    public Rectangle getRect() {
        if (this.rect == null) {
            this.rect = new Rectangle(this.x.intValue(), this.y.intValue(), this.width.intValue(), this.height.intValue());
        }
        return this.rect;
    }

    public AtsMobileElement(String id, String tag, Double width, Double height, Double x, Double y, Boolean clickable, Map<String, String> attributes) {
        this.id = id;
        this.tag = tag;
        this.width = width;
        this.height = height;
        this.clickable = clickable;
        this.x = x;
        this.y = y;
        this.attributes = attributes;
    }

    public void setPositionInDom(String value) {
        this.positionInDom = value;
    }

    public String getPositionInDom() {
        return this.positionInDom;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    private String getText() {
        String result = (String)this.attributes.get(TEXT);
        if (result == null) {
            return "";
        }
        return result;
    }

    private String getInnerText() {
        Object result = this.getText();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                result = (String)result + " " + this.children[i].getInnerText();
            }
        }
        return ((String)result).trim();
    }

    public CalculatedProperty[] getMobileAttributes() {
        List properties = ((Stream)this.attributes.entrySet().stream().parallel()).map(e -> new CalculatedProperty((String)e.getKey(), (String)e.getValue())).collect(Collectors.toCollection(ArrayList::new));
        properties.add(new CalculatedProperty(INNER_TEXT, this.getInnerText()));
        return properties.toArray(new CalculatedProperty[properties.size()]);
    }

    @Override
    public String getAttribute(String key) {
        if (INNER_TEXT.equals(key)) {
            return this.getInnerText();
        }
        return super.getAttribute(key);
    }

    public boolean isRoot() {
        return ROOT.equals(this.tag);
    }

    public boolean checkTag(String value) {
        return "*".equals(value) || this.tag.toLowerCase().equals(value.toLowerCase());
    }

    public FoundElement getFoundElement() {
        return new FoundElement(this);
    }

    public AtsMobileElement getParent() {
        return this.parent;
    }

    public void setParent(AtsMobileElement parent) {
        this.parent = parent;
    }

    public AtsMobileElement[] getChildren() {
        if (this.children == null) {
            return new AtsMobileElement[0];
        }
        return this.children;
    }

    public void setChildren(AtsMobileElement[] children) {
        this.children = children;
    }

    public void addChildren(AtsMobileElement element) {
        ArrayList<Object> tmpChild = new ArrayList<AtsMobileElement>();
        if (this.children != null) {
            tmpChild = new ArrayList<AtsMobileElement>(Arrays.asList(this.children));
        }
        tmpChild.add(element);
        this.children = tmpChild.toArray(new AtsMobileElement[tmpChild.size()]);
    }
}

