/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor;

import com.ats.generator.ATS;
import com.ats.tools.report.CampaignReportGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.testng.IExecutionListener;
import org.testng.TestNG;
import org.xml.sax.SAXException;

public class ExecutionListener
implements IExecutionListener {
    private static final String TESTNG_FILE_NAME = "testng-results.xml";
    private static final String[] JASPER_PROPERTY_NAME = new String[]{"jasper", "jasper.home", "jasper-home"};
    private static final String JASPER_HOME_ENVIRONMENT = "JASPER_HOME";

    private Path getOutputFolderPath() {
        String outputFolder = System.getProperty("output-folder");
        if (outputFolder != null) {
            return Paths.get(outputFolder, new String[0]);
        }
        return Paths.get(TestNG.getDefault().getOutputDirectory(), new String[0]);
    }

    private File getJsonSuitesFile() {
        Path p = this.getOutputFolderPath();
        if (p != null) {
            return p.resolve(CampaignReportGenerator.ATS_JSON_SUITES).toFile();
        }
        return null;
    }

    public void onExecutionStart() {
        super.onExecutionStart();
        try {
            this.getJsonSuitesFile().delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("[ATS-SCRIPT] -------------------------------------");
        System.out.println("[ATS-SCRIPT]      ATS " + ATS.VERSION + " execution start");
        System.out.println("[ATS-SCRIPT] -------------------------------------");
    }

    public void onExecutionFinish() {
        super.onExecutionFinish();
        System.out.println("[ATS-SCRIPT] ----------------------------------");
        System.out.println("[ATS-SCRIPT]       ATS execution complete");
        System.out.println("[ATS-SCRIPT] ----------------------------------");
        String atsReport = System.getProperty("ats-report");
        if (atsReport != null) {
            String outputPath = this.getOutputFolderPath().toAbsolutePath().toFile().getAbsolutePath();
            System.out.println("[ATS-SCRIPT] Generate ATS report -> " + outputPath);
            File jsonSuiteFile = this.getJsonSuitesFile();
            if (jsonSuiteFile != null && jsonSuiteFile.exists()) {
                String s;
                String jasperHome = null;
                String[] stringArray = JASPER_PROPERTY_NAME;
                int n = stringArray.length;
                for (int i = 0; i < n && ((jasperHome = System.getProperty(s = stringArray[i])) == null || jasperHome.length() <= 0); ++i) {
                }
                if (jasperHome == null) {
                    jasperHome = System.getenv(JASPER_HOME_ENVIRONMENT);
                }
                try {
                    new CampaignReportGenerator(this.getOutputFolderPath(), jsonSuiteFile, atsReport, jasperHome);
                }
                catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                    e.printStackTrace();
                }
            }
        }
        Path testNGResultsPath = Paths.get("target", "surefire-reports", TESTNG_FILE_NAME);
        Path destResultsPath = this.getOutputFolderPath().resolve(TESTNG_FILE_NAME);
        try {
            if (testNGResultsPath.toFile().exists()) {
                Files.copy(testNGResultsPath, destResultsPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

