/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.channels;

import com.ats.driver.AtsManager;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.executor.channels.EmptyChannel;
import com.ats.executor.drivers.DriverManager;
import com.ats.script.actions.ActionChannelStart;
import java.util.ArrayList;
import java.util.Optional;

public class ChannelManager {
    private Channel currentChannel;
    private ArrayList<Channel> channelsList;
    private ActionTestScript mainScript;
    private DriverManager driverManager;

    public ChannelManager(ActionTestScript script) {
        this.mainScript = script;
        this.channelsList = new ArrayList();
        this.driverManager = new DriverManager();
        this.currentChannel = new EmptyChannel();
        script.sendInfoLog("ATS drivers folder", AtsManager.getInstance().getDriversFolderPath().toFile().getAbsolutePath());
        if (AtsManager.getInstance().getError() != null) {
            script.sendInfoLog("ActionTestScript properties file found, but an error occured !", AtsManager.getInstance().getError());
        }
        if (AtsManager.getInstance().getWaitGuiReady() != null) {
            script.sendInfoLog("Custom WaitGuiReady class found !", "");
        }
    }

    public int getMaxTry() {
        return AtsManager.getInstance().getMaxTrySearch();
    }

    public int getMaxTryScroll() {
        return AtsManager.getInstance().getMaxTryScrollSearch();
    }

    public Channel getCurrentChannel() {
        return this.currentChannel;
    }

    public Channel[] getChannelsList() {
        if (this.channelsList.size() > 0) {
            return this.channelsList.toArray(new Channel[this.channelsList.size()]);
        }
        return new Channel[0];
    }

    private void setCurrentChannel(Channel channel) {
        for (Channel cnl : this.channelsList) {
            cnl.setCurrent(cnl == channel);
        }
        this.currentChannel = channel;
        channel.setCurrent(true);
    }

    public void closeAllChannels() {
        while (this.channelsList.size() > 0) {
            this.channelsList.remove(0).close();
        }
    }

    public Channel getChannel(String name) {
        for (Channel cnl : this.channelsList) {
            if (!cnl.getName().equals(name)) continue;
            return cnl;
        }
        return new EmptyChannel();
    }

    public String startChannel(ActionStatus status, ActionChannelStart action) {
        String name = action.getName();
        String appName = action.getApplication().getCalculated();
        if (this.getChannel(name) instanceof EmptyChannel) {
            Channel newChannel = new Channel(status, this.mainScript, this.driverManager, action);
            if (status.isPassed()) {
                for (Channel cn : this.channelsList) {
                    cn.clearData();
                }
                this.channelsList.add(newChannel);
                this.setCurrentChannel(newChannel);
                status.setChannel(newChannel);
                status.endDuration();
                this.mainScript.getRecorder().createVisualStartChannelAction(action, status.getDuration(), this.mainScript.getTestName(), action.getLine());
            }
            status.setData(this.getChannelsList());
        }
        return appName;
    }

    public void switchChannel(ActionStatus status, String name) {
        status.startDuration();
        if (this.channelsList != null) {
            for (Channel cnl : this.channelsList) {
                if (!cnl.getName().equals(name)) continue;
                if (!cnl.isCurrent()) {
                    this.setCurrentChannel(cnl);
                    status.setData(this.getChannelsList());
                    status.setChannel(cnl);
                }
                status.setPassed(true);
                status.endDuration();
                return;
            }
        }
        status.setError(-9, "channel [" + name + "] is not running");
    }

    public void closeChannel(ActionStatus status, String channelName, boolean keepRunning) {
        Optional<Channel> cn = this.channelsList.stream().filter(c -> c.getName().equals(channelName)).findFirst();
        if (cn.isPresent()) {
            cn.get().close(status, keepRunning);
        }
    }

    public void channelClosed(ActionStatus status, Channel channel) {
        status.startDuration();
        if (this.channelsList.remove(channel)) {
            if (this.channelsList.size() > 0) {
                if (channel.isCurrent()) {
                    Channel current = this.channelsList.get(0);
                    this.setCurrentChannel(current);
                    status.setChannel(current);
                }
            } else {
                this.currentChannel = new EmptyChannel();
            }
            status.setNoError();
            status.setData(this.getChannelsList());
        } else {
            status.setError(-19, "channel '" + channel.getName() + "' not found");
        }
        status.endDuration();
    }

    public void tearDown() {
        this.closeAllChannels();
        this.driverManager.tearDown();
    }
}

