/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers;

import com.ats.executor.ActionStatus;
import com.ats.executor.StreamGobbler;
import com.ats.executor.drivers.DriverManager;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.Path;
import java.util.stream.Stream;

public class DriverProcess {
    private String name;
    private int port = 4444;
    private Process process;
    private DriverManager manager;
    private boolean keepRunning = false;

    public DriverProcess(ActionStatus status, String name, DriverManager manager, Path driverFolderPath, String driverName, String[] args) {
        this.name = name;
        this.manager = manager;
        File driverFile = driverFolderPath.resolve(driverName).toFile();
        if (driverFile.exists()) {
            this.port = DriverProcess.findFreePort();
            String[] arguments = new String[]{driverFile.getAbsolutePath(), "--port=" + this.port};
            if (args != null) {
                arguments = (String[])Stream.of(arguments, args).flatMap(Stream::of).toArray(String[]::new);
            }
            ProcessBuilder builder = new ProcessBuilder(arguments);
            builder.redirectErrorStream(true);
            builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
            try {
                this.process = builder.start();
                StreamGobbler errorGobbler = new StreamGobbler(this.process.getErrorStream(), "ERROR");
                StreamGobbler outputGobbler = new StreamGobbler(this.process.getInputStream(), "OUTPUT");
                errorGobbler.start();
                outputGobbler.start();
            }
            catch (IOException e1) {
                status.setError(-19, e1.getMessage());
                return;
            }
        } else {
            status.setError(-19, "unable to launch driver process, driver file is missing : " + driverFile.getAbsolutePath());
            return;
        }
        Runtime.getRuntime().addShutdownHook(new CloseProcess(this));
        status.setNoError();
    }

    public void quit() {
        if (this.process != null && this.process.isAlive()) {
            if (!this.keepRunning) {
                this.process.descendants().forEach(p -> p.destroy());
                this.process.destroy();
                try {
                    this.process.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.process = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public URL getDriverServerUrl() {
        try {
            return new URL("http://localhost:" + this.port);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public URL getDriverLoopback() {
        try {
            return new URL("http://127.0.0.1:" + this.port);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static Integer findFreePort() {
        Integer n;
        ServerSocket socket = new ServerSocket(0);
        try {
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return 2106;
            }
        }
        socket.close();
        return n;
    }

    public void close(boolean keepRunning) {
        this.quit();
        this.manager.processTerminated(this);
    }

    static class CloseProcess
    extends Thread {
        private DriverProcess driver;

        public CloseProcess(DriverProcess driver) {
            this.driver = driver;
        }

        @Override
        public void run() {
            this.driver.quit();
        }
    }
}

