/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.desktop;

import com.ats.element.AtsBaseElement;
import com.ats.element.FoundElement;
import com.ats.element.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ScriptStatus;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.DriverManager;
import com.ats.executor.drivers.DriverProcess;
import com.ats.executor.drivers.desktop.DesktopData;
import com.ats.executor.drivers.desktop.DesktopResponse;
import com.ats.executor.drivers.desktop.DesktopWindow;
import com.ats.executor.drivers.engines.DesktopDriverEngine;
import com.ats.generator.objects.MouseDirectionData;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.recorder.ReportSummary;
import com.ats.script.ScriptHeader;
import com.ats.tools.logger.ExecutionLogger;
import com.exadel.flamingo.flex.messaging.amf.io.AMF3Deserializer;
import com.google.gson.Gson;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.remote.RemoteWebDriver;

public class DesktopDriver
extends RemoteWebDriver {
    private static final int TIME_OUT = 60;
    private List<FoundElement> elementMapLocation;
    private String driverHost;
    private int driverPort;
    private DesktopDriverEngine engine;
    private String driverUrl;
    private OkHttpClient client;
    private String driverVersion;
    private String osName;
    private String osVersion;
    private String osBuildVersion;
    private String countryCode;
    private String machineName;
    private String screenWidth;
    private String screenHeight;
    private String driveLetter;
    private String diskTotalSize;
    private String diskFreeSpace;
    private String cpuArchitecture;
    private String cpuCores;
    private String cpuName;
    private String cpuSocket;
    private String cpuMaxClock;
    private String dotNetVersion;
    private static final String USER_AGENT = "AtsDesktopDriver";
    private static final MediaType MEDIA_UTF8 = MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");

    public DesktopDriver() {
    }

    public DesktopDriver(ActionStatus status, DriverManager driverManager) {
        DriverProcess desktopDriverProcess = driverManager.getDesktopDriver(status);
        if (status.isPassed()) {
            this.driverHost = desktopDriverProcess.getDriverServerUrl().getHost();
            this.driverPort = desktopDriverProcess.getDriverServerUrl().getPort();
            this.driverUrl = "http://" + this.getDriverHost() + ":" + this.getDriverPort();
            this.client = new OkHttpClient.Builder().cache(null).connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
            DesktopResponse resp = this.sendRequestCommand(CommandType.Driver, DriverType.Capabilities, new Object[0]);
            for (int maxTry = 10; maxTry > 0 && (resp == null || resp.errorCode == -999); --maxTry) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                resp = this.sendRequestCommand(CommandType.Driver, DriverType.Capabilities, new Object[0]);
            }
            if (resp.errorCode != -999) {
                for (DesktopData data : resp.data) {
                    if ("BuildNumber".equals(data.getName())) {
                        this.osBuildVersion = data.getValue();
                        continue;
                    }
                    if ("Name".equals(data.getName())) {
                        this.osName = data.getValue();
                        continue;
                    }
                    if ("Version".equals(data.getName())) {
                        this.osVersion = data.getValue();
                        continue;
                    }
                    if ("DriverVersion".equals(data.getName())) {
                        this.driverVersion = data.getValue();
                        continue;
                    }
                    if ("CountryCode".equals(data.getName())) {
                        this.countryCode = data.getValue();
                        continue;
                    }
                    if ("MachineName".equals(data.getName())) {
                        this.machineName = data.getValue();
                        continue;
                    }
                    if ("ScreenWidth".equals(data.getName())) {
                        this.screenWidth = data.getValue();
                        continue;
                    }
                    if ("ScreenHeight".equals(data.getName())) {
                        this.screenHeight = data.getValue();
                        continue;
                    }
                    if ("DriveLetter".equals(data.getName())) {
                        this.driveLetter = data.getValue();
                        continue;
                    }
                    if ("DiskTotalSize".equals(data.getName())) {
                        this.diskTotalSize = data.getValue();
                        continue;
                    }
                    if ("DiskFreeSpace".equals(data.getName())) {
                        this.diskFreeSpace = data.getValue();
                        continue;
                    }
                    if ("CpuSocket".equals(data.getName())) {
                        this.cpuSocket = data.getValue();
                        continue;
                    }
                    if ("CpuName".equals(data.getName())) {
                        this.cpuName = data.getValue();
                        continue;
                    }
                    if ("CpuArchitecture".equals(data.getName())) {
                        this.cpuArchitecture = data.getValue();
                        continue;
                    }
                    if ("CpuMaxClockSpeed".equals(data.getName())) {
                        this.cpuMaxClock = data.getValue();
                        continue;
                    }
                    if ("CpuCores".equals(data.getName())) {
                        this.cpuCores = data.getValue();
                        continue;
                    }
                    if (!"DotNetVersion".equals(data.getName())) continue;
                    this.dotNetVersion = data.getValue();
                }
                status.setPassed(true);
            } else {
                status.setError(-19, "unable to connect to desktop driver, check DotNET and OS version ...");
            }
        }
    }

    public Double getScreenWidth() {
        try {
            return Double.parseDouble(this.screenWidth);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public Double getScreenHeight() {
        try {
            return Double.parseDouble(this.screenHeight);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public TestBound getScreenBound() {
        return new TestBound(0.0, 0.0, this.getScreenWidth(), this.getScreenHeight());
    }

    public void setEngine(DesktopDriverEngine engine) {
        this.engine = engine;
        engine.setDriver(this);
    }

    public DesktopDriverEngine getEngine() {
        return this.engine;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public String getOsBuildVersion() {
        return this.osBuildVersion;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public String getScreenResolution() {
        return this.screenWidth + " x " + this.screenHeight;
    }

    public String getDriveLetter() {
        return this.driveLetter;
    }

    public String getDiskTotalSize() {
        return this.diskTotalSize;
    }

    public String getDiskFreeSpace() {
        return this.diskFreeSpace;
    }

    public String getCpuArchitecture() {
        return this.cpuArchitecture;
    }

    public String getCpuCores() {
        return this.cpuCores;
    }

    public String getCpuName() {
        return this.cpuName;
    }

    public String getCpuSocket() {
        return this.cpuSocket;
    }

    public String getCpuMaxClock() {
        return this.cpuMaxClock;
    }

    public String getDotNetVersion() {
        return this.dotNetVersion;
    }

    public String getDriverHost() {
        return this.driverHost;
    }

    public int getDriverPort() {
        return this.driverPort;
    }

    public void closeDriver() {
        this.sendRequestCommand(CommandType.Driver, DriverType.Close, new Object[0]);
    }

    public void closeWindows(long processId, int handle) {
        this.sendRequestCommand(CommandType.Driver, DriverType.CloseWindows, processId, handle);
    }

    public void clearText() {
        this.sendRequestCommand(CommandType.Keyboard, KeyType.Clear, new Object[0]);
    }

    public void clearText(String elemId) {
        this.sendRequestCommand(CommandType.Keyboard, KeyType.Clear, elemId);
    }

    public void sendKeys(String data, String elemId) {
        this.sendRequestCommand(CommandType.Keyboard, KeyType.Enter, data, elemId);
    }

    public void mouseMove(int x, int y) {
        this.sendRequestCommand(CommandType.Mouse, MouseType.Move, x, y);
    }

    public void mouseClick() {
        this.sendRequestCommand(CommandType.Mouse, MouseType.Click, new Object[0]);
    }

    public void mouseMiddleClick() {
        this.sendRequestCommand(CommandType.Mouse, MouseType.MiddleClick, new Object[0]);
    }

    public void mouseRightClick() {
        this.sendRequestCommand(CommandType.Mouse, MouseType.RightClick, new Object[0]);
    }

    public void mouseClick(int key) {
        this.sendRequestCommand(CommandType.Mouse, MouseType.Click, key);
    }

    public void mouseDown() {
        this.sendRequestCommand(CommandType.Mouse, MouseType.Down, new Object[0]);
    }

    public void drag() {
        this.sendRequestCommand(CommandType.Mouse, MouseType.Drag, new Object[0]);
    }

    public void mouseRelease() {
        this.sendRequestCommand(CommandType.Mouse, MouseType.Release, new Object[0]);
    }

    public void mouseWheel(int delta) {
        this.sendRequestCommand(CommandType.Mouse, MouseType.Wheel, delta);
    }

    public void doubleClick() {
        this.sendRequestCommand(CommandType.Mouse, MouseType.DoubleClick, new Object[0]);
    }

    public void keyDown(int codePoint) {
        this.sendRequestCommand(CommandType.Keyboard, KeyType.Down, codePoint);
    }

    public void keyUp(int codePoint) {
        this.sendRequestCommand(CommandType.Keyboard, KeyType.Release, codePoint);
    }

    public List<FoundElement> getWebElementsListByHandle(TestBound channelDimension, int handle) {
        return this.sendRequestCommand(CommandType.Element, ElementType.LoadTree, handle).getFoundElements(channelDimension);
    }

    public void defineRoot(TestBound channelDimension, String id) {
        this.setElementMapLocation(this.sendRequestCommand(CommandType.Element, ElementType.Root, id).getFoundElements(channelDimension));
    }

    public void refreshElementMapLocation(Channel channel) {
        new Thread(new LoadMapElement(channel, this)).start();
    }

    public void refreshElementMap(Channel channel) {
        this.setElementMapLocation(this.getWebElementsListByHandle(channel.getDimension(), channel.getHandle(this)));
    }

    public void setElementMapLocation(List<FoundElement> list) {
        FoundElement parent = new FoundElement();
        list.parallelStream().forEach(e -> this.recalculateSize(parent, (FoundElement)e));
        this.elementMapLocation = list;
    }

    private void recalculateSize(FoundElement parent, FoundElement elem) {
        if (elem.isVisible() && elem.getWidth() > 0.0 && elem.getHeight() > 0.0) {
            parent.updateSize(elem.getBoundX() + elem.getWidth(), elem.getBoundY() + elem.getHeight());
        }
        elem.getChildren().parallelStream().forEach(e -> this.recalculateSize(elem, (FoundElement)e));
    }

    public FoundElement getElementFromPoint(Double x, Double y) {
        Optional<FoundElement> fe;
        double xPos = x;
        double yPos = y - 10.0;
        if (this.elementMapLocation != null && this.elementMapLocation.size() > 0 && (fe = this.elementMapLocation.stream().filter(e -> e.isActive() && e.getRectangle().contains(xPos, yPos)).findFirst()).isPresent()) {
            return this.getHoverChild(fe.get(), xPos, yPos);
        }
        return null;
    }

    private FoundElement getHoverChild(FoundElement elem, double xPos, double yPos) {
        Optional child;
        if (elem.getChildren() != null && elem.getChildren().size() > 0 && (child = ((Stream)((Stream)elem.getChildren().stream().parallel()).filter(e -> e.isActive() && e.getRectangle().contains(xPos, yPos)).parallel()).sorted((a, b) -> -1).findFirst()).isPresent()) {
            return this.getHoverChild((FoundElement)child.get(), xPos, yPos);
        }
        return elem;
    }

    public FoundElement getElementFromRect(Double x, Double y, Double w, Double h) {
        FoundElement hoverElement = null;
        if (this.elementMapLocation != null) {
            for (FoundElement testElement : this.elementMapLocation) {
                if (testElement == null || !testElement.isVisible()) continue;
                if (hoverElement == null) {
                    hoverElement = testElement;
                    continue;
                }
                Rectangle rect = testElement.getRectangle();
                if (!rect.contains(x, y) || rect.getWidth() > w || rect.getHeight() > h || hoverElement.getWidth() <= testElement.getWidth() && hoverElement.getHeight() <= testElement.getHeight()) continue;
                hoverElement = testElement;
            }
        }
        return hoverElement;
    }

    public FoundElement getRootElement(Channel channel) {
        return this.getRootElement(channel.getHandle(this));
    }

    public FoundElement getRootElement(int handle) {
        return new FoundElement(this.sendRequestCommand(CommandType.Window, WindowType.Handle, handle).getWindow());
    }

    public DesktopResponse startApplication(boolean attach, ArrayList<String> args) {
        return this.sendRequestCommand(CommandType.Driver, DriverType.Application, attach, String.join((CharSequence)"\n", args));
    }

    public List<DesktopWindow> getWindowsByPid(Long pid) {
        return this.sendRequestCommand(CommandType.Window, WindowType.List, pid).getWindows();
    }

    public void updateWindowHandle(Channel channel) {
        int handle = channel.getHandle(this);
        if (handle > 0) {
            this.getEngine().setWindow(this.sendRequestCommand(CommandType.Window, WindowType.Handle, handle).getWindow());
        }
    }

    public DesktopWindow getWindowByHandle(int handle) {
        return this.sendRequestCommand(CommandType.Window, WindowType.Handle, handle).getWindow();
    }

    public DesktopWindow getWindowByTitle(String title, String name) {
        return this.sendRequestCommand(CommandType.Window, WindowType.Title, title, name).getWindow();
    }

    public void setChannelToFront(int handle, long pid) {
        this.sendRequestCommand(CommandType.Window, WindowType.ToFront, handle, pid);
    }

    public void setWindowToFront(Long pid, int handle) {
        this.sendRequestCommand(CommandType.Window, WindowType.ToFront, pid, handle);
    }

    public void rootKeys(int handle, String keys) {
        this.sendRequestCommand(CommandType.Window, WindowType.Keys, handle, keys);
    }

    public void moveWindow(Channel channel, Point point) {
        this.sendRequestCommand(CommandType.Window, WindowType.Move, channel.getHandle(this), point.x, point.y);
    }

    public void resizeWindow(Channel channel, Dimension size) {
        this.sendRequestCommand(CommandType.Window, WindowType.Resize, channel.getHandle(this), size.width, size.height);
    }

    public void switchTo(Channel channel, int index) {
        this.sendRequestCommand(CommandType.Window, WindowType.Switch, channel.getHandle(this, index));
    }

    public DesktopResponse switchTo(Long processId, int index, int handle) {
        return this.sendRequestCommand(CommandType.Window, WindowType.Switch, processId, index, handle);
    }

    public void closeWindow(Channel channel) {
        this.closeWindow(channel.getHandle(this));
    }

    public void closeWindow(int handle) {
        this.sendRequestCommand(CommandType.Window, WindowType.Close, handle);
    }

    public void windowState(ActionStatus status, Channel channel, String state) {
        this.sendRequestCommand(CommandType.Window, WindowType.State, channel.getHandle(this), state);
    }

    public void gotoUrl(ActionStatus status, int handle, String url) {
        status.setData(url);
        DesktopResponse resp = this.sendRequestCommand(CommandType.Window, WindowType.Url, handle, url);
        if (resp.errorCode < 0) {
            status.setError(resp.errorCode, resp.errorMessage);
        } else {
            status.setPassed(true);
        }
    }

    public FoundElement getTestElementParent(String elementId, Channel channel) {
        return this.sendRequestCommand(CommandType.Element, ElementType.Parents, elementId).getParentsElement(channel.getDimension());
    }

    public CalculatedProperty[] getElementAttributes(String elementId) {
        return this.sendRequestCommand(CommandType.Element, ElementType.Attributes, elementId).getAttributes();
    }

    public List<DesktopData> executeScript(ActionStatus status, String script, FoundElement element) {
        return this.sendRequestCommand(CommandType.Element, ElementType.Script, element.getId(), script).getData();
    }

    public void elementFocus(FoundElement element) {
        this.sendRequestCommand(CommandType.Element, ElementType.Focus, element.getId());
    }

    public List<FoundElement> findElements(Channel channel, TestElement testElement, String tag, String[] attributes, Predicate<AtsBaseElement> predicate) {
        DesktopResponse response = null;
        String[] firstData = new String[2];
        firstData[1] = tag;
        Object[] data = Stream.concat(Stream.of(firstData), Stream.of(attributes)).toArray(String[]::new);
        if (testElement.getParent() != null) {
            data[0] = testElement.getParent().getWebElementId();
            response = this.sendRequestCommand(CommandType.Element, ElementType.Childs, data);
        } else {
            data[0] = "" + channel.getHandle(this);
            response = this.sendRequestCommand(CommandType.Element, ElementType.Find, data);
        }
        return response.getFoundElements(predicate, channel.getDimension());
    }

    public List<FoundElement> getListItems(TestBound dimension, String comboId) {
        return this.sendRequestCommand(CommandType.Element, ElementType.ListItems, new Object[]{comboId}).getFoundElements(dimension);
    }

    public List<FoundElement> getChildren(TestBound dimension, String comboId, String tag) {
        return this.sendRequestCommand(CommandType.Element, ElementType.Childs, comboId, tag).getFoundElements(dimension);
    }

    public void selectItem(ActionStatus status, String elementId, String type, String value, boolean regexp) {
        DesktopResponse resp = this.sendRequestCommand(CommandType.Element, ElementType.Select, elementId, type, value, regexp);
        if (resp.errorMessage != null) {
            status.setError(-1, resp.errorMessage);
        }
    }

    public String getElementAttribute(String elementId, String attribute) {
        DesktopResponse resp = this.sendRequestCommand(CommandType.Element, ElementType.Attributes, elementId, attribute);
        return resp.getFirstAttribute();
    }

    public List<FoundElement> getDialogBox(TestBound dimension) {
        DesktopResponse resp = this.sendRequestCommand(CommandType.Element, ElementType.DialogBox, new Object[0]);
        return resp.getFoundElements(dimension);
    }

    public void saveSummary(ScriptStatus status, ReportSummary summary) {
        this.sendRequestCommand(CommandType.Record, RecordType.Summary, summary.toData(status));
    }

    public void stopVisualRecord() {
        this.sendRequestCommand(CommandType.Record, RecordType.Stop, new Object[0]);
    }

    public byte[] getScreenshotByte(Double x, Double y, Double w, Double h) {
        DesktopResponse resp = this.sendRequestCommand(CommandType.Record, RecordType.Screenshot, x.intValue(), y.intValue(), w.intValue(), h.intValue());
        return resp.image;
    }

    public void createMobileRecord(boolean stop, String actionType, int scriptLine, String scriptName, long timeline, String channelName, TestBound subDimension, String screenshotPath, boolean sync) {
        this.sendRequestCommand(CommandType.Record, RecordType.CreateMobile, actionType, scriptLine, scriptName, timeline, channelName, subDimension.getX().intValue(), subDimension.getY().intValue(), subDimension.getWidth().intValue(), subDimension.getHeight().intValue(), screenshotPath, sync, stop);
    }

    public void createVisualAction(Channel channel, boolean stop, String actionType, int scriptLine, String scriptName, long timeline, boolean sync) {
        this.sendRequestCommand(CommandType.Record, RecordType.Create, actionType, scriptLine, scriptName, timeline, channel.getName(), channel.getDimension().getX().intValue(), channel.getDimension().getY().intValue(), channel.getDimension().getWidth().intValue(), channel.getDimension().getHeight().intValue(), sync, stop);
    }

    public byte[] getMobileScreenshotByte(String url) {
        DesktopResponse resp = this.sendRequestCommand(CommandType.Record, RecordType.ScreenshotMobile, url);
        return resp.image;
    }

    public void updateMobileScreenshot(TestBound bound, boolean isRef, String url) {
        this.sendRequestCommand(CommandType.Record, RecordType.ImageMobile, 0, 0, bound.getWidth().intValue(), bound.getHeight().intValue(), isRef, url);
    }

    public DesktopResponse startVisualRecord(Channel channel, ScriptHeader script, int quality, long started) {
        return this.sendRequestCommand(CommandType.Record, RecordType.Start, script.getId(), script.getQualifiedName(), script.getDescription(), script.getAuthor(), script.getJoinedGroups(), script.getPrerequisite(), quality, started);
    }

    public void updateVisualImage(TestBound dimension, boolean isRef) {
        this.sendRequestCommand(CommandType.Record, RecordType.Image, dimension.getX().intValue(), dimension.getY().intValue(), dimension.getWidth().intValue(), dimension.getHeight().intValue(), isRef);
    }

    public void updateVisualValue(String value) {
        this.sendRequestCommand(CommandType.Record, RecordType.Value, value);
    }

    public void updateVisualData(String value, String data) {
        this.sendRequestCommand(CommandType.Record, RecordType.Data, value, data);
    }

    public void updateVisualStatus(int error, long duration) {
        this.sendRequestCommand(CommandType.Record, RecordType.Status, error, duration);
    }

    public void updateVisualElement(TestElement element) {
        String savedCriterias;
        Double x = 0.0;
        Double y = 0.0;
        Double w = 0.0;
        Double h = 0.0;
        int numElements = element.getFoundElements().size();
        if (numElements > 0) {
            int i = element.getIndex() == 0 ? 0 : element.getIndex() - 1;
            TestBound bound = element.getFoundElements().get(i).getTestBound();
            x = bound.getX();
            y = bound.getY();
            w = bound.getWidth();
            h = bound.getHeight();
            if (element.isSysComp()) {
                x = x + 8.0;
                y = y + 8.0;
            }
        }
        if ((savedCriterias = element.getCriterias()).length() > 100) {
            savedCriterias = savedCriterias.substring(0, 100);
        }
        this.sendRequestCommand(CommandType.Record, RecordType.Element, x.intValue(), y.intValue(), w.intValue(), h.intValue(), element.getTotalSearchDuration(), numElements, savedCriterias, element.getSearchedTag());
    }

    public void updateVisualPosition(String type, MouseDirectionData hdir, MouseDirectionData vdir) {
        String hdirName = "";
        int hdirValue = 0;
        String vdirName = "";
        int vdirValue = 0;
        if (hdir != null) {
            hdirName = hdir.getName();
            hdirValue = hdir.getIntValue();
        }
        if (vdir != null) {
            vdirName = vdir.getName();
            vdirValue = vdir.getIntValue();
        }
        this.sendRequestCommand(CommandType.Record, RecordType.Position, hdirName, hdirValue, vdirName, vdirValue);
    }

    private DesktopResponse sendRequestCommand(CommandType type, Enum<?> subType, Object ... data) {
        return this.sendRequestCommand(type, subType, Stream.of(data).map(Object::toString).collect(Collectors.joining("\n")));
    }

    private DesktopResponse sendRequestCommand(CommandType type, Enum<?> subType, String data) {
        String url = this.driverUrl + "/" + (Object)((Object)type) + "/" + subType;
        Request request = new Request.Builder().url(url).addHeader("User-Agent", USER_AGENT).post(RequestBody.create((MediaType)MEDIA_UTF8, (String)data)).build();
        try {
            Response response = this.client.newCall(request).execute();
            AMF3Deserializer amf3 = new AMF3Deserializer(response.body().byteStream());
            DesktopResponse desktopResponse = (DesktopResponse)amf3.readObject();
            amf3.close();
            response.close();
            return desktopResponse;
        }
        catch (IOException e) {
            return new DesktopResponse(e.getMessage());
        }
    }

    public void saveVisualReportFile(Path path, ExecutionLogger logger) {
        String url = this.driverUrl + "/" + (Object)((Object)CommandType.Record) + "/" + (Object)((Object)RecordType.Download);
        Request request = new Request.Builder().url(url).addHeader("User-Agent", USER_AGENT).get().build();
        try {
            Response resp = this.client.newCall(request).execute();
            if (resp.code() == 200) {
                int inByte;
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path.toFile()));
                BufferedInputStream bis = new BufferedInputStream(resp.body().byteStream());
                while ((inByte = bis.read()) != -1) {
                    bos.write(inByte);
                }
                bis.close();
                bos.close();
                logger.sendInfo("Save ATSV file", path.toString());
            } else {
                logger.sendError("Unable to save ATSV file", resp.message());
            }
            resp.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getSource() {
        Gson gson = new Gson();
        return gson.toJson(this.elementMapLocation);
    }

    private static enum CommandType {
        Driver(0),
        Record(1),
        Window(2),
        Element(3),
        Keyboard(4),
        Mouse(5);

        private final int type;

        private CommandType(int value) {
            this.type = value;
        }

        public String toString() {
            return "" + this.type;
        }
    }

    private static enum DriverType {
        Capabilities(0),
        Application(1),
        CloseWindows(2),
        Close(3);

        private final int type;

        private DriverType(int value) {
            this.type = value;
        }

        public String toString() {
            return "" + this.type;
        }
    }

    private static enum KeyType {
        Clear(0),
        Enter(1),
        Down(2),
        Release(3);

        private final int type;

        private KeyType(int value) {
            this.type = value;
        }

        public String toString() {
            return "" + this.type;
        }
    }

    private static enum MouseType {
        Move(0),
        Click(1),
        RightClick(2),
        MiddleClick(3),
        DoubleClick(4),
        Down(5),
        Release(6),
        Wheel(7),
        Drag(8);

        private final int type;

        private MouseType(int value) {
            this.type = value;
        }

        public String toString() {
            return "" + this.type;
        }
    }

    private static enum ElementType {
        Childs(0),
        Parents(1),
        Find(2),
        Attributes(3),
        Select(4),
        FromPoint(5),
        Script(6),
        Root(7),
        LoadTree(8),
        ListItems(9),
        DialogBox(10),
        SetValue(11),
        Focus(12);

        private final int type;

        private ElementType(int value) {
            this.type = value;
        }

        public String toString() {
            return "" + this.type;
        }
    }

    private static class LoadMapElement
    implements Runnable {
        final TestBound channelDimension;
        final int handle;
        final DesktopDriver driver;

        public LoadMapElement(Channel channel, DesktopDriver driver) {
            this.channelDimension = channel.getDimension();
            this.handle = channel.getHandle(driver);
            this.driver = driver;
        }

        @Override
        public void run() {
            this.driver.setElementMapLocation(this.driver.getWebElementsListByHandle(this.channelDimension, this.handle));
        }
    }

    private static enum WindowType {
        Title(0),
        Handle(1),
        List(2),
        Move(3),
        Resize(4),
        ToFront(5),
        Switch(6),
        Close(7),
        Url(8),
        Keys(9),
        State(10);

        private final int type;

        private WindowType(int value) {
            this.type = value;
        }

        public String toString() {
            return "" + this.type;
        }
    }

    private static enum RecordType {
        Stop(0),
        Screenshot(1),
        Start(2),
        Create(3),
        Image(4),
        Value(5),
        Data(6),
        Status(7),
        Element(8),
        Position(9),
        Download(10),
        ImageMobile(11),
        CreateMobile(12),
        ScreenshotMobile(13),
        Summary(14);

        private final int type;

        private RecordType(int value) {
            this.type = value;
        }

        public String toString() {
            return "" + this.type;
        }
    }
}

