/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines;

import com.ats.driver.ApplicationProperties;
import com.ats.element.AtsBaseElement;
import com.ats.element.DesktopRootElement;
import com.ats.element.DialogBox;
import com.ats.element.FoundElement;
import com.ats.element.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.SendKeyData;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.desktop.DesktopDriver;
import com.ats.executor.drivers.desktop.DesktopResponse;
import com.ats.executor.drivers.desktop.DesktopWindow;
import com.ats.executor.drivers.engines.DriverEngine;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.executor.drivers.engines.desktop.DesktopAlert;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.script.actions.ActionApi;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

public class DesktopDriverEngine
extends DriverEngine
implements IDriverEngine {
    private static final String DESKTOP_TYPE = "desktop";
    private static final int DEFAULT_WAIT = 100;
    protected DesktopWindow window;
    private int windowIndex = -1;

    public DesktopDriverEngine(Channel channel, DesktopWindow window) {
        super(channel);
        this.window = window;
    }

    public DesktopDriverEngine(Channel channel, DesktopDriver desktopDriver, ApplicationProperties props, int defaultWait) {
        super(channel, desktopDriver, props, 100, 0);
        desktopDriver.setEngine(this);
    }

    public DesktopDriverEngine(Channel channel, ActionStatus status, String application, DesktopDriver desktopDriver, ApplicationProperties props) {
        this(channel, desktopDriver, props, 100);
        if (application.startsWith(DESKTOP_TYPE)) {
            channel.setApplicationData(desktopDriver.getOsName() + " (" + desktopDriver.getOsVersion() + ")", "", desktopDriver.getDriverVersion(), 0L);
            FoundElement desktop = desktopDriver.getRootElement(-1);
            channel.setDimensions(desktop.getTestScreenBound(), desktop.getTestScreenBound());
        } else {
            ArrayList<String> args;
            if (props.getUri() != null) {
                application = props.getUri();
                args = new ArrayList<String>(Arrays.asList(application));
                if (props.getOptions() != null) {
                    Arrays.asList(props.getOptions()).forEach(o -> args.add((String)o));
                }
            } else {
                args = new ArrayList<String>(Arrays.asList(application));
                channel.getArguments().forEach(c -> args.add(c.getCalculated()));
            }
            DesktopResponse resp = this.getDesktopDriver().startApplication(channel.attachToExistingProcess(), args);
            if (resp.errorCode == 0) {
                this.window = resp.getWindow();
                if (this.window != null) {
                    channel.setApplicationData(desktopDriver.getOsName() + " (" + desktopDriver.getOsVersion() + ")", this.window.getAppName(), this.window.getAppVersion() + " (" + this.window.getAppBuildVersion() + ")", desktopDriver.getDriverVersion(), this.window.getPid(), this.window.getHandle(), this.window.getAppIcon());
                    this.windowIndex = 0;
                    this.applicationPath = this.window.getAppPath();
                    desktopDriver.moveWindow(channel, channel.getDimension().getPoint());
                    desktopDriver.resizeWindow(channel, channel.getDimension().getSize());
                } else {
                    status.setError(-19, "no window found for this application");
                }
            } else {
                status.setError(-19, resp.errorMessage);
            }
        }
    }

    public void setWindow(DesktopWindow window) {
        this.window = window;
    }

    @Override
    public void waitAfterAction(ActionStatus status) {
        this.actionWait();
    }

    @Override
    public DesktopDriver getDesktopDriver() {
        return (DesktopDriver)this.driver;
    }

    @Override
    public void loadParents(FoundElement hoverElement) {
        hoverElement.setParent(this.getDesktopDriver().getTestElementParent(hoverElement.getId(), this.channel));
    }

    @Override
    public String getAttribute(ActionStatus status, FoundElement element, String attributeName, int maxTry) {
        return this.getDesktopDriver().getElementAttribute(element.getId(), attributeName);
    }

    @Override
    public CalculatedProperty[] getAttributes(FoundElement element, boolean reload) {
        return this.getAttributes(element.getId());
    }

    @Override
    public void setSysProperty(String propertyName, String propertyValue) {
    }

    public CalculatedProperty[] getAttributes(String elementId) {
        return this.getDesktopDriver().getElementAttributes(elementId);
    }

    @Override
    public List<String[]> loadSelectOptions(TestElement element) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        List<FoundElement> options = this.findSelectOptions(this.channel.getDimension(), element);
        if (options != null && options.size() > 0) {
            options.stream().forEachOrdered(e -> result.add(e.getItemAttribute()));
        }
        return result;
    }

    @Override
    public List<FoundElement> findSelectOptions(TestBound dimension, TestElement element) {
        return this.getDesktopDriver().getListItems(dimension, element.getFoundElement().getId());
    }

    @Override
    public void selectOptionsItem(ActionStatus status, TestElement element, CalculatedProperty selectProperty) {
        this.getDesktopDriver().selectItem(status, element.getFoundElement().getId(), selectProperty.getName(), selectProperty.getValue().getCalculated(), selectProperty.isRegexp());
    }

    @Override
    public FoundElement getElementFromPoint(Boolean syscomp, Double x, Double y) {
        return this.getDesktopDriver().getElementFromPoint(x, y);
    }

    @Override
    public FoundElement getElementFromRect(Boolean syscomp, Double x, Double y, Double w, Double h) {
        return this.getDesktopDriver().getElementFromRect(x, y, w, h);
    }

    @Override
    public List<FoundElement> findElements(boolean sysComp, TestElement testElement, String tag, String[] attributes, String[] attributesValues, Predicate<AtsBaseElement> predicate, WebElement startElement) {
        if (sysComp) {
            if (SYSCOMP.equals(tag.toUpperCase())) {
                return new ArrayList<FoundElement>(List.of(new FoundElement(this.window)));
            }
            return this.getDesktopDriver().findElements(this.channel, testElement, tag, attributesValues, predicate);
        }
        return this.getDesktopDriver().findElements(this.channel, testElement, tag, attributesValues, predicate);
    }

    @Override
    public void updateDimensions() {
        DesktopWindow win = this.getDesktopDriver().getWindowByHandle(this.channel.getHandle(this.desktopDriver));
        if (win != null && win.getWidth() > 0.0 && win.getHeight() > 0.0) {
            this.channel.setDimensions(new TestBound(win.getX(), win.getY(), win.getWidth(), win.getHeight()), this.channel.getSubDimension());
        }
    }

    @Override
    public void close(boolean keepRunning) {
        if (this.getDesktopDriver() != null) {
            this.getDesktopDriver().closeWindows(this.channel.getProcessId(), this.channel.getHandle());
            this.getDesktopDriver().closeDriver();
        }
    }

    @Override
    public void switchWindow(ActionStatus status, int index, int tries) {
        DesktopResponse resp = this.getDesktopDriver().switchTo(this.channel.getProcessId(), index, this.channel.getHandle());
        for (int maxTry = 1 + tries; resp.errorCode == -14 && maxTry > 0; --maxTry) {
            this.channel.sleep(1000);
            resp = this.getDesktopDriver().switchTo(this.channel.getProcessId(), index, this.channel.getHandle());
        }
        if (resp.errorCode == -14) {
            status.setError(-14, "cannot switch to window index '" + index + "'");
        } else {
            this.channel.updateWinHandle(this.getDesktopDriver(), index);
            this.windowIndex = index;
            status.setPassed(true);
        }
    }

    @Override
    public void setWindowToFront() {
        this.channel.toFront();
        this.getDesktopDriver().switchTo(this.channel.getProcessId(), this.windowIndex, this.channel.getHandle());
    }

    @Override
    public void closeWindow(ActionStatus status) {
        this.getDesktopDriver().closeWindow(this.channel);
    }

    @Override
    public void middleClick(ActionStatus status, MouseDirection position, TestElement element) {
        this.getDesktopDriver().mouseMiddleClick();
    }

    @Override
    public void doubleClick() {
        this.getDesktopDriver().doubleClick();
    }

    @Override
    public void rightClick() {
        this.getDesktopDriver().mouseRightClick();
    }

    @Override
    public void mouseMoveToElement(FoundElement element) {
        this.getDesktopDriver().elementFocus(element);
    }

    @Override
    public void mouseMoveToElement(ActionStatus status, FoundElement foundElement, MouseDirection position, boolean desktopDragDrop, int offsetX, int offsetY) {
        Rectangle rect = foundElement.getRectangle();
        this.getDesktopDriver().mouseMove(this.getOffsetX(rect, position) + foundElement.getScreenX().intValue() - foundElement.getCenterWidth(), this.getOffsetY(rect, position) + foundElement.getScreenY().intValue() - foundElement.getCenterHeight());
    }

    @Override
    public void mouseClick(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
        this.getDesktopDriver().mouseClick();
    }

    @Override
    public void drag(ActionStatus status, FoundElement element, MouseDirection md, int offsetX, int offsetY) {
        this.getDesktopDriver().drag();
    }

    @Override
    public void drop(MouseDirection md, boolean desktopDriver) {
        this.getDesktopDriver().mouseRelease();
    }

    @Override
    public void keyDown(Keys key) {
        this.getDesktopDriver().keyDown(key.getCodePoint());
    }

    @Override
    public void keyUp(Keys key) {
        this.getDesktopDriver().keyUp(key.getCodePoint());
    }

    @Override
    public void moveByOffset(int hDirection, int vDirection) {
        Point pt = MouseInfo.getPointerInfo().getLocation();
        this.getDesktopDriver().mouseMove(pt.x + hDirection, pt.y + vDirection);
    }

    @Override
    protected void setPosition(org.openqa.selenium.Point pt) {
        this.getDesktopDriver().moveWindow(this.channel, pt);
    }

    @Override
    protected void setSize(Dimension size) {
        this.getDesktopDriver().resizeWindow(this.channel, size);
    }

    @Override
    public void clearText(ActionStatus status, TestElement te, MouseDirection md) {
        FoundElement element = te.getFoundElement();
        this.mouseMoveToElement(status, element, md, false, 0, 0);
        this.mouseClick(status, element, null, 0, 0);
        this.getDesktopDriver().clearText(te.getWebElementId());
    }

    @Override
    public void sendTextData(ActionStatus status, TestElement element, ArrayList<SendKeyData> textActionList) {
        for (SendKeyData sequence : textActionList) {
            if (sequence.getDownKey() != null) {
                this.getDesktopDriver().keyDown(sequence.getDownKey().getCodePoint());
                this.getDesktopDriver().sendKeys(sequence.getSequenceDesktop(), element.getWebElementId());
                this.getDesktopDriver().keyUp(sequence.getDownKey().getCodePoint());
                continue;
            }
            this.getDesktopDriver().sendKeys(sequence.getSequenceDesktop(), element.getWebElementId());
        }
    }

    @Override
    public void refreshElementMapLocation() {
        this.getDesktopDriver().refreshElementMapLocation(this.channel);
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public Object executeScript(ActionStatus status, String script, Object ... params) {
        status.setPassed(true);
        return null;
    }

    @Override
    public void goToUrl(ActionStatus status, String url) {
        this.getDesktopDriver().gotoUrl(status, this.window.getHandle(), url);
    }

    @Override
    public WebElement getRootElement(Channel cnl) {
        return new DesktopRootElement(this.getDesktopDriver().getRootElement(cnl));
    }

    @Override
    public void scroll(FoundElement element) {
    }

    @Override
    public void scroll(int delta) {
        this.getDesktopDriver().mouseWheel(delta);
    }

    @Override
    public void scroll(FoundElement element, int delta) {
        this.getDesktopDriver().mouseWheel(delta);
    }

    @Override
    public DialogBox switchToAlert() {
        return new DesktopAlert(this, this.channel.getDimension());
    }

    @Override
    public boolean switchToDefaultContent() {
        return true;
    }

    @Override
    public void switchToFrameId(String id) {
    }

    @Override
    public String getSource() {
        this.getDesktopDriver().refreshElementMap(this.channel);
        return this.getDesktopDriver().getSource();
    }

    @Override
    public void api(ActionStatus status, ActionApi api) {
    }

    @Override
    public void buttonClick(ActionStatus status, String id) {
    }

    @Override
    public void tap(int count, FoundElement element) {
    }

    @Override
    public void press(int duration, ArrayList<String> paths, FoundElement element) {
    }

    @Override
    public void windowState(ActionStatus status, Channel channel, String state) {
        this.getDesktopDriver().windowState(status, channel, state);
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String script, TestElement element) {
        return this.getDesktopDriver().executeScript(status, script, element.getFoundElement());
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String script, boolean returnValue) {
        status.setPassed(true);
        return null;
    }

    public List<FoundElement> getDialogBox() {
        return this.getDesktopDriver().getDialogBox(this.channel.getDimension());
    }

    @Override
    public int getNumWindows() {
        return this.getDesktopDriver().getWindowsByPid(this.channel.getProcessId()).size();
    }

    @Override
    public String getUrl() {
        return this.applicationPath;
    }

    @Override
    public Rectangle getBoundRect(TestElement testElement) {
        return null;
    }
}

