/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines;

import com.ats.driver.ApplicationProperties;
import com.ats.element.AtsBaseElement;
import com.ats.element.AtsMobileElement;
import com.ats.element.DialogBox;
import com.ats.element.FoundElement;
import com.ats.element.MobileRootElement;
import com.ats.element.MobileTestElement;
import com.ats.element.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.SendKeyData;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.desktop.DesktopDriver;
import com.ats.executor.drivers.engines.DriverEngine;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.executor.drivers.engines.mobiles.AndroidRootElement;
import com.ats.executor.drivers.engines.mobiles.IosRootElement;
import com.ats.executor.drivers.engines.mobiles.MobileAlert;
import com.ats.executor.drivers.engines.mobiles.RootElement;
import com.ats.generator.ATS;
import com.ats.generator.objects.BoundData;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.graphic.ImageTemplateMatchingSimple;
import com.ats.script.actions.ActionApi;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

public class MobileDriverEngine
extends DriverEngine
implements IDriverEngine {
    private static final String DRIVER = "driver";
    private static final String APP = "app";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String SWITCH = "switch";
    private static final String CAPTURE = "capture";
    public static final String INPUT = "input";
    public static final String ELEMENT = "element";
    public static final String ALERT = "alert";
    public static final String TAP = "tap";
    public static final String PRESS = "press";
    public static final String SWIPE = "swipe";
    public static final String SCRIPTING = "scripting";
    public static final String SET_PROP = "property-set";
    public static final String GET_PROP = "property";
    public static final String SYS_BUTTON = "sysbutton";
    private static final String SCREENSHOT_METHOD = "/screenshot";
    private JsonObject source;
    private MobileTestElement testElement;
    private OkHttpClient client;
    protected RootElement rootElement;
    protected RootElement cachedElement;
    protected long cachedElementTime = 0L;
    private String userAgent;
    private String token;
    private String endPoint;

    public MobileDriverEngine(Channel channel, ActionStatus status, String app, DesktopDriver desktopDriver, ApplicationProperties props, String token) {
        super(channel, desktopDriver, props, 0, 60);
        String[] appData;
        int start;
        if (this.applicationPath == null) {
            this.applicationPath = app;
        }
        if ((start = this.applicationPath.indexOf("://")) > -1) {
            this.applicationPath = this.applicationPath.substring(start + 3);
        }
        if ((appData = this.applicationPath.split("/")).length > 0) {
            this.endPoint = appData[0];
            this.applicationPath = "http://" + this.endPoint;
            this.client = new OkHttpClient.Builder().cache(null).connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(40L, TimeUnit.SECONDS).build();
            this.userAgent = "AtsMobileDriver/" + ATS.VERSION + "," + System.getProperty("user.name") + ",";
            this.token = token;
            JsonObject response = this.executeRequest(DRIVER, START);
            if (response == null) {
                status.setError(-19, "unable to connect to : mobile://" + this.endPoint);
                return;
            }
            if (response.get("status").getAsInt() != 0) {
                status.setError(-19, response.get("message").getAsString());
                return;
            }
            this.token = response.get("token").getAsString();
            channel.addSystemProperties(response.getAsJsonArray("systemProperties"));
            channel.addSystemButtons(response.getAsJsonArray("systemButtons"));
            String systemName = response.get("systemName").getAsString();
            String driverVersion = response.get("driverVersion").getAsString();
            String userName = response.get("mobileUser").getAsString();
            String machineName = response.get("mobileName").getAsString();
            String osBuild = response.get("osBuild").getAsString();
            String country = response.get("country").getAsString();
            String os = response.get("os").getAsString();
            double deviceWidth = 0.0;
            double deviceHeight = 0.0;
            double channelWidth = 0.0;
            double channelHeight = 0.0;
            if (os.equals("android")) {
                this.rootElement = new AndroidRootElement(this);
                this.cachedElement = new AndroidRootElement(this);
                deviceWidth = response.get("deviceWidth").getAsDouble();
                deviceHeight = response.get("deviceHeight").getAsDouble();
                channelWidth = response.get("channelWidth").getAsDouble();
                channelHeight = response.get("channelHeight").getAsDouble();
            }
            int screenCapturePort = response.get("screenCapturePort").getAsInt();
            String application = null;
            if (appData.length > 1) {
                application = appData[1];
                response = this.executeRequest(APP, START, application);
            } else if (os.equals("android")) {
                response = this.executeRequest(APP, START);
            } else {
                status.setError(-19, "unable to connect : missing app");
                return;
            }
            if (response == null) {
                status.setError(-19, "unable to connect to : " + application);
                return;
            }
            if (response.get("status").getAsInt() != 0) {
                status.setError(-19, response.get("message").getAsString());
                return;
            }
            String base64 = response.get("icon").getAsString();
            byte[] icon = new byte[]{};
            if (base64.length() > 0) {
                try {
                    icon = Base64.getDecoder().decode(base64);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (os.equals("ios")) {
                this.rootElement = new IosRootElement(this);
                this.cachedElement = new IosRootElement(this);
                deviceWidth = response.get("deviceWidth").getAsDouble();
                deviceHeight = response.get("deviceHeight").getAsDouble();
                channelWidth = response.get("channelWidth").getAsDouble();
                channelHeight = response.get("channelHeight").getAsDouble();
            }
            String[] endPointData = this.endPoint.split(":");
            String version = response.get("version").getAsString();
            String udpInfo = endPointData[0] + ":" + screenCapturePort;
            channel.setDimensions(new TestBound(0.0, 0.0, deviceWidth, deviceHeight), new TestBound(0.0, 0.0, channelWidth, channelHeight));
            channel.setApplicationData(os, systemName, version, driverVersion, icon, udpInfo, application, userName, machineName, osBuild, country);
            this.refreshElementMapLocation();
        }
    }

    @Override
    public WebElement getRootElement(Channel cnl) {
        this.refreshElementMapLocation();
        return new MobileRootElement(this.rootElement.getValue());
    }

    @Override
    public TestElement getTestElementRoot() {
        this.refreshElementMapLocation();
        return new TestElement(new FoundElement(this.rootElement.getValue()), this.channel);
    }

    @Override
    public void refreshElementMapLocation() {
        this.source = this.executeRequest(CAPTURE, new String[0]);
        this.rootElement.refresh(this.source);
    }

    protected void loadCapturedElement() {
        long current = System.currentTimeMillis();
        if (this.cachedElement == null || current - 2500L > this.cachedElementTime) {
            if (this.cachedElement != null) {
                this.cachedElement.refresh(this.executeRequest(CAPTURE, new String[0]));
            }
            this.cachedElementTime = System.currentTimeMillis();
        }
    }

    @Override
    public void close(boolean keepRunning) {
        String application = this.channel.getApplication();
        if (application != null) {
            this.executeRequest(APP, STOP, application);
        }
        this.channel = null;
    }

    public void tearDown() {
        JsonObject jsonObject = this.executeRequest(DRIVER, STOP);
        if (jsonObject != null) {
            this.token = null;
        }
    }

    @Override
    public FoundElement getElementFromPoint(Boolean syscomp, Double x, Double y) {
        this.loadCapturedElement();
        ArrayList<AtsMobileElement> listElements = new ArrayList<AtsMobileElement>();
        this.loadList(this.cachedElement.getValue(), listElements, "A");
        int mouseX = (int)(this.channel.getSubDimension().getX() + x);
        int mouseY = (int)(this.channel.getSubDimension().getY() + y);
        AtsMobileElement element = this.cachedElement.getValue();
        listElements.sort(Comparator.comparing(AtsMobileElement::getPositionInDom));
        for (AtsMobileElement child : listElements) {
            int coordinateX = child.getX().intValue();
            int coordinateY = child.getY().intValue();
            int coordinateW = child.getWidth().intValue();
            int coordinateH = child.getHeight().intValue();
            if (!child.getRect().contains(new Point(mouseX, mouseY)) || !element.getRect().contains(new Point(coordinateX, coordinateY)) && !element.getRect().contains(new Point(coordinateX + coordinateW, coordinateY)) && !element.getRect().contains(new Point(coordinateX + coordinateW, coordinateY + coordinateH)) && !element.getRect().contains(new Point(coordinateX, coordinateY + coordinateH))) continue;
            element = child;
        }
        return element.getFoundElement();
    }

    @Override
    public FoundElement getElementFromRect(Boolean syscomp, Double x, Double y, Double w, Double h) {
        this.loadCapturedElement();
        ArrayList<AtsMobileElement> listElements = new ArrayList<AtsMobileElement>();
        this.loadList(this.cachedElement.getValue(), listElements, "A");
        int mouseX = (int)(this.channel.getSubDimension().getX() + x);
        int mouseY = (int)(this.channel.getSubDimension().getY() + y);
        AtsMobileElement element = this.cachedElement.getValue();
        listElements.sort(Comparator.comparing(AtsMobileElement::getPositionInDom));
        for (AtsMobileElement child : listElements) {
            if (!child.getRect().contains(new Point(mouseX, mouseY)) || !(child.getRect().getWidth() <= w) || !(child.getRect().getHeight() <= h) || !element.getRect().contains(child.getRect())) continue;
            element = child;
        }
        return element.getFoundElement();
    }

    public String getToken() {
        return this.token;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    private void loadList(AtsMobileElement element, ArrayList<AtsMobileElement> list, String order) {
        AtsMobileElement[] children = element.getChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (element.getChildren() == null) continue;
                AtsMobileElement child = element.getChildren()[i];
                String newOrder = order + this.getCharForNumber(i + 1);
                child.setPositionInDom(newOrder);
                list.add(child);
                this.loadList(child, list, newOrder);
            }
        }
    }

    private String getCharForNumber(int i) {
        return i > 0 && i < 27 ? String.valueOf((char)(i + 64)) : "Z";
    }

    @Override
    public void loadParents(FoundElement element) {
        AtsMobileElement parent;
        AtsMobileElement atsElement = this.getCapturedElementById(element.getId(), false);
        if (atsElement != null && (parent = atsElement.getParent()) != null) {
            element.setParent(parent.getFoundElement());
            FoundElement currentParent = element.getParent();
            for (parent = parent.getParent(); parent != null && !parent.isRoot(); parent = parent.getParent()) {
                currentParent.setParent(parent.getFoundElement());
                currentParent = currentParent.getParent();
            }
        }
    }

    @Override
    public CalculatedProperty[] getAttributes(FoundElement element, boolean reload) {
        AtsMobileElement atsElement = this.getCapturedElementById(element.getId(), reload);
        if (atsElement != null) {
            return atsElement.getMobileAttributes();
        }
        return new CalculatedProperty[0];
    }

    private AtsMobileElement getCapturedElementById(String id, boolean reload) {
        if (reload) {
            return this.getElementById(this.rootElement.getValue(), id);
        }
        if (this.cachedElement != null) {
            return this.getElementById(this.cachedElement.getValue(), id);
        }
        return null;
    }

    @Override
    public String getAttribute(ActionStatus status, FoundElement element, String attributeName, int maxTry) {
        AtsMobileElement atsElement = this.getElementById(element.getId());
        if (atsElement != null) {
            return atsElement.getAttribute(attributeName);
        }
        return null;
    }

    @Override
    public List<FoundElement> findElements(boolean sysComp, TestElement testObject, String tagName, String[] attributes, String[] attributesValues, Predicate<AtsBaseElement> searchPredicate, WebElement startElement) {
        ArrayList<AtsMobileElement> list = new ArrayList<AtsMobileElement>();
        TestElement parent = testObject.getParent();
        if (parent == null) {
            this.refreshElementMapLocation();
            this.loadElementsByTag(this.rootElement.getValue(), tagName, list);
        } else {
            this.loadElementsByTag(this.getElementById(parent.getWebElementId()), tagName, list);
        }
        return list.parallelStream().filter(searchPredicate).map(FoundElement::new).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public List<FoundElement> findElements(TestElement parent, ImageTemplateMatchingSimple template) {
        byte[] screenshot = this.getDesktopDriver().getMobileScreenshotByte(this.getScreenshotPath());
        return template.findOccurrences(screenshot).parallelStream().map(r -> new FoundElement(this.channel, parent, (Rectangle)r)).collect(Collectors.toCollection(ArrayList::new));
    }

    public void loadElementsByTag(AtsMobileElement root, String tag, List<AtsMobileElement> list) {
        if (root == null) {
            return;
        }
        if (root.checkTag(tag)) {
            list.add(root);
        }
        for (AtsMobileElement child : root.getChildren()) {
            this.loadElementsByTag(child, tag, list);
        }
    }

    @Override
    public void buttonClick(ActionStatus status, String type) {
        JsonObject result = this.executeRequest(SYS_BUTTON, type);
        int code = result.get("status").getAsInt();
        String message = result.get("message").getAsString();
        status.setCode(code);
        status.setMessage(message);
        status.setPassed(true);
    }

    @Override
    public void tap(int count, FoundElement element) {
        this.rootElement.tap(element, count);
    }

    @Override
    public void press(int duration, ArrayList<String> paths, FoundElement element) {
        this.rootElement.press(element, paths, duration);
    }

    @Override
    public void mouseClick(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
        this.cachedElementTime = 0L;
        this.rootElement.tap(status, element, position);
    }

    @Override
    public void drag(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
        this.testElement = this.rootElement.getCurrentElement(element, position);
    }

    @Override
    public void moveByOffset(int hDirection, int vDirection) {
        this.rootElement.swipe(this.testElement, hDirection, vDirection);
    }

    @Override
    public void sendTextData(ActionStatus status, TestElement element, ArrayList<SendKeyData> textActionList) {
        for (SendKeyData sequence : textActionList) {
            this.executeRequest(ELEMENT, element.getFoundElement().getId(), INPUT, sequence.getSequenceMobile());
        }
    }

    @Override
    public List<String[]> loadSelectOptions(TestElement element) {
        return Collections.emptyList();
    }

    @Override
    public List<FoundElement> findSelectOptions(TestBound dimension, TestElement element) {
        return Collections.emptyList();
    }

    @Override
    public void selectOptionsItem(ActionStatus status, TestElement element, CalculatedProperty selectProperty) {
    }

    @Override
    public void clearText(ActionStatus status, TestElement te, MouseDirection md) {
        this.mouseClick(status, te.getFoundElement(), md, 0, 0);
        this.executeRequest(ELEMENT, te.getFoundElement().getId(), INPUT, "&empty;");
    }

    @Override
    public void updateScreenshot(TestBound dimension, boolean isRef) {
        this.getDesktopDriver().updateMobileScreenshot(this.channel.getSubDimension(), isRef, this.getScreenshotPath());
    }

    @Override
    public byte[] getScreenshot(Double x, Double y, Double width, Double height) {
        byte[] screen = this.getDesktopDriver().getMobileScreenshotByte(this.getScreenshotPath());
        if (screen != null) {
            ImageIO.setUseCache(false);
            ByteArrayInputStream in = new ByteArrayInputStream(screen);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedImage subImage = new BufferedImage(width.intValue(), height.intValue(), 1);
            Graphics g = subImage.getGraphics();
            try {
                g.drawImage(ImageIO.read(in), 0, 0, width.intValue(), height.intValue(), x.intValue(), y.intValue(), x.intValue() + width.intValue(), y.intValue() + height.intValue(), null);
                g.dispose();
                ImageIO.write((RenderedImage)subImage, "png", baos);
                baos.flush();
                byte[] result = baos.toByteArray();
                baos.close();
                return result;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new byte[1];
    }

    @Override
    public void createVisualAction(Channel channel, boolean stop, String actionType, int scriptLine, String scriptName, long timeline, boolean sync) {
        this.getDesktopDriver().createMobileRecord(stop, actionType, scriptLine, scriptName, timeline, channel.getName(), channel.getSubDimension(), this.getScreenshotPath(), sync);
    }

    private String getScreenshotPath() {
        return this.getApplicationPath() + SCREENSHOT_METHOD;
    }

    @Override
    public void api(ActionStatus status, ActionApi api) {
    }

    @Override
    public void switchWindow(ActionStatus status, int index, int tries) {
    }

    @Override
    public void closeWindow(ActionStatus status) {
    }

    @Override
    public Object executeScript(ActionStatus status, String script, Object ... params) {
        return null;
    }

    @Override
    public void goToUrl(ActionStatus status, String url) {
    }

    @Override
    public void waitAfterAction(ActionStatus status) {
    }

    @Override
    public void scroll(FoundElement element) {
    }

    @Override
    public void scroll(int value) {
    }

    @Override
    public void scroll(FoundElement element, int delta) {
    }

    @Override
    public void middleClick(ActionStatus status, MouseDirection position, TestElement element) {
    }

    @Override
    public void mouseMoveToElement(FoundElement element) {
    }

    @Override
    public void mouseMoveToElement(ActionStatus status, FoundElement foundElement, MouseDirection position, boolean desktopDragDrop, int offsetX, int offsetY) {
    }

    @Override
    public String setWindowBound(BoundData x, BoundData y, BoundData width, BoundData height) {
        return "";
    }

    @Override
    public void keyDown(Keys key) {
    }

    @Override
    public void keyUp(Keys key) {
    }

    @Override
    public void drop(MouseDirection md, boolean desktopDriver) {
    }

    @Override
    public void doubleClick() {
    }

    @Override
    public void rightClick() {
    }

    @Override
    public DialogBox switchToAlert() {
        return new MobileAlert(this);
    }

    public List<AtsMobileElement> getDialogBox() {
        this.refreshElementMapLocation();
        ArrayList<AtsMobileElement> list = new ArrayList<AtsMobileElement>();
        this.loadElementsByTag(this.rootElement.getValue(), "Alert", list);
        return list;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public boolean switchToDefaultContent() {
        return true;
    }

    @Override
    public void setWindowToFront() {
        String application = this.channel.getApplication();
        if (application != null) {
            this.executeRequest(APP, SWITCH, this.channel.getApplication());
        } else {
            this.executeRequest(APP, SWITCH);
        }
    }

    @Override
    public void switchToFrameId(String id) {
    }

    @Override
    public void updateDimensions() {
    }

    private AtsMobileElement getElementById(String id) {
        return this.getElementById(this.rootElement.getValue(), id);
    }

    private AtsMobileElement getElementById(AtsMobileElement root, String id) {
        if (root.getId().equals(id)) {
            return root;
        }
        for (AtsMobileElement elem : root.getChildren()) {
            elem.setParent(root);
            AtsMobileElement found = this.getElementById(elem, id);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public JsonObject executeRequest(String type, String ... data) {
        String url = this.applicationPath + "/" + type;
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        if (this.token != null) {
            requestBuilder.addHeader("Token", this.token);
        }
        Request request = requestBuilder.addHeader("User-Agent", this.userAgent).addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF8").post(RequestBody.create(null, (String)Stream.of(data).map(Object::toString).collect(Collectors.joining("\n")))).build();
        try {
            Response response = this.client.newCall(request).execute();
            String responseData = CharStreams.toString((Readable)new InputStreamReader(response.body().byteStream(), Charsets.UTF_8));
            response.close();
            return JsonParser.parseString((String)responseData).getAsJsonObject();
        }
        catch (JsonSyntaxException | IOException e) {
            return null;
        }
    }

    @Override
    public String getSource() {
        this.refreshElementMapLocation();
        return this.source.toString();
    }

    @Override
    public void windowState(ActionStatus status, Channel channel, String state) {
    }

    @Override
    public void setSysProperty(String propertyName, String propertyValue) {
        this.executeRequest(SET_PROP, propertyName, propertyValue);
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String script, TestElement element) {
        JsonObject result = (JsonObject)this.rootElement.scripting(script, element.getFoundElement());
        return this.handleResult(status, result);
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String script, boolean returnValue) {
        JsonObject result = (JsonObject)this.rootElement.scripting(script);
        return this.handleResult(status, result);
    }

    private Object handleResult(ActionStatus status, JsonObject result) {
        int code = result.get("status").getAsInt();
        String message = result.get("message").getAsString();
        if (code == 0) {
            status.setNoError(message);
        } else {
            status.setError(-13, message);
        }
        return result;
    }

    @Override
    protected void setPosition(org.openqa.selenium.Point pt) {
    }

    @Override
    protected void setSize(Dimension dim) {
    }

    @Override
    public int getNumWindows() {
        return 1;
    }

    @Override
    public String getUrl() {
        return this.applicationPath;
    }

    @Override
    public Rectangle getBoundRect(TestElement testElement) {
        return null;
    }
}

