/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines;

import com.ats.driver.ApplicationProperties;
import com.ats.driver.AtsManager;
import com.ats.element.AtsBaseElement;
import com.ats.element.AtsElement;
import com.ats.element.DialogBox;
import com.ats.element.FoundElement;
import com.ats.element.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.SendKeyData;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.DriverProcess;
import com.ats.executor.drivers.desktop.DesktopDriver;
import com.ats.executor.drivers.desktop.DesktopWindow;
import com.ats.executor.drivers.engines.DesktopDriverEngine;
import com.ats.executor.drivers.engines.DriverEngine;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.executor.drivers.engines.browsers.BrowserArgumentsParser;
import com.ats.generator.objects.Cartesian;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.objects.MouseDirectionData;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.script.actions.ActionApi;
import com.ats.tools.ResourceContent;
import com.ats.tools.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.MoveTargetOutOfBoundsException;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.support.ui.Select;

public class WebDriverEngine
extends DriverEngine
implements IDriverEngine {
    protected static final String WEB_ELEMENT_REF = "element-6066-11e4-a52e-4f735466cecf";
    private static final int DEFAULT_WAIT = 150;
    private static final int DEFAULT_PROPERTY_WAIT = 200;
    private static final String OPTION = "option";
    private static final String ANGULAR_OPTION = "mat-option";
    protected String JS_SCROLL_IF_NEEDED = "var e=arguments[0], result=[], r=e.getBoundingClientRect(), top0=r.top, left0=r.left; e.scrollIntoView({behavior:'instant',block:'center',inline:'nearest'});r=e.getBoundingClientRect();if(r.left!=left0 || r.top!=top0) {result=[r.left+0.0001, r.top+0.0001];}";
    protected static final String JS_ELEMENT_SCROLL = "var e=arguments[0];var d=arguments[1];e.scrollTop += d;var r=e.getBoundingClientRect();var result=[r.left+0.0001, r.top+0.0001]";
    protected static final String JS_WINDOW_SCROLL = "window.scrollBy(0,arguments[0]);var result=[0.0001, 0.0001]";
    protected static final String JS_ELEMENT_FROM_POINT = "var result=null;var e=document.elementFromPoint(arguments[0],arguments[1]);if(e){var r=e.getBoundingClientRect();result=[e, e.tagName, e.getAttribute('inputmode')=='numeric', e.getAttribute('type')=='password', r.x+0.0001, r.y+0.0001, r.width+0.0001, r.height+0.0001, r.left+0.0001, r.top+0.0001, 0.0001, 0.0001, {}];};";
    protected static final String JS_ELEMENT_FROM_RECT = "let x1=arguments[0],y1=arguments[1],w=arguments[2],h=arguments[3];let x2=x1+w,y2=y1+h;var e=document.elementFromPoint(x1+(w/2), y1+(h/2)),result=null;while(e != null){var r=e.getBoundingClientRect();if(x1 >= r.x && x2 <= r.x+r.width && y1 >= r.y && y2 <= r.y+r.height){result=[e,e.tagName,e.getAttribute('inputmode')=='numeric',e.getAttribute('type')=='password',r.x+0.0001,r.y+0.0001,r.width+0.0001,r.height+0.0001,r.left+0.0001,r.top+0.0001,0.0001,0.0001,{}];e=null;}else{e=e.parentElement;}};";
    protected static final String JS_ELEMENT_BOUNDING = "var rect=arguments[0].getBoundingClientRect();var result=[rect.left+0.0001, rect.top+0.0001];";
    protected static final String JS_MIDDLE_CLICK = "var evt=new MouseEvent('click', {bubbles: true,cancelable: true,view: window, button: 1}),result={};arguments[0].dispatchEvent(evt);";
    protected static final String JS_ELEMENT_CSS = "var result={};var o=getComputedStyle(arguments[0]);for(var i=0, len=o.length; i < len; i++){result[o[i]]=o.getPropertyValue(o[i]);};";
    protected static final String JS_SEARCH_ELEMENT = ResourceContent.getSearchElementsJavaScript();
    protected static final String JS_ELEMENT_AUTOSCROLL = ResourceContent.getScrollElementJavaScript();
    protected static final String JS_ELEMENT_ATTRIBUTES = ResourceContent.getElementAttributesJavaScript();
    protected static final String JS_ELEMENT_PARENTS = ResourceContent.getParentElementJavaScript();
    protected static final String JS_DOCUMENT_SIZE = ResourceContent.getDocumentSizeJavaScript();
    protected BrowserArgumentsParser browserArguments;
    protected Double initElementX = 0.0;
    protected Double initElementY = 0.0;
    protected DriverProcess driverProcess;
    private String browserName = "";
    protected Actions actions;
    protected URI driverSession;
    protected String searchElementScript = JS_SEARCH_ELEMENT;
    private WebElement iframe = null;
    private double offsetIframeX = 0.0;
    private double offsetIframeY = 0.0;

    public WebDriverEngine(Channel channel, DriverProcess driverProcess, DesktopDriver desktopDriver, ApplicationProperties props, int defaultWait, int defaultPropertyWait) {
        super(channel, desktopDriver, props, defaultWait, defaultPropertyWait);
        this.driverProcess = driverProcess;
    }

    public WebDriverEngine(Channel channel, String browser, DriverProcess driverProcess, DesktopDriver desktopDriver, ApplicationProperties props) {
        this(channel, driverProcess, desktopDriver, props, 150, 200);
        this.browserName = browser;
    }

    public WebDriverEngine(Channel channel, DesktopDriver desktopDriver, String application, ApplicationProperties props, int defaultWait, int defaultCheck) {
        super(channel, desktopDriver, props, defaultWait, defaultCheck);
    }

    protected boolean isHeadless() {
        return this.browserArguments.isHeadless();
    }

    protected DriverProcess getDriverProcess() {
        return this.driverProcess;
    }

    public void setDriverProcess(DriverProcess driverProcess) {
        this.driverProcess = driverProcess;
    }

    private RemoteWebDriver getRemoteDriver(Capabilities cap) {
        for (int maxTry = 20; maxTry > 0; --maxTry) {
            try {
                return new RemoteWebDriver(this.driverProcess.getDriverServerUrl(), cap);
            }
            catch (Exception ex) {
                this.channel.sleep(100);
                continue;
            }
        }
        try {
            return new RemoteWebDriver(this.driverProcess.getDriverLoopback(), cap);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void launchDriver(ActionStatus status, MutableCapabilities cap) {
        int maxTrySearch = AtsManager.getInstance().getMaxTrySearch();
        int maxTryProperty = AtsManager.getInstance().getMaxTryProperty();
        int scriptTimeout = AtsManager.getInstance().getScriptTimeOut();
        int pageLoadTimeout = AtsManager.getInstance().getPageloadTimeOut();
        int watchdog = AtsManager.getInstance().getWatchDogTimeOut();
        if (this.channel.getPerformance() == 1) {
            cap.setCapability("proxy", (Object)this.channel.startAtsProxy(AtsManager.getInstance()));
        } else if (this.channel.getPerformance() == 2) {
            this.channel.setNeoloadDesignApi(AtsManager.getInstance().getNeoloadDesignApi());
            cap.setCapability("proxy", (Object)AtsManager.getInstance().getNeoloadProxy().getValue());
        } else {
            cap.setCapability("proxy", (Object)AtsManager.getInstance().getProxy().getValue());
        }
        cap.setCapability("cssSelectorsEnabled", false);
        cap.setCapability("takesScreenshot", false);
        cap.setCapability("nativeEvents", true);
        cap.setCapability("pageLoadStrategy", (Object)PageLoadStrategy.NONE);
        this.driver = this.getRemoteDriver((Capabilities)cap);
        if (this.driver == null) {
            status.setTechnicalError(-19, "Unable to start remote driver");
            this.driverProcess.close(false);
            this.driver = null;
            return;
        }
        status.setPassed(true);
        this.actions = new Actions((WebDriver)this.driver);
        this.driver.manage().timeouts().setScriptTimeout((long)scriptTimeout, TimeUnit.SECONDS);
        this.driver.manage().timeouts().pageLoadTimeout((long)pageLoadTimeout, TimeUnit.SECONDS);
        String applicationVersion = null;
        String driverVersion = null;
        Map infos = this.driver.getCapabilities().asMap();
        for (Map.Entry entry : infos.entrySet()) {
            if ("browserVersion".equals(entry.getKey()) || "version".equals(entry.getKey())) {
                applicationVersion = entry.getValue().toString();
                continue;
            }
            if ("chrome".equals(entry.getKey())) {
                Map chromeData = (Map)entry.getValue();
                driverVersion = this.getDriverVersion((String)chromeData.get("chromedriverVersion"));
                continue;
            }
            if ("opera".equals(entry.getKey())) {
                Map operaData = (Map)entry.getValue();
                driverVersion = this.getDriverVersion((String)operaData.get("operadriverVersion"));
                continue;
            }
            if ("msedge".equals(entry.getKey())) {
                Map msedgeData = (Map)entry.getValue();
                driverVersion = this.getDriverVersion((String)msedgeData.get("msedgedriverVersion"));
                continue;
            }
            if (!"moz:geckodriverVersion".equals(entry.getKey())) continue;
            driverVersion = entry.getValue().toString();
        }
        String titleUid = UUID.randomUUID().toString();
        try {
            File startAtsPage = new File(System.getProperty("user.home") + File.separator + "ats_start_page.html");
            startAtsPage.deleteOnExit();
            Files.write(startAtsPage.toPath(), Utils.getAtsBrowserContent(titleUid, this.channel.getApplication(), this.applicationPath, applicationVersion, driverVersion, this.channel.getDimension(), this.getActionWait(), this.getPropertyWait(), maxTrySearch, maxTryProperty, scriptTimeout, pageLoadTimeout, watchdog, this.getDesktopDriver(), this.browserArguments.getUserDataPath()), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            this.driver.get(startAtsPage.toURI().toString());
        }
        catch (IOException e) {
            status.setTechnicalError(-19, e.getMessage());
            this.driverProcess.close(false);
            return;
        }
        String osVersion = this.getDesktopDriver().getOsName() + " (" + this.getDesktopDriver().getOsVersion() + ")";
        if (!this.isHeadless()) {
            int maxTry = 10;
            while (maxTry > 0) {
                DesktopWindow window = this.desktopDriver.getWindowByTitle(titleUid, this.browserName);
                if (window != null) {
                    this.desktopDriver.setEngine(new DesktopDriverEngine(this.channel, window));
                    this.channel.setApplicationData(osVersion, applicationVersion, driverVersion, window.getPid());
                    maxTry = 0;
                    continue;
                }
                this.channel.sleep(300);
                --maxTry;
            }
        }
        try {
            this.driverSession = new URI(this.driverProcess.getDriverServerUrl() + "/session/" + this.driver.getSessionId().toString());
        }
        catch (URISyntaxException maxTry) {
            // empty catch block
        }
        Dimension channelSize = this.channel.getDimension().getSize();
        try {
            if (channelSize.getWidth() == -1 && channelSize.getWidth() == -1) {
                ArrayList screen = (ArrayList)this.runJavaScript("var result=[screen.width, screen.height]", new Object[0]);
                this.channel.setFullScreenSize((Long)screen.get(0), (Long)screen.get(1));
            }
            this.driver.manage().window().setSize(this.channel.getDimension().getSize());
            this.driver.manage().window().setPosition(this.channel.getDimension().getPoint());
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    private String getDriverVersion(String value) {
        if (value != null) {
            return value.replaceFirst("\\(.*\\)", "").trim();
        }
        return null;
    }

    @Override
    public DesktopDriver getDesktopDriver() {
        return this.desktopDriver;
    }

    protected Channel getChannel() {
        return this.channel;
    }

    @Override
    public void waitAfterAction(ActionStatus status) {
        this.actionWait();
    }

    protected String[] getWindowsHandle(int index, int tries) {
        Set<String> list = this.getDriverWindowsList();
        for (int maxTry = 1 + tries; index >= list.size() && maxTry > 0; --maxTry) {
            this.channel.sleep(1000);
            list = this.getDriverWindowsList();
        }
        return list.toArray(new String[list.size()]);
    }

    protected Set<String> getDriverWindowsList() {
        try {
            return this.driver.getWindowHandles();
        }
        catch (WebDriverException e) {
            return Collections.emptySet();
        }
    }

    @Override
    public void scroll(int delta) {
        this.runJavaScript(JS_WINDOW_SCROLL, delta);
    }

    @Override
    public void scroll(FoundElement element, int delta) {
        if (delta == 0) {
            this.scroll(element);
        } else {
            ArrayList newPosition = (ArrayList)this.runJavaScript(JS_ELEMENT_SCROLL, element.getValue(), delta);
            this.updatePosition(newPosition, element);
        }
    }

    @Override
    public void scroll(FoundElement element) {
        this.updatePosition((ArrayList)this.runJavaScript(this.JS_SCROLL_IF_NEEDED, element.getValue()), element);
    }

    private void updatePosition(ArrayList<Double> position, FoundElement element) {
        if (position != null && position.size() > 1) {
            element.updatePosition(position.get(0), position.get(1), this.channel, 0.0, 0.0);
            this.channel.sleep(500);
        }
    }

    @Override
    public FoundElement getElementFromPoint(Boolean syscomp, Double x, Double y) {
        if (syscomp.booleanValue()) {
            return this.desktopDriver.getElementFromPoint(x, y);
        }
        this.switchToDefaultContent();
        x = x - this.channel.getSubDimension().getX();
        y = y - this.channel.getSubDimension().getY();
        return this.loadElement(new ArrayList<AtsElement>(), x, y, this.initElementX, this.initElementY);
    }

    private FoundElement loadElement(ArrayList<AtsElement> iframes, Double x, Double y, Double offsetX, Double offsetY) {
        ArrayList objectData = (ArrayList)this.runJavaScript(JS_ELEMENT_FROM_POINT, x - offsetX, y - offsetY);
        if (objectData != null) {
            AtsElement element = new AtsElement(objectData);
            if (element.isIframe()) {
                iframes.add(0, element);
                FoundElement frm = new FoundElement(element);
                this.switchToFrame(frm.getValue());
                offsetX = offsetX + element.getX();
                offsetY = offsetY + element.getY();
                return this.loadElement(iframes, x, y, offsetX, offsetY);
            }
            return new FoundElement(element, iframes, this.channel, offsetX, offsetY);
        }
        return null;
    }

    @Override
    public FoundElement getElementFromRect(Boolean syscomp, Double x, Double y, Double w, Double h) {
        if (syscomp.booleanValue()) {
            return this.desktopDriver.getElementFromRect(x, y, w, y);
        }
        this.switchToDefaultContent();
        x = x - this.channel.getSubDimension().getX() - this.channel.getDimension().getX();
        y = y - this.channel.getSubDimension().getY() - this.channel.getDimension().getY();
        return this.loadElement(new ArrayList<AtsElement>(), x, y, w, h, this.initElementX, this.initElementY);
    }

    private FoundElement loadElement(ArrayList<AtsElement> iframes, Double x, Double y, Double w, Double h, Double offsetX, Double offsetY) {
        ArrayList objectData = (ArrayList)this.runJavaScript(JS_ELEMENT_FROM_RECT, x - offsetX, y - offsetY, w, h);
        if (objectData != null) {
            AtsElement element = new AtsElement(objectData);
            if (element.isIframe()) {
                iframes.add(0, element);
                FoundElement frm = new FoundElement(element);
                this.switchToFrame(frm.getValue());
                offsetX = offsetX + element.getX();
                offsetY = offsetY + element.getY();
                return this.loadElement(iframes, x, y, w, h, offsetX, offsetY);
            }
            return new FoundElement(element, iframes, this.channel, offsetX, offsetY);
        }
        return null;
    }

    @Override
    public void loadParents(FoundElement hoverElement) {
        if (hoverElement.isDesktop()) {
            hoverElement.setParent(this.desktopDriver.getTestElementParent(hoverElement.getId(), this.channel));
        } else {
            hoverElement.setParent(this.getTestElementParent(hoverElement));
        }
    }

    @Override
    public WebElement getRootElement(Channel cnl) {
        WebElement body = this.getHtmlView();
        for (int maxTry = 20; body == null && maxTry > 0; --maxTry) {
            cnl.sleep(200);
            body = this.getHtmlView();
        }
        return body;
    }

    @Override
    public String getTitle() {
        return this.driver.getTitle();
    }

    private WebElement getHtmlView() {
        return (WebElement)this.driver.executeScript("return window.document.getElementsByTagName(\"html\")[0];", new Object[0]);
    }

    private RemoteWebElement getWebElement(FoundElement element) {
        return element.getRemoteWebElement(this.driver);
    }

    @Override
    public String getAttribute(ActionStatus status, FoundElement element, String attributeName, int maxTry) {
        for (int tryLoop = maxTry; tryLoop > 0; --tryLoop) {
            String result = this.getAttribute(status, element, attributeName);
            if (result != null && this.doubleCheckAttribute(status, result, element, attributeName)) {
                return result;
            }
            this.channel.sendWarningLog("Property not found", "" + tryLoop);
            this.channel.sleep(this.getPropertyWait());
        }
        return null;
    }

    @Override
    public List<String[]> loadSelectOptions(TestElement element) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (element.isAngularSelect()) {
            element.getWebElement().sendKeys(new CharSequence[]{Keys.TAB});
            element.click(this.channel.newActionStatus(), new MouseDirection());
            List<FoundElement> options = this.findMatSelectOptions(element);
            if (options != null && options.size() > 0) {
                options.stream().forEachOrdered(e -> result.add(new String[]{e.getValue().getText(), e.getValue().getText()}));
            }
        } else {
            List<FoundElement> options = this.findSelectOptions(null, element);
            if (options != null && options.size() > 0) {
                options.stream().forEachOrdered(e -> result.add(new String[]{e.getValue().getAttribute("value"), e.getValue().getAttribute("text")}));
            }
        }
        return result;
    }

    @Override
    public List<FoundElement> findSelectOptions(TestBound dimension, TestElement element) {
        return this.listElementsFound(this.runJavaScript(this.searchElementScript, element.getWebElement(), OPTION, new String[0], 0), Objects::nonNull);
    }

    public List<FoundElement> findMatSelectOptions(TestElement element) {
        this.switchToDefaultContent();
        return this.findElements(false, element, ANGULAR_OPTION, new String[0], new String[0], Objects::nonNull, null);
    }

    @Override
    public void selectOptionsItem(ActionStatus status, TestElement element, CalculatedProperty selectProperty) {
        block23: {
            if (element.isAngularSelect()) {
                element.getWebElement().sendKeys(new CharSequence[]{Keys.TAB});
                element.click(status, new MouseDirection());
                List<FoundElement> items = this.findMatSelectOptions(element);
                if (items != null && items.size() > 0) {
                    if ("index".equals(selectProperty.getName())) {
                        int index = Utils.string2Int(selectProperty.getValue().getCalculated());
                        if (items.size() > index) {
                            try {
                                items.get(index).getValue().click();
                            }
                            catch (Exception e2) {
                                status.setError(-3, e2.getMessage());
                            }
                        } else {
                            status.setError(-3, "index not found, max length options : " + items.size());
                        }
                    } else {
                        String searchedValue = selectProperty.getValue().getCalculated();
                        try {
                            if (selectProperty.isRegexp()) {
                                items.stream().filter(e -> e.getValue().getText().matches(searchedValue)).findFirst().get().getValue().click();
                                break block23;
                            }
                            items.stream().filter(e -> e.getValue().getText().equals(searchedValue)).findFirst().get().getValue().click();
                        }
                        catch (NoSuchElementException e3) {
                            status.setError(-3, "mat-option not found : " + searchedValue);
                        }
                    }
                }
            } else {
                List<FoundElement> items = this.findSelectOptions(null, element);
                if (items != null && items.size() > 0) {
                    element.click(status, new MouseDirection());
                    if ("index".equals(selectProperty.getName())) {
                        int index = Utils.string2Int(selectProperty.getValue().getCalculated());
                        if (items.size() > index) {
                            try {
                                items.get(index).getValue().click();
                            }
                            catch (Exception e4) {
                                new Select(items.get(index).getValue()).selectByIndex(index);
                            }
                        } else {
                            status.setError(-3, "index not found, max length options : " + items.size());
                        }
                    } else {
                        String attribute = selectProperty.getName();
                        String searchedValue = selectProperty.getValue().getCalculated();
                        Optional<FoundElement> foundOption = null;
                        foundOption = selectProperty.isRegexp() ? items.stream().filter(e -> e.getValue().getAttribute(attribute).matches(searchedValue)).findFirst() : items.stream().filter(e -> e.getValue().getAttribute(attribute).equals(searchedValue)).findFirst();
                        try {
                            foundOption.get().getValue().click();
                        }
                        catch (NoSuchElementException e5) {
                            status.setError(-3, "option not found : " + searchedValue);
                        }
                    }
                    try {
                        this.driver.executeScript("arguments[0].blur();", new Object[]{element.getWebElement()});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private boolean doubleCheckAttribute(ActionStatus status, String verify, FoundElement element, String attributeName) {
        this.channel.sleep(this.getPropertyWait());
        String current = this.getAttribute(status, element, attributeName);
        return current != null && current.equals(verify);
    }

    @Override
    public void setSysProperty(String propertyName, String propertyValue) {
    }

    private String getAttribute(ActionStatus status, FoundElement element, String attributeName) {
        RemoteWebElement elem = this.getWebElement(element);
        String result = elem.getAttribute(attributeName);
        if (result == null) {
            Object obj;
            for (CalculatedProperty calc : this.getAttributes(element, false)) {
                if (!attributeName.equals(calc.getName())) continue;
                return calc.getValue().getCalculated();
            }
            result = this.getCssAttributeValueByName(element, attributeName);
            if (result == null && (obj = this.executeJavaScript(status, attributeName, true)) != null) {
                result = obj.toString();
            }
        }
        return result;
    }

    private String getCssAttributeValueByName(FoundElement element, String name) {
        return this.foundAttributeValue(name, this.getCssAttributes(element));
    }

    private String foundAttributeValue(String name, CalculatedProperty[] properties) {
        Stream<CalculatedProperty> stream = Arrays.stream(properties);
        Optional<CalculatedProperty> calc = ((Stream)stream.parallel()).filter(c -> c.getName().equals(name)).findFirst();
        if (calc.isPresent()) {
            return calc.get().getValue().getCalculated();
        }
        return null;
    }

    @Override
    public CalculatedProperty[] getAttributes(FoundElement element, boolean reload) {
        if (element.isDesktop()) {
            return this.desktopDriver.getElementAttributes(element.getId());
        }
        return this.getAttributes(this.getWebElement(element));
    }

    @Override
    public CalculatedProperty[] getCssAttributes(FoundElement element) {
        return this.getCssAttributes(this.getWebElement(element));
    }

    private CalculatedProperty[] getCssAttributes(RemoteWebElement element) {
        return this.getAttributesList(element, JS_ELEMENT_CSS);
    }

    private CalculatedProperty[] getAttributes(RemoteWebElement element) {
        return this.getAttributesList(element, JS_ELEMENT_ATTRIBUTES);
    }

    private CalculatedProperty[] getAttributesList(RemoteWebElement element, String script) {
        Object result = this.runJavaScript(script, element);
        if (result != null && result instanceof Map) {
            return (CalculatedProperty[])((Stream)((Map)result).entrySet().stream().parallel()).filter(e -> !(e.getValue() instanceof Map)).map(e -> new CalculatedProperty((String)e.getKey(), e.getValue().toString())).toArray(CalculatedProperty[]::new);
        }
        return new CalculatedProperty[0];
    }

    public FoundElement getTestElementParent(FoundElement element) {
        ArrayList listElements = (ArrayList)this.runJavaScript(JS_ELEMENT_PARENTS, element.getValue());
        if (listElements != null && listElements.size() > 0) {
            return new FoundElement(this.channel, element.getIframes(), listElements.stream().map(e -> new AtsElement((List<Object>)e)).collect(Collectors.toCollection(ArrayList::new)), this.initElementX, this.initElementY);
        }
        return null;
    }

    @Override
    public void updateDimensions() {
        ArrayList response = (ArrayList)this.runJavaScript(JS_DOCUMENT_SIZE, new Object[0]);
        if (response != null && response.size() == 8) {
            this.channel.getDimension().update((Double)response.get(0), (Double)response.get(1), (Double)response.get(2), (Double)response.get(3));
            this.channel.getSubDimension().update((Double)response.get(4), (Double)response.get(5), (Double)response.get(6), (Double)response.get(7));
        }
    }

    @Override
    public synchronized void close(boolean keepRunning) {
        if (this.driver != null) {
            Arrays.asList(this.getWindowsHandle(0, 0)).stream().sorted(Collections.reverseOrder()).forEach(s -> this.closeWindowHandler((String)s));
            this.driver.quit();
            this.driver = null;
        }
        this.getDriverProcess().close(keepRunning);
    }

    @Override
    protected int getCartesianOffset(int value, MouseDirectionData direction, Cartesian cart1, Cartesian cart2, Cartesian cart3) {
        return super.getCartesianOffset(value, direction, cart1, cart2, cart3) - value / 2;
    }

    @Override
    public void mouseMoveToElement(FoundElement element) {
        try {
            this.move(element, 0, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseMoveToElement(ActionStatus status, FoundElement foundElement, MouseDirection position, boolean withDesktop, int offsetX, int offsetY) {
        this.channel.waitBeforeMouseMoveToElement(this);
        if (withDesktop) {
            this.desktopMoveToElement(foundElement, position, offsetX, offsetY);
        } else {
            int maxTry = 10;
            while (maxTry > 0) {
                status.setNoError();
                try {
                    this.scrollAndMove(foundElement, position, offsetX, offsetY);
                    maxTry = 0;
                }
                catch (StaleElementReferenceException e0) {
                    throw e0;
                }
                catch (JavascriptException e1) {
                    this.switchToDefaultContent();
                    status.setException(-13, (Exception)((Object)e1));
                    throw e1;
                }
                catch (MoveTargetOutOfBoundsException e2) {
                    this.driver.executeScript("arguments[0].scrollIntoView();", new Object[]{foundElement.getValue()});
                    maxTry = 0;
                }
                catch (WebDriverException e3) {
                    status.setException(-16, (Exception)((Object)e3));
                    this.channel.sleep(500);
                    --maxTry;
                }
            }
        }
    }

    private void scrollAndMove(FoundElement element, MouseDirection position, int offsetX, int offsetY) {
        this.scroll(element);
        this.channel.sleep(100);
        java.awt.Rectangle rect = element.getRectangle();
        this.move(element, this.getOffsetX(rect, position) + offsetX, this.getOffsetY(rect, position) + offsetY);
    }

    protected void move(FoundElement element, int offsetX, int offsetY) {
        block2: {
            try {
                this.actions.moveToElement(element.getValue(), offsetX, offsetY).perform();
            }
            catch (JavascriptException e) {
                if (e.getMessage().contains("elementsFromPoint")) break block2;
                throw e;
            }
        }
    }

    @Override
    public void mouseClick(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
        java.awt.Rectangle rect = element.getRectangle();
        try {
            this.click(element, this.getOffsetX(rect, position) + offsetX, this.getOffsetY(rect, position) + offsetY);
            status.setPassed(true);
        }
        catch (StaleElementReferenceException e1) {
            throw e1;
        }
        catch (ElementNotVisibleException e0) {
            status.setError(-2, "element is not visible");
        }
        catch (MoveTargetOutOfBoundsException e) {
            this.driver.executeScript("arguments[0].click();", new Object[]{element.getValue()});
        }
        catch (Exception e) {
            status.setException(-3, e);
        }
    }

    protected void click(FoundElement element, int offsetX, int offsetY) {
        this.actions.moveToElement(element.getValue(), offsetX, offsetY).click().build().perform();
    }

    @Override
    public void drag(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
        java.awt.Rectangle rect = element.getRectangle();
        try {
            this.actions.moveToElement(element.getValue(), this.getOffsetX(rect, position) + offsetX, this.getOffsetY(rect, position) + offsetY).clickAndHold(element.getValue()).build().perform();
            status.setPassed(true);
        }
        catch (StaleElementReferenceException e1) {
            throw e1;
        }
        catch (ElementNotVisibleException e0) {
            status.setError(-2, "element is not visible");
        }
        catch (Exception e) {
            status.setException(-3, e);
        }
    }

    @Override
    public void keyDown(Keys key) {
        this.actions.keyDown((CharSequence)key).perform();
    }

    @Override
    public void keyUp(Keys key) {
        this.actions.keyUp((CharSequence)key).perform();
    }

    @Override
    public void drop(MouseDirection md, boolean desktopDragDrop) {
        if (desktopDragDrop) {
            this.getDesktopDriver().mouseRelease();
        } else {
            this.actions.release().perform();
        }
    }

    @Override
    public void moveByOffset(int hDirection, int vDirection) {
        this.actions.moveByOffset(hDirection, vDirection).perform();
    }

    @Override
    public void doubleClick() {
        this.actions.doubleClick().perform();
    }

    @Override
    public void rightClick() {
        this.actions.contextClick().perform();
    }

    @Override
    public boolean switchToDefaultContent() {
        try {
            this.driver.switchTo().defaultContent();
            return true;
        }
        catch (WebDriverException e) {
            return false;
        }
    }

    @Override
    public void switchToFrameId(String id) {
        RemoteWebElement rwe = new RemoteWebElement();
        rwe.setId(id);
        rwe.setParent(this.driver);
        this.switchToFrame((WebElement)rwe);
    }

    protected void switchToFrame(WebElement we) {
        this.driver.switchTo().frame(we);
    }

    protected boolean switchToWindowHandle(String handle) {
        try {
            this.driver.switchTo().window(handle);
            this.channel.sleep(1000);
            return this.switchToDefaultContent();
        }
        catch (NoSuchWindowException ex) {
            return false;
        }
    }

    protected void switchToWindowIndex(String[] wins, int index) {
        int maxTry = 10;
        boolean switched = this.switchToWindowHandle(wins[index]);
        while (!switched && maxTry > 0) {
            this.channel.sleep(1000);
            wins = this.getWindowsHandle(index, 0);
            switched = this.switchToWindowHandle(wins[index]);
        }
        if (switched) {
            this.currentWindow = index;
        }
    }

    @Override
    public void setWindowToFront() {
        if (!this.isHeadless()) {
            this.channel.toFront();
            String[] wins = this.getWindowsHandle(0, 0);
            if (wins.length > this.currentWindow) {
                this.driver.switchTo().window(wins[this.currentWindow]);
                try {
                    this.driver.manage().window().setSize(this.channel.getDimension().getSize());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void switchWindow(ActionStatus status, int index, int tries) {
        this.channel.waitBeforeSwitchWindow(this);
        if (index >= 0) {
            String[] wins = this.getWindowsHandle(index, tries);
            if (wins.length > index) {
                this.switchToWindowIndex(wins, index);
                this.channel.cleanHandle();
                this.getDesktopDriver().updateWindowHandle(this.channel);
            } else {
                status.setError(-14, "cannot switch to window index '" + index + "', only " + wins.length + " window(s) found");
            }
        }
    }

    @Override
    protected void setPosition(Point pt) {
        this.channel.sleep(500);
        this.driver.manage().window().setPosition(pt);
    }

    @Override
    protected void setSize(Dimension dim) {
        this.channel.sleep(500);
        this.driver.manage().window().setSize(dim);
    }

    protected void closeWindowHandler(String windowHandle) {
        this.switchToWindowHandle(windowHandle);
        this.closeCurrentWindow();
    }

    protected void closeCurrentWindow() {
        this.driver.close();
        this.channel.sleep(300);
    }

    @Override
    public void closeWindow(ActionStatus status) {
        String[] list = this.getWindowsHandle(0, 0);
        if (list.length > 1) {
            if (this.currentWindow < list.length) {
                this.closeWindowHandler(list[this.currentWindow]);
                this.currentWindow = 0;
            }
            this.switchToWindowHandle(list[0]);
        }
    }

    @Override
    public Object executeScript(ActionStatus status, String javaScript, Object ... params) {
        Object result = this.runJavaScript(status, "var result={};" + javaScript + ";", params);
        if (status.isPassed() && result != null) {
            status.setMessage(result.toString());
        }
        return result;
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String javaScript, boolean returnValue) {
        try {
            if (returnValue) {
                Object result = this.driver.executeAsyncScript("var callback=arguments[arguments.length-1];var result=" + javaScript + ";callback(result);", new Object[0]);
                status.setMessage(result.toString());
                return result;
            }
            this.driver.executeScript(javaScript, new Object[0]);
            status.setPassed(true);
        }
        catch (StaleElementReferenceException e0) {
            throw e0;
        }
        catch (Exception e1) {
            status.setException(-13, e1);
        }
        return null;
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String javaScript, TestElement element) {
        return this.executeJavaScript(status, javaScript, element.getWebElement());
    }

    public Object executeJavaScript(ActionStatus status, String javaScript, WebElement element) {
        Object result = this.runJavaScript(status, "var e=arguments[0];var result=e." + javaScript.replaceAll("this", "e") + ";", element);
        if (status.isPassed() && result != null) {
            status.setMessage(result.toString());
        }
        return result;
    }

    public Object runJavaScript(String javaScript, Object ... params) {
        return this.runJavaScript(this.channel.newActionStatus(), javaScript, params);
    }

    public Object runJavaScriptResult(String javaScript) {
        try {
            return this.driver.executeAsyncScript("var result=" + javaScript + ";arguments[arguments.length-1](result);", new Object[0]);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    protected Object runJavaScript(ActionStatus status, String javaScript, Object ... params) {
        status.setPassed(true);
        try {
            return this.driver.executeAsyncScript(javaScript + ";arguments[arguments.length-1](result);", params);
        }
        catch (StaleElementReferenceException e0) {
            status.setPassed(false);
            throw e0;
        }
        catch (Exception e1) {
            status.setException(-13, e1);
            return null;
        }
    }

    public List<Double> getBoundingClientRect(RemoteWebElement element) {
        try {
            return (List)this.driver.executeAsyncScript("var callback=arguments[arguments.length-1], rect=arguments[0].getBoundingClientRect();var result=[rect.x+0.0001, rect.y+0.0001, rect.width+0.0001, rect.height+0.0001];callback(result);", new Object[]{element});
        }
        catch (Exception e) {
            return List.of(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.0), Double.valueOf(1.0));
        }
    }

    @Override
    public void goToUrl(ActionStatus status, String url) {
        this.channel.waitBeforeGotoUrl(this);
        if ("refresh".equals(url)) {
            this.driver.navigate().refresh();
        } else if ("next".equals(url)) {
            this.driver.navigate().forward();
        } else if ("back".equals(url)) {
            this.driver.navigate().back();
        } else {
            this.switchToDefaultContent();
            if (!(((String)url).startsWith("https://") || ((String)url).startsWith("http://") || ((String)url).startsWith("file://"))) {
                url = "http://" + (String)url;
            }
            this.loadUrl((String)url);
        }
        status.setPassed(true);
        status.setData(url);
        this.actionWait();
    }

    protected void loadUrl(String url) {
        this.driver.get(url);
    }

    @Override
    public List<FoundElement> findElements(boolean sysComp, TestElement testObject, String tagName, String[] attributes, String[] attributesValues, Predicate<AtsBaseElement> predicate, WebElement startElement) {
        if (testObject.getParent() != null) {
            if (testObject.getParent().isIframe()) {
                this.iframe = testObject.getParent().getWebElement();
                try {
                    Point pt = this.iframe.getLocation();
                    this.offsetIframeX += (double)pt.getX();
                    this.offsetIframeY += (double)pt.getY();
                    this.switchToFrame(this.iframe);
                }
                catch (WebDriverException e) {
                    return Collections.emptyList();
                }
            } else if (startElement == null) {
                startElement = testObject.getParent().getWebElement();
            }
        } else {
            if (this.iframe != null) {
                this.iframe = null;
                this.offsetIframeX = 0.0;
                this.offsetIframeY = 0.0;
            }
            if (!this.switchToDefaultContent()) {
                return Collections.emptyList();
            }
        }
        this.channel.waitBeforeSearchElement(this);
        return this.listElementsFound(this.runJavaScript(this.searchElementScript, startElement, tagName, attributes, attributes.length), predicate);
    }

    private List<FoundElement> listElementsFound(Object maps, Predicate<AtsBaseElement> predicate) {
        List objects = (List)maps;
        if (objects != null && objects.size() > 0) {
            List elements = objects.parallelStream().filter(Objects::nonNull).map(e -> new AtsElement((List<Object>)e)).collect(Collectors.toCollection(ArrayList::new));
            Stream<FoundElement> st = elements.parallelStream().filter(predicate).map(e -> new FoundElement(this, (AtsElement)e, this.channel, this.initElementX + this.offsetIframeX, this.initElementY + this.offsetIframeY, false));
            return st.collect(Collectors.toCollection(ArrayList::new));
        }
        return Collections.emptyList();
    }

    @Override
    public void middleClick(ActionStatus status, MouseDirection position, TestElement element) {
        this.runJavaScript(status, JS_MIDDLE_CLICK, element.getWebElement());
    }

    protected void middleClickSimulation(ActionStatus status, MouseDirection position, TestElement element) {
        element.click(status, position, Keys.CONTROL);
    }

    @Override
    public DialogBox switchToAlert() {
        this.channel.sleep(500);
        return new DialogBox(this.driver.switchTo().alert());
    }

    @Override
    public void clearText(ActionStatus status, TestElement te, MouseDirection md) {
        if (!te.isPreElement()) {
            te.click(status, md);
        }
        if (status.isPassed()) {
            FoundElement element = te.getFoundElement();
            try {
                this.executeScript(status, "arguments[0].value='';", element.getValue());
                status.setMessage("");
                return;
            }
            catch (StaleElementReferenceException staleElementReferenceException) {
                try {
                    element.getValue().clear();
                    status.setMessage("");
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        status.setError(-4, "clear text failed on this element");
    }

    @Override
    public void sendTextData(ActionStatus status, TestElement element, ArrayList<SendKeyData> textActionList) {
        this.channel.waitBeforeEnterText(this);
        WebElement we = element.getWebElement();
        if (element.isPreElement()) {
            StringBuilder seq = new StringBuilder();
            for (SendKeyData sequence : textActionList) {
                seq.append(this.getSequenceData(sequence));
            }
            this.executeScript(status, "arguments[0].textContent='" + seq.toString() + "';", we);
        } else {
            this.executeScript(status, "result={size:window.getComputedStyle(arguments[0], null).getPropertyValue('font-size'), family:window.getComputedStyle(arguments[0], null).getPropertyValue('font-family'), weight:window.getComputedStyle(arguments[0], null).getPropertyValue('font-weight')};", we);
            for (SendKeyData sequence : textActionList) {
                we.sendKeys(new CharSequence[]{this.getSequenceData(sequence)});
            }
        }
    }

    protected CharSequence getSequenceData(SendKeyData seq) {
        return seq.getSequenceWeb(true);
    }

    @Override
    public void refreshElementMapLocation() {
        this.getDesktopDriver().refreshElementMapLocation(this.channel);
    }

    @Override
    public String getSource() {
        return this.driver.getPageSource();
    }

    @Override
    public void api(ActionStatus status, ActionApi api) {
    }

    @Override
    public void buttonClick(ActionStatus status, String id) {
    }

    @Override
    public void tap(int count, FoundElement element) {
    }

    @Override
    public void press(int duration, ArrayList<String> paths, FoundElement element) {
    }

    @Override
    public void windowState(ActionStatus status, Channel channel, String state) {
        if ("maximize".equals(state)) {
            List screenSize = (List)this.runJavaScript(status, "result=[screen.width+0.0001, screen.height+0.0001];", new Object[0]);
            this.setPosition(new Point(0, 0));
            this.setSize(new Dimension(((Double)screenSize.get(0)).intValue(), ((Double)screenSize.get(1)).intValue()));
        } else {
            this.getDesktopDriver().windowState(status, channel, state);
        }
    }

    @Override
    public int getNumWindows() {
        try {
            return this.driver.getWindowHandles().size();
        }
        catch (WebDriverException e) {
            return 1;
        }
    }

    @Override
    public String getUrl() {
        return this.driver.getCurrentUrl();
    }

    @Override
    public java.awt.Rectangle getBoundRect(TestElement element) {
        Rectangle rect = element.getWebElement().getRect();
        return new java.awt.Rectangle(rect.x, rect.y, rect.width, rect.height);
    }
}

