/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.browsers;

import com.ats.driver.ApplicationProperties;
import com.ats.generator.variables.CalculatedValue;
import java.io.File;
import java.util.ArrayList;

public class BrowserArgumentsParser {
    private static final String INCOGNITO_OPTION = "incognito";
    private static final String PRIVATE_OPTION = "private";
    private static final String HEADLESS_OPTION = "headless";
    private String userDataPath;
    private String binaryPath;
    private boolean incognito = false;
    private boolean headless = false;
    private String[] moreOptions = null;

    public BrowserArgumentsParser(ArrayList<CalculatedValue> arguments, ApplicationProperties props, String browserName, String binary) {
        File browserBinaryFile;
        ArrayList<String> args = new ArrayList<String>();
        for (CalculatedValue calcv : arguments) {
            String arg = calcv.getCalculated();
            if (arg.startsWith("profile=") || arg.startsWith("profile:") || arg.startsWith("profile ")) {
                this.userDataPath = ApplicationProperties.getUserDataPath(arg.substring(8).trim(), browserName);
                continue;
            }
            if (arg.contains(HEADLESS_OPTION)) {
                this.headless = true;
                continue;
            }
            if (arg.contains(INCOGNITO_OPTION) || arg.contains(PRIVATE_OPTION)) {
                this.incognito = true;
                continue;
            }
            args.add(arg);
        }
        if (this.userDataPath == null) {
            this.userDataPath = props.getUserDataDirPath(browserName);
        }
        if (binary != null && (browserBinaryFile = new File(binary)).exists()) {
            this.binaryPath = browserBinaryFile.getAbsolutePath();
        }
        if (props.getOptions() != null) {
            for (String s : props.getOptions()) {
                if (s.length() <= 0) continue;
                if (INCOGNITO_OPTION.equals(s) || PRIVATE_OPTION.equals(s)) {
                    this.incognito = true;
                    continue;
                }
                if (s.contains(HEADLESS_OPTION)) {
                    this.headless = true;
                    continue;
                }
                if (s.length() <= 0) continue;
                args.add(s);
            }
        }
        if (args.size() > 0) {
            this.moreOptions = args.toArray(new String[args.size()]);
        }
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    public String[] getMoreOptions() {
        if (this.moreOptions == null) {
            return new String[0];
        }
        return this.moreOptions;
    }

    public String getUserDataPath() {
        return this.userDataPath;
    }

    public boolean isIncognito() {
        return this.incognito;
    }

    public boolean isHeadless() {
        return this.headless;
    }
}

