/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.browsers;

import com.ats.driver.ApplicationProperties;
import com.ats.executor.ActionStatus;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.DriverProcess;
import com.ats.executor.drivers.desktop.DesktopDriver;
import com.ats.executor.drivers.engines.WebDriverEngine;
import com.ats.executor.drivers.engines.browsers.BrowserArgumentsParser;
import com.ats.generator.objects.Cartesian;
import com.ats.generator.objects.MouseDirectionData;
import java.util.Collections;
import java.util.HashMap;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.opera.OperaOptions;

public class OperaDriverEngine
extends WebDriverEngine {
    public OperaDriverEngine(Channel channel, ActionStatus status, DriverProcess driverProcess, DesktopDriver windowsDriver, ApplicationProperties props) {
        super(channel, "opera", driverProcess, windowsDriver, props);
        this.initElementX = 20.0;
        this.browserArguments = new BrowserArgumentsParser(channel.getArguments(), props, "opera", this.applicationPath);
        OperaOptions options = new OperaOptions();
        if (this.browserArguments.getMoreOptions().length > 0) {
            for (String s : this.browserArguments.getMoreOptions()) {
                options.addArguments(new String[]{s});
            }
        } else {
            options.setCapability("opera.log.level", "SEVERE");
            options.addArguments(new String[]{"test-type"});
            options.addArguments(new String[]{"--disable-infobars"});
            options.addArguments(new String[]{"--disable-notifications"});
            options.addArguments(new String[]{"--no-default-browser-check"});
            options.addArguments(new String[]{"--allow-file-access-from-files"});
            options.addArguments(new String[]{"--allow-running-insecure-content"});
        }
        if (this.browserArguments.isIncognito()) {
            options.addArguments(new String[]{"--incognito"});
        }
        if (props.getDebugPort() > 0) {
            options.addArguments(new String[]{"--remote-debugging-port=" + props.getDebugPort()});
        }
        if (this.browserArguments.getUserDataPath() != null) {
            options.addArguments(new String[]{"--user-data-dir=" + this.browserArguments.getUserDataPath()});
        }
        if (this.lang != null) {
            options.addArguments(new String[]{"--lang=" + this.lang});
        }
        if (this.browserArguments.getBinaryPath() != null) {
            options.setBinary(this.browserArguments.getBinaryPath());
        }
        options.setExperimentalOption("excludeSwitches", Collections.singletonList("enable-automation"));
        HashMap<String, Boolean> prefs = new HashMap<String, Boolean>();
        prefs.put("credentials_enable_service", false);
        prefs.put("profile.password_manager_enabled", false);
        options.setExperimentalOption("prefs", prefs);
        this.launchDriver(status, (MutableCapabilities)options);
    }

    @Override
    protected int getCartesianOffset(int value, MouseDirectionData direction, Cartesian cart1, Cartesian cart2, Cartesian cart3) {
        return super.getCartesianOffset(value, direction, cart1, cart2, cart3) + value / 2;
    }
}

