/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.desktop;

import com.ats.driver.ApplicationProperties;
import com.ats.executor.ActionStatus;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.desktop.DesktopDriver;
import com.ats.executor.drivers.engines.DesktopDriverEngine;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class ExplorerDriverEngine
extends DesktopDriverEngine {
    private static final int DEFAULT_WAIT = 100;
    private Desktop desktop;

    public ExplorerDriverEngine(Channel channel, ActionStatus status, DesktopDriver desktopDriver, ApplicationProperties props) {
        super(channel, desktopDriver, props, 100);
        String folderName = "";
        try {
            File folder = Files.createTempDirectory("ats_", new FileAttribute[0]).toFile();
            folder.deleteOnExit();
            folderName = folder.getName();
            this.desktop = Desktop.getDesktop();
            this.desktop.open(folder);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int maxTry = 10;
        while (maxTry > 0) {
            this.window = desktopDriver.getWindowByTitle(folderName, "explorer");
            if (this.window != null) {
                channel.setApplicationData("explorer", this.window.getHandle());
                desktopDriver.moveWindow(channel, channel.getDimension().getPoint());
                desktopDriver.resizeWindow(channel, channel.getDimension().getSize());
                maxTry = 0;
                continue;
            }
            channel.sleep(300);
            --maxTry;
        }
    }

    @Override
    public void close(boolean keepRunning) {
        this.getDesktopDriver().closeWindow(this.window.getHandle());
    }
}

