/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.mobiles;

import com.ats.element.AtsMobileElement;
import com.ats.element.FoundElement;
import com.ats.element.MobileTestElement;
import com.ats.element.StructDebugDescription;
import com.ats.executor.ActionStatus;
import com.ats.executor.drivers.engines.MobileDriverEngine;
import com.ats.executor.drivers.engines.mobiles.RootElement;
import com.ats.generator.objects.MouseDirection;
import com.google.gson.JsonObject;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nonnull;

public class IosRootElement
extends RootElement {
    private final String regexSpaces = "^\\s+";
    private final String regexBraces = "[{},]+";
    private Double deviceWidth = 0.0;
    private Double deviceHeight = 0.0;
    private Double ratioWidth = 1.0;
    private Double ratioHeight = 1.0;

    public IosRootElement(MobileDriverEngine driver) {
        super(driver);
    }

    @Override
    public MobileTestElement getCurrentElement(FoundElement element, MouseDirection position) {
        Rectangle rect = element.getRectangle();
        String coordinates = element.getX() + ";" + element.getY() + ";" + element.getWidth() + ";" + element.getHeight() + ";" + this.getRatioWidth() + ";" + this.getRatioHeight();
        return new MobileTestElement(element.getId(), this.driver.getOffsetX(rect, position), this.driver.getOffsetY(rect, position), coordinates);
    }

    @Override
    public void tap(ActionStatus status, FoundElement element, MouseDirection position) {
        Rectangle rect = element.getRectangle();
        String coordinates = element.getX() + ";" + element.getY() + ";" + element.getWidth() + ";" + element.getHeight() + ";" + this.getRatioWidth() + ";" + this.getRatioHeight();
        this.driver.executeRequest("element", element.getId(), "tap", "" + this.driver.getOffsetX(rect, position), "" + this.driver.getOffsetY(rect, position), coordinates);
    }

    @Override
    public void tap(FoundElement element, int count) {
        if (element.getParent() != null) {
            this.driver.executeRequest("element", element.getId(), "tap", String.valueOf(count));
        }
    }

    @Override
    public void press(FoundElement element, ArrayList<String> paths, int duration) {
        this.driver.executeRequest("element", element.getId(), "tap", String.valueOf(paths), String.valueOf(duration));
    }

    @Override
    public void swipe(MobileTestElement testElement, int hDirection, int vDirection) {
        this.driver.executeRequest("element", testElement.getId(), "swipe", "" + testElement.getOffsetX(), "" + testElement.getOffsetY(), "" + hDirection, "" + vDirection, testElement.getCoordinates());
    }

    @Override
    public Object scripting(String script, FoundElement element) {
        String coordinates = element.getX() + ";" + element.getY() + ";" + element.getWidth() + ";" + element.getHeight() + ";" + this.getRatioWidth() + ";" + this.getRatioHeight();
        return this.driver.executeRequest("element", element.getId(), "scripting", "0", "0", coordinates, script);
    }

    @Override
    public Object scripting(String script) {
        return this.scripting(script, this.getValue().getFoundElement());
    }

    @Override
    public void refresh(@Nonnull JsonObject jsonObject) {
        AtsMobileElement[] frontElements;
        this.deviceHeight = jsonObject.get("deviceHeight").getAsDouble();
        this.deviceWidth = jsonObject.get("deviceWidth").getAsDouble();
        String debugDescription = jsonObject.get("root").getAsString();
        String[] debugDescriptionArray = debugDescription.split("\n");
        Double width = 0.0;
        Double height = 0.0;
        ArrayList<StructDebugDescription> elementInfoArray = new ArrayList<StructDebugDescription>();
        for (String item : debugDescriptionArray) {
            int level = this.countSpaces(item);
            if (level < 4 || item.contains("Application, pid:")) continue;
            String trimmedLine = item.replaceAll("^\\s+", "");
            if (trimmedLine.startsWith("Window (Main)")) {
                String regexBracesAndSpaces = "[\\s{},]+";
                String[] arraySize = trimmedLine.split(regexBracesAndSpaces);
                width = Double.parseDouble(arraySize[arraySize.length - 2]);
                height = Double.parseDouble(arraySize[arraySize.length - 1]);
            }
            elementInfoArray.add(new StructDebugDescription(level / 2 - 1, trimmedLine));
        }
        if (!height.equals(this.deviceHeight) || !width.equals(this.deviceWidth)) {
            this.ratioHeight = this.deviceHeight / height;
            this.ratioWidth = this.deviceWidth / width;
            width = width * this.ratioWidth;
            height = height * this.ratioHeight;
        }
        AtsMobileElement rootElement = new AtsMobileElement(UUID.randomUUID().toString(), "root", width, height, 0.0, 0.0, false, new HashMap<String, String>());
        int currentElementIndex = 0;
        for (StructDebugDescription elementInfo : elementInfoArray) {
            String[] arraySize = elementInfo.getContent().split("[{},]+");
            String tag = arraySize[0].replaceAll("^\\s+", "");
            ArrayList<String> stringArray = new ArrayList<String>();
            for (String s : arraySize) {
                if (s.replaceAll("^\\s+", "").equals("")) continue;
                stringArray.add(s);
            }
            int firstSizeIndex = 2;
            if (elementInfo.getContent().contains("pid:")) {
                ++firstSizeIndex;
            }
            double currentX = Double.parseDouble((String)stringArray.get(firstSizeIndex)) * this.ratioWidth;
            double currentY = Double.parseDouble((String)stringArray.get(firstSizeIndex + 1)) * this.ratioHeight;
            double currentWidth = Double.parseDouble((String)stringArray.get(firstSizeIndex + 2)) * this.ratioWidth;
            double currentHeight = Double.parseDouble((String)stringArray.get(firstSizeIndex + 3)) * this.ratioHeight;
            AtsMobileElement element = new AtsMobileElement(elementInfo.getUuid().toString(), tag, currentWidth, currentHeight, currentX, currentY, true, this.getAttributes(elementInfo.getContent()));
            if (elementInfo.getLevel() == 1) {
                rootElement.addChildren(element);
            } else {
                int i = currentElementIndex;
                UUID uuidParent = null;
                while (i - 1 > -1) {
                    if (((StructDebugDescription)elementInfoArray.get(i - 1)).getLevel() + 1 == elementInfo.getLevel()) {
                        uuidParent = ((StructDebugDescription)elementInfoArray.get(i - 1)).getUuid();
                        break;
                    }
                    --i;
                }
                if (uuidParent != null) {
                    this.searchAndAdd(uuidParent.toString(), rootElement, element);
                }
            }
            ++currentElementIndex;
        }
        AtsMobileElement[] rootElementChildren = rootElement.getChildren();
        if (rootElementChildren != null && rootElementChildren.length > 0 && (frontElements = rootElementChildren[0].getChildren()) != null && frontElements.length > 1) {
            AtsMobileElement lastElement = frontElements[frontElements.length - 1];
            boolean containsElements = this.checkConsistency(lastElement.getChildren(), false);
            if (containsElements) {
                rootElement.getChildren()[0].setChildren(lastElement.getChildren());
            } else {
                rootElement.getChildren()[0].setChildren(frontElements[0].getChildren());
            }
        }
        this.value = rootElement;
    }

    public boolean checkConsistency(AtsMobileElement[] child, boolean val) {
        for (AtsMobileElement atsMobileElement : child) {
            if (atsMobileElement != null && atsMobileElement.getChildren().length > 0) {
                val = this.checkConsistency(atsMobileElement.getChildren(), val);
                continue;
            }
            if (atsMobileElement == null || atsMobileElement.getTag().equalsIgnoreCase("other")) continue;
            val = true;
        }
        return val;
    }

    public AtsMobileElement[] fixErrorsInDOM(AtsMobileElement domStructure) {
        AtsMobileElement[] childrens = domStructure.getChildren();
        for (int i = 0; i < childrens.length; ++i) {
            if (childrens[i] != null && childrens[i].getChildren().length > 0) {
                childrens[i].setChildren(this.fixErrorsInDOM(childrens[i]));
                if (childrens[i].getChildren().length != 0 || !childrens[i].getTag().equalsIgnoreCase("other")) continue;
                childrens = IosRootElement.removeTheElement(childrens, i);
                --i;
                continue;
            }
            if (childrens[i] == null || !childrens[i].getTag().equalsIgnoreCase("other") || childrens[i].getChildren().length != 0) continue;
            childrens = IosRootElement.removeTheElement(childrens, i);
            --i;
        }
        if (childrens.length == 0) {
            return null;
        }
        return childrens;
    }

    public static AtsMobileElement[] removeTheElement(AtsMobileElement[] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return arr;
        }
        AtsMobileElement[] anotherArray = new AtsMobileElement[arr.length - 1];
        int k = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (i == index) continue;
            anotherArray[k++] = arr[i];
        }
        return anotherArray;
    }

    public Double getDeviceWidth() {
        return this.deviceWidth;
    }

    public Double getDeviceHeight() {
        return this.deviceHeight;
    }

    public Double getRatioWidth() {
        return this.ratioWidth;
    }

    public Double getRatioHeight() {
        return this.ratioHeight;
    }

    private Map<String, String> getAttributes(String str) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        String[] arraySize = str.split("[{},]+");
        if (arraySize[0].contains("checkbox")) {
            result.put("checkable", "true");
        } else {
            result.put("checkable", "false");
        }
        for (String s : arraySize) {
            String cleanString = this.cleanAttribute(s);
            if (s.contains("label")) {
                result.put("text", cleanString);
            }
            if (s.contains("placeholderValue")) {
                result.put("description", cleanString);
            }
            if (s.contains("identifier")) {
                result.put("identifier", cleanString);
            }
            if (s.contains("value")) {
                result.put("value", cleanString);
            }
            if (s.contains("Disabled")) {
                result.put("enabled", "false");
                result.put("editable", "false");
            }
            if (!s.contains("Selected")) continue;
            result.put("selected", "true");
        }
        if (!result.containsKey("text")) {
            result.put("text", "");
        }
        if (!result.containsKey("description")) {
            result.put("description", "");
        }
        if (!result.containsKey("identifier")) {
            result.put("identifier", "");
        }
        if (!result.containsKey("value")) {
            result.put("value", "");
        }
        if (!result.containsKey("enabled")) {
            result.put("enabled", "true");
            result.put("editable", "true");
        }
        if (!result.containsKey("selected")) {
            result.put("selected", "false");
        }
        if (!result.containsKey("numeric")) {
            result.put("numeric", "false");
        }
        return result;
    }

    private String cleanAttribute(String str) {
        return str.split(":")[str.split(":").length - 1].replace("'", "").replaceAll("^\\s+", "");
    }

    private int countSpaces(String str) {
        int count = 0;
        for (int i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
            ++count;
        }
        return count;
    }

    private void searchAndAdd(String uuid, AtsMobileElement node, AtsMobileElement elementToAdd) {
        if (node.getId().equals(uuid)) {
            node.addChildren(elementToAdd);
        } else {
            AtsMobileElement[] childs = node.getChildren();
            if (childs != null) {
                for (int i = 0; i < node.getChildren().length; ++i) {
                    this.searchAndAdd(uuid, node.getChildren()[i], elementToAdd);
                }
            }
        }
    }
}

