/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator;

import com.ats.driver.AtsManager;
import com.ats.generator.Generator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AntCompiler {
    public static final String XML_SUITE_FILES = "-suiteXmlFiles=";

    public static void main(String[] args) throws IOException {
        if (args.length > 0) {
            File buildFile = new File(args[0]);
            if (!buildFile.exists()) {
                buildFile.getParentFile().mkdirs();
                FileWriter fw = new FileWriter(buildFile);
                fw.write("<project basedir=\".\" default=\"compile\">");
                fw.write("<copy todir=\"classes\"> ");
                fw.write("<fileset dir=\"..\\src\" includes='assets/**'/>");
                fw.write("</copy>");
                fw.write("<property name=\"lib.dir\" value=\"lib\"/>");
                fw.write("<path id=\"classpath\">");
                fw.write("<fileset dir=\"" + AtsManager.getAtsHomeFolder() + "\\libs\" includes=\"**/*.jar\"/>");
                fw.write("</path>");
                fw.write("<target name=\"compile\">");
                fw.write("<mkdir dir=\"classes\"/>");
                fw.write("<javac srcdir=\"generated\" destdir=\"classes\" classpathref=\"classpath\"/>");
                fw.write("</target>");
                fw.write("</project>");
                fw.close();
            }
            if (args.length > 1 && args[1].startsWith(XML_SUITE_FILES)) {
                String[] suites = args[1].replace(XML_SUITE_FILES, "").split(",");
                Path projectFolderPath = buildFile.getParentFile().toPath();
                FileWriter fw = new FileWriter(projectFolderPath.resolve("suites.xml").toFile());
                fw.write("<!DOCTYPE suite SYSTEM \"https://testng.org/testng-1.0.dtd\">");
                fw.write("<suite name=\"allSuites\">");
                fw.write("<suite-files>");
                for (int i = 0; i < suites.length; ++i) {
                    String suitePath = Generator.findSuiteFile(suites[i]);
                    if (suitePath == null) continue;
                    fw.write("<suite-file path=\"" + suitePath + "\"/>");
                }
                fw.write("</suite-files>");
                fw.write("</suite>");
                fw.close();
                System.out.println("[ATS] " + suites.length + " suite(s) added to job execution");
            }
            new AntCompiler(buildFile);
        }
    }

    public AntCompiler(File buildFile) {
        Project p = new Project();
        p.setUserProperty("ant.file", buildFile.getAbsolutePath());
        p.init();
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        p.addReference("ant.projectHelper", (Object)helper);
        helper.parse(p, (Object)buildFile);
        DefaultLogger consoleLogger = new DefaultLogger();
        consoleLogger.setErrorPrintStream(System.err);
        consoleLogger.setOutputPrintStream(System.out);
        consoleLogger.setMessageOutputLevel(2);
        p.addBuildListener((BuildListener)consoleLogger);
        p.executeTarget(p.getDefaultTarget());
    }
}

