/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.transform;

import com.ats.generator.variables.transform.Transformer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.text.StringEscapeUtils;

public class RegexpTransformer
extends Transformer {
    private int group = 0;
    private String pattern = "(.*)";

    public RegexpTransformer() {
    }

    public RegexpTransformer(String pattern, int group) {
        this.setPattern(pattern);
        this.setGroup(group);
    }

    public RegexpTransformer(String data) {
        int lastComa = data.lastIndexOf(",");
        try {
            this.setGroup(this.getInt(data.substring(lastComa + 1).trim()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.setPattern(data.substring(0, lastComa).trim());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public String getJavaCode() {
        return "rx(\"" + StringEscapeUtils.escapeJava((String)this.pattern) + "\", " + this.group + ")";
    }

    @Override
    public String format(String data) {
        if (data.length() > 0) {
            try {
                Pattern patternComp = Pattern.compile(this.pattern);
                Matcher m = patternComp.matcher(data);
                if (m.find()) {
                    return m.group(this.group);
                }
            }
            catch (PatternSyntaxException e) {
                return "#REGEXP_ERROR# (Pattern syntax error) " + this.pattern;
            }
            catch (IndexOutOfBoundsException e) {
                return "#REGEXP_ERROR# (Group index out of bound) " + this.pattern;
            }
        }
        return "";
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

